/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.InfoBoxCallbackListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.PropertyFieldFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.EntityTypePropertyTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.SectionSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.InfoBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class PropertyTypeAssignmentForm
extends LayoutContainer
implements IDatabaseModificationObserver {
    private static final String UNSUPPORTED_ENTITY_KIND = "Unsupported entity kind";
    private static final int LABEL_WIDTH = 130;
    private static final int FIELD_WIDTH = 400;
    private static final String PREFIX = "property-type-assignment_";
    public static final String ID_PREFIX = "openbis_property-type-assignment_";
    public static final String PROPERTY_TYPE_ID_SUFFIX = "property_type";
    public static final String SAMPLE_TYPE_ID_SUFFIX = "openbis_property-type-assignment_sample_type";
    public static final String EXPERIMENT_TYPE_ID_SUFFIX = "openbis_property-type-assignment_experiment_type";
    public static final String MATERIAL_TYPE_ID_SUFFIX = "openbis_property-type-assignment_material_type";
    public static final String DATA_SET_TYPE_ID_SUFFIX = "openbis_property-type-assignment_data_set_type";
    public static final String MANDATORY_CHECKBOX_ID_SUFFIX = "mandatory_checkbox";
    public static final String SAVE_BUTTON_ID_SUFFIX = "save-button";
    protected static final String DEFAULT_VALUE_ID_PART = "default_value";
    protected static final String SECTION_VALUE_ID_PART = "section_value";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private SampleTypeSelectionWidget sampleTypeSelectionWidget;
    private ExperimentTypeSelectionWidget experimentTypeSelectionWidget;
    private MaterialTypeSelectionWidget materialTypeSelectionWidget;
    private DataSetTypeSelectionWidget dataSetTypeSelectionWidget;
    private PropertyTypeSelectionWidget propertyTypeSelectionWidget;
    private DatabaseModificationAwareField<?> defaultValueField;
    private CheckBox mandatoryCheckbox;
    private CheckBox scriptableCheckbox;
    private CheckBox shownInEditViewCheckBox;
    private CheckBox showRawValueCheckBox;
    private SectionSelectionWidget sectionSelectionWidget;
    private EntityTypePropertyTypeSelectionWidget etptSelectionWidget;
    private Button saveButton;
    private final InfoBox infoBox;
    private final FormPanel formPanel;
    private final CompositeDatabaseModificationObserver modificationManager;
    private final EntityKind entityKind;
    private final ScriptChooserField scriptChooser;
    private Radio scriptTypeManaged;
    private Radio scriptTypeDynamic;
    private final RadioGroup scriptTypeRadioGroup;
    private boolean userDidChangeShownInEditViewCheckBox = false;
    private boolean userDidChangeShowRawValueCheckBox = false;
    private boolean synchronizingGuiFields = false;

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind) {
        PropertyTypeAssignmentForm form = new PropertyTypeAssignmentForm(viewContext, entityKind);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form.modificationManager);
    }

    private PropertyTypeAssignmentForm(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind) {
        this.entityKind = entityKind;
        this.modificationManager = new CompositeDatabaseModificationObserver();
        this.setLayout((Layout)new FlowLayout(5));
        this.setId(PropertyTypeAssignmentForm.createId(entityKind));
        this.viewContext = viewContext;
        this.setScrollMode(Style.Scroll.AUTO);
        this.infoBox = PropertyTypeAssignmentForm.createInfoBox(viewContext);
        this.add((Widget)this.infoBox);
        this.formPanel = this.createFormPanel();
        this.add((Component)this.formPanel);
        this.scriptTypeRadioGroup = this.createScriptTypeRadioGroup();
        this.scriptChooser = PropertyTypeAssignmentForm.createScriptChooserField(viewContext, this.createScriptTypeProvider(), entityKind);
    }

    private ScriptChooserField.IScriptTypeProvider createScriptTypeProvider() {
        return new ScriptChooserField.IScriptTypeProvider(){

            @Override
            public ScriptType tryGetScriptType() {
                return PropertyTypeAssignmentForm.this.isManaged() ? ScriptType.MANAGED_PROPERTY : ScriptType.DYNAMIC_PROPERTY;
            }
        };
    }

    private static ScriptChooserField createScriptChooserField(IViewContext<ICommonClientServiceAsync> viewContext, ScriptChooserField.IScriptTypeProvider scriptTypeProvider, EntityKind entityKindOrNull) {
        ScriptChooserField field = ScriptChooserField.create(viewContext.getMessage("plugin", new Object[0]), true, null, viewContext, scriptTypeProvider, entityKindOrNull);
        field.setId("openbis_property-type-assignment_script_chooser");
        FieldUtil.setVisibility(false, new Field[]{field});
        return field;
    }

    public static final String createId(EntityKind entityKind) {
        return ID_PREFIX + entityKind.name();
    }

    private String createChildId(String childSuffix) {
        return String.valueOf(this.getId()) + childSuffix;
    }

    private static final InfoBox createInfoBox(IMessageProvider messageProvider) {
        InfoBox infoBox = new InfoBox(messageProvider);
        return infoBox;
    }

    private final RadioGroup createScriptTypeRadioGroup() {
        RadioGroup result = new RadioGroup();
        result.setSelectionRequired(true);
        result.setVisible(false);
        result.setOrientation(Style.Orientation.HORIZONTAL);
        this.scriptTypeManaged = this.createRadio(ScriptType.MANAGED_PROPERTY.getDescription());
        this.scriptTypeManaged.setId("openbis_property-type-assignment_managed_radio");
        this.scriptTypeDynamic = this.createRadio(ScriptType.DYNAMIC_PROPERTY.getDescription());
        this.scriptTypeDynamic.setId("openbis_property-type-assignment_dynamic_radio");
        result.add(this.scriptTypeManaged);
        result.add(this.scriptTypeDynamic);
        FieldUtil.setValueWithoutEvents(result, this.scriptTypeManaged);
        result.setLabelSeparator("");
        result.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                PropertyTypeAssignmentForm.this.scriptChooser.setRawValue("");
                PropertyTypeAssignmentForm.this.updateVisibilityOfShownInEditViewField();
                PropertyTypeAssignmentForm.this.updateVisibilityOfShowRawValueField();
            }
        });
        return result;
    }

    private final Radio createRadio(String label) {
        Radio result = new Radio();
        result.setBoxLabel(label);
        return result;
    }

    private PropertyTypeSelectionWidget getPropertyTypeWidget() {
        if (this.propertyTypeSelectionWidget == null) {
            this.propertyTypeSelectionWidget = new PropertyTypeSelectionWidget(this.viewContext, this.createChildId(PROPERTY_TYPE_ID_SUFFIX));
            this.propertyTypeSelectionWidget.addListener(Events.Focus, new AbstractRegistrationForm.InfoBoxResetListener(this.infoBox));
            FieldUtil.markAsMandatory(this.propertyTypeSelectionWidget);
            this.propertyTypeSelectionWidget.addListener(Events.SelectionChange, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    PropertyTypeAssignmentForm.this.updatePropertyTypeRelatedFields();
                }
            });
        }
        return this.propertyTypeSelectionWidget;
    }

    private DropDownList<?, ?> getTypeSelectionWidget() {
        DropDownList result = null;
        boolean created = false;
        switch (this.entityKind) {
            case EXPERIMENT: {
                if (this.experimentTypeSelectionWidget == null) {
                    this.experimentTypeSelectionWidget = new ExperimentTypeSelectionWidget(this.viewContext, EXPERIMENT_TYPE_ID_SUFFIX, null);
                    created = true;
                }
                result = this.experimentTypeSelectionWidget;
                break;
            }
            case SAMPLE: {
                if (this.sampleTypeSelectionWidget == null) {
                    this.sampleTypeSelectionWidget = new SampleTypeSelectionWidget(this.viewContext, SAMPLE_TYPE_ID_SUFFIX, false, SampleTypeDisplayID.PROPERTY_ASSIGNMENT, null);
                    created = true;
                }
                result = this.sampleTypeSelectionWidget;
                break;
            }
            case MATERIAL: {
                if (this.materialTypeSelectionWidget == null) {
                    this.materialTypeSelectionWidget = new MaterialTypeSelectionWidget(this.viewContext, null, MATERIAL_TYPE_ID_SUFFIX, false);
                    created = true;
                }
                result = this.materialTypeSelectionWidget;
                break;
            }
            case DATA_SET: {
                if (this.dataSetTypeSelectionWidget == null) {
                    this.dataSetTypeSelectionWidget = new DataSetTypeSelectionWidget(this.viewContext, DATA_SET_TYPE_ID_SUFFIX);
                    created = true;
                }
                result = this.dataSetTypeSelectionWidget;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException(UNSUPPORTED_ENTITY_KIND);
        }
        if (created) {
            FieldUtil.markAsMandatory(result);
            result.addListener(Events.Focus, new AbstractRegistrationForm.InfoBoxResetListener(this.infoBox));
            result.addListener(Events.SelectionChange, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    PropertyTypeAssignmentForm.this.updateEntityTypePropertyTypeRelatedFields();
                }
            });
        }
        return result;
    }

    private void updateVisibilityOfScriptRelatedFields() {
        boolean scriptable = this.isScriptable();
        FieldUtil.setVisibility(scriptable, new Field[]{this.scriptTypeRadioGroup, this.scriptChooser});
        if (this.defaultValueField != null) {
            FieldUtil.setVisibility(!scriptable, (Field)this.defaultValueField.get());
        }
        if (this.mandatoryCheckbox != null) {
            FieldUtil.setVisibility(!scriptable, new Field[]{this.mandatoryCheckbox});
        }
        this.updateVisibilityOfShownInEditViewField();
        this.updateVisibilityOfShowRawValueField();
    }

    private void updateVisibilityOfShownInEditViewField() {
        if (this.shownInEditViewCheckBox != null) {
            FieldUtil.setVisibility(this.isManaged(), new Field[]{this.shownInEditViewCheckBox});
        }
    }

    private void updateVisibilityOfShowRawValueField() {
        if (this.showRawValueCheckBox != null) {
            FieldUtil.setVisibility(this.isManaged() && this.isShownInEditView(), new Field[]{this.showRawValueCheckBox});
        }
    }

    private CheckBox getMandatoryCheckbox() {
        if (this.mandatoryCheckbox == null) {
            this.mandatoryCheckbox = new CheckBoxField(this.viewContext.getMessage("mandatory", new Object[0]), false);
            this.mandatoryCheckbox.setId(this.createChildId(MANDATORY_CHECKBOX_ID_SUFFIX));
            this.mandatoryCheckbox.setFireChangeEventOnSetValue(false);
            this.mandatoryCheckbox.setValue(Boolean.valueOf(false));
            this.mandatoryCheckbox.addListener(Events.Change, (Listener)new AbstractRegistrationForm.InfoBoxResetListener(this.infoBox));
            FieldUtil.setVisibility(!this.isScriptable(), new Field[]{this.mandatoryCheckbox});
        }
        return this.mandatoryCheckbox;
    }

    private CheckBox getScriptableCheckbox() {
        if (this.scriptableCheckbox == null) {
            this.scriptableCheckbox = new CheckBoxField(this.viewContext.getMessage("scriptable", new Object[0]), false);
            this.scriptableCheckbox.setValue(Boolean.valueOf(false));
            this.scriptableCheckbox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    PropertyTypeAssignmentForm.this.updateShownInEditView();
                    PropertyTypeAssignmentForm.this.updateShowRawValue();
                    PropertyTypeAssignmentForm.this.updateVisibilityOfScriptRelatedFields();
                }
            });
            this.scriptableCheckbox.setId("openbis_property-type-assignment_scriptable_checkbox");
        }
        return this.scriptableCheckbox;
    }

    private void updateShownInEditView() {
        if (this.userDidChangeShownInEditViewCheckBox) {
            return;
        }
        this.synchronizingGuiFields = true;
        try {
            if (!this.isScriptable()) {
                this.shownInEditViewCheckBox.setValue(Boolean.valueOf(true));
                return;
            }
            if (this.isDynamic()) {
                this.shownInEditViewCheckBox.setValue(Boolean.valueOf(false));
                return;
            }
            if (this.isManaged()) {
                this.shownInEditViewCheckBox.setValue(Boolean.valueOf(false));
                return;
            }
        }
        finally {
            this.synchronizingGuiFields = false;
        }
    }

    private CheckBox getShownInEditViewCheckbox() {
        if (this.shownInEditViewCheckBox == null) {
            this.shownInEditViewCheckBox = new CheckBoxField(this.viewContext.getMessage("is_shown_in_edit_view", new Object[0]), false);
            this.shownInEditViewCheckBox.setValue(Boolean.valueOf(true));
            this.shownInEditViewCheckBox.setVisible(false);
            this.shownInEditViewCheckBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (!PropertyTypeAssignmentForm.this.synchronizingGuiFields) {
                        PropertyTypeAssignmentForm.this.userDidChangeShownInEditViewCheckBox = true;
                    }
                    PropertyTypeAssignmentForm.this.updateVisibilityOfShowRawValueField();
                }
            });
        }
        return this.shownInEditViewCheckBox;
    }

    private void updateShowRawValue() {
        if (this.userDidChangeShowRawValueCheckBox) {
            return;
        }
        this.synchronizingGuiFields = true;
        try {
            this.showRawValueCheckBox.setValue(Boolean.valueOf(true));
            return;
        }
        finally {
            this.synchronizingGuiFields = false;
        }
    }

    private CheckBox getShowRawValueCheckBox() {
        if (this.showRawValueCheckBox == null) {
            this.showRawValueCheckBox = new CheckBoxField(this.viewContext.getMessage("show_raw_value_in_forms", new Object[0]), false);
            this.showRawValueCheckBox.setValue(Boolean.valueOf(true));
            this.showRawValueCheckBox.setVisible(false);
            this.showRawValueCheckBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (!PropertyTypeAssignmentForm.this.synchronizingGuiFields) {
                        PropertyTypeAssignmentForm.this.userDidChangeShowRawValueCheckBox = true;
                    }
                }
            });
        }
        return this.showRawValueCheckBox;
    }

    private boolean isScriptable() {
        return this.scriptableCheckbox.getValue();
    }

    private final FormPanel createFormPanel() {
        FormPanel panel = new FormPanel();
        panel.setHeaderVisible(false);
        panel.setBodyBorder(false);
        panel.setWidth(590);
        panel.setLabelWidth(130);
        panel.setFieldWidth(400);
        panel.setButtonAlign(Style.HorizontalAlignment.RIGHT);
        this.saveButton = new Button(this.viewContext.getMessage("button_save", new Object[0]));
        this.saveButton.setStyleAttribute("marginRight", "20px");
        this.saveButton.setId(this.createChildId(SAVE_BUTTON_ID_SUFFIX));
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                PropertyTypeAssignmentForm.this.submitForm();
            }
        });
        Button resetButton = new Button(this.viewContext.getMessage("button_reset", new Object[0]));
        resetButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                PropertyTypeAssignmentForm.this.resetForm();
            }
        });
        panel.addButton(resetButton);
        panel.addButton(this.saveButton);
        return panel;
    }

    private String getSectionValue() {
        if (this.sectionSelectionWidget != null) {
            return this.sectionSelectionWidget.getSimpleValue();
        }
        return null;
    }

    private String getDefaultValue() {
        if (this.defaultValueField != null) {
            return PropertyFieldFactory.valueToString(((Field)this.defaultValueField.get()).getValue());
        }
        return null;
    }

    private String getSelectedEntityCode() {
        return this.tryGetSelectedEntityType().getCode();
    }

    private Long getPreviousETPTOrdinal() {
        return this.etptSelectionWidget.getSelectedEntityTypePropertyTypeOrdinal();
    }

    private EntityType tryGetSelectedEntityType() {
        switch (this.entityKind) {
            case EXPERIMENT: {
                return this.experimentTypeSelectionWidget.tryGetSelectedExperimentType();
            }
            case SAMPLE: {
                return this.sampleTypeSelectionWidget.tryGetSelectedSampleType();
            }
            case MATERIAL: {
                return this.materialTypeSelectionWidget.tryGetSelectedMaterialType();
            }
            case DATA_SET: {
                return this.dataSetTypeSelectionWidget.tryGetSelectedDataSetType();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_ENTITY_KIND);
    }

    private final void addFormFields() {
        PropertyTypeSelectionWidget propertyTypeWidget = this.getPropertyTypeWidget();
        DropDownList<?, ?> typeSelectionWidget = this.getTypeSelectionWidget();
        this.formPanel.add((Widget)propertyTypeWidget);
        this.formPanel.add(typeSelectionWidget);
        this.formPanel.add((Widget)this.getScriptableCheckbox());
        this.formPanel.add((Widget)this.scriptTypeRadioGroup);
        this.formPanel.add((Widget)this.scriptChooser);
        this.formPanel.add((Widget)this.getMandatoryCheckbox());
        this.formPanel.add((Widget)this.getShownInEditViewCheckbox());
        this.formPanel.add((Widget)this.getShowRawValueCheckBox());
        this.updatePropertyTypeRelatedFields();
        this.modificationManager.addObserver(propertyTypeWidget);
        this.modificationManager.addObserver(typeSelectionWidget);
        if (this.defaultValueField != null) {
            this.modificationManager.addObserver(this.defaultValueField);
        }
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFormFields();
    }

    private void updatePropertyTypeRelatedFields() {
        this.hidePropertyTypeRelatedFields();
        PropertyType propertyType = this.propertyTypeSelectionWidget.tryGetSelectedPropertyType();
        if (propertyType != null) {
            String fieldId = this.createChildId(DEFAULT_VALUE_ID_PART);
            DatabaseModificationAwareField<?> fieldHolder = PropertyFieldFactory.createField(propertyType, false, this.viewContext.getMessage(DEFAULT_VALUE_ID_PART, new Object[0]), fieldId, null, this.viewContext);
            GWTUtils.setToolTip((Component)fieldHolder.get(), this.viewContext.getMessage("default_value_tooltip", new Object[0]));
            this.defaultValueField = fieldHolder;
            ((Field)this.defaultValueField.get()).show();
            FieldUtil.setVisibility(!this.isScriptable(), (Field)this.defaultValueField.get());
            this.formPanel.add((Widget)this.defaultValueField.get());
        }
        this.updateEntityTypePropertyTypeRelatedFields();
    }

    private void hidePropertyTypeRelatedFields() {
        if (this.defaultValueField != null) {
            Field field = (Field)this.defaultValueField.get();
            field.hide();
            this.formPanel.remove((Widget)field);
            this.defaultValueField = null;
        }
    }

    private void updateEntityTypePropertyTypeRelatedFields() {
        this.hideEntityTypePropertyTypeRelatedFields();
        PropertyType propertyType = this.propertyTypeSelectionWidget.tryGetSelectedPropertyType();
        EntityType entityType = this.tryGetSelectedEntityType();
        if (propertyType != null && entityType != null) {
            ArrayList etpts = new ArrayList(entityType.getAssignedPropertyTypes());
            this.sectionSelectionWidget = this.createSectionSelectionWidget(etpts);
            this.formPanel.add((Widget)this.sectionSelectionWidget);
            this.etptSelectionWidget = this.createETPTSelectionWidget(etpts);
            this.formPanel.add((Widget)this.etptSelectionWidget);
        }
        this.layout();
    }

    private void hideEntityTypePropertyTypeRelatedFields() {
        if (this.sectionSelectionWidget != null && this.etptSelectionWidget != null) {
            this.sectionSelectionWidget.hide();
            this.etptSelectionWidget.hide();
            this.formPanel.remove((Widget)this.sectionSelectionWidget);
            this.formPanel.remove((Widget)this.etptSelectionWidget);
            this.sectionSelectionWidget = null;
            this.etptSelectionWidget = null;
        }
    }

    private EntityTypePropertyTypeSelectionWidget createETPTSelectionWidget(List<EntityTypePropertyType<?>> etpts) {
        etpts.add(0, null);
        String lastCode = etpts.size() > 1 ? etpts.get(etpts.size() - 1).getPropertyType().getCode() : "(top)";
        EntityTypePropertyTypeSelectionWidget result = new EntityTypePropertyTypeSelectionWidget(this.viewContext, this.getId(), etpts, lastCode);
        FieldUtil.setMandatoryFlag(result, true);
        return result;
    }

    private SectionSelectionWidget createSectionSelectionWidget(List<EntityTypePropertyType<?>> etpts) {
        return SectionSelectionWidget.create(this.viewContext, etpts);
    }

    String tryGetScriptNameValue() {
        if (this.scriptChooser == null) {
            return null;
        }
        return (String)this.scriptChooser.getValue();
    }

    private boolean isDynamic() {
        return this.isScriptable() && this.scriptTypeDynamic.getValue() != false;
    }

    private boolean isManaged() {
        return this.isScriptable() && this.scriptTypeManaged.getValue() != false;
    }

    private boolean isShownInEditView() {
        if (!this.isScriptable()) {
            return true;
        }
        if (this.isDynamic()) {
            return false;
        }
        return this.shownInEditViewCheckBox.getValue();
    }

    private boolean getShowRawValue() {
        if (!this.isManaged() || !this.isShownInEditView()) {
            return false;
        }
        return this.showRawValueCheckBox.getValue();
    }

    private final void submitForm() {
        if (this.formPanel.isValid()) {
            NewETPTAssignment newAssignment = new NewETPTAssignment(this.entityKind, this.propertyTypeSelectionWidget.tryGetSelectedPropertyTypeCode(), this.getSelectedEntityCode(), this.getMandatoryCheckbox().getValue(), this.getDefaultValue(), this.getSectionValue(), this.getPreviousETPTOrdinal(), this.isDynamic(), this.isManaged(), this.tryGetScriptNameValue(), this.isShownInEditView(), this.getShowRawValue());
            this.viewContext.getService().assignPropertyType(newAssignment, new AssignPropertyTypeCallback(this.viewContext));
        }
    }

    private void resetForm() {
        this.formPanel.reset();
        this.getTypeSelectionWidget().refreshStore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.modificationManager.getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.modificationManager.update(observedModifications);
    }

    private final class AssignPropertyTypeCallback
    extends AbstractAsyncCallback<String> {
        AssignPropertyTypeCallback(IViewContext<?> viewContext) {
            super(viewContext, new InfoBoxCallbackListener(PropertyTypeAssignmentForm.this.infoBox));
            PropertyTypeAssignmentForm.this.saveButton.disable();
        }

        @Override
        protected final void process(String result) {
            PropertyTypeAssignmentForm.this.infoBox.displayInfo(result);
            PropertyTypeAssignmentForm.this.resetForm();
            PropertyTypeAssignmentForm.this.saveButton.enable();
        }

        @Override
        public void finishOnFailure(Throwable caught) {
            super.finishOnFailure(caught);
            PropertyTypeAssignmentForm.this.saveButton.enable();
        }
    }
}

