/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.DefaultAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DelegatedPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.MetaprojectTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AuthorizationServiceUtils {
    private final IDAOFactory daoFactory;
    private final PersonPE user;
    private final List<RoleWithIdentifier> userRoles;

    public AuthorizationServiceUtils(IDAOFactory daoFactory, String userId) {
        this(daoFactory, AuthorizationServiceUtils.getUserByName(daoFactory, userId));
    }

    public AuthorizationServiceUtils(IDAOFactory daoFactory, PersonPE user) {
        this.daoFactory = daoFactory;
        this.user = user;
        this.userRoles = DefaultAccessController.getUserRoles(user);
    }

    public boolean doesUserHaveRole(String roleCode, String spaceOrNull) {
        RoleWithHierarchy methodRole;
        try {
            RoleWithHierarchy.RoleLevel roleLevel = spaceOrNull == null ? RoleWithHierarchy.RoleLevel.INSTANCE : RoleWithHierarchy.RoleLevel.SPACE;
            methodRole = RoleWithHierarchy.valueOf(roleLevel, RoleWithHierarchy.RoleCode.valueOf(roleCode));
        }
        catch (Exception exception) {
            if (spaceOrNull == null) {
                throw new IllegalArgumentException("Incorrect role " + roleCode + " specified. The correct roles for space are ADMIN, USER, POWER_USER, OBSERVER");
            }
            throw new IllegalArgumentException("Incorrect role " + roleCode + " specified. The correct instance roles are ADMIN, OBSERVER");
        }
        if (this.user.getAllPersonRoles().size() == 0) {
            return false;
        }
        List<RoleWithIdentifier> retainedUserRoles = DefaultAccessController.retainMatchingRoleWithIdentifiers(new ArrayList<RoleWithIdentifier>(this.userRoles), methodRole.getRoles());
        if (retainedUserRoles.size() == 0) {
            return false;
        }
        if (spaceOrNull != null) {
            SpaceIdentifierPredicate predicate = new SpaceIdentifierPredicate();
            predicate.init(new AuthorizationDataProvider(this.daoFactory));
            Status status = predicate.evaluate(this.user, retainedUserRoles, new SpaceIdentifier(spaceOrNull));
            return status.getFlag().equals((Object)StatusFlag.OK);
        }
        return true;
    }

    private static PersonPE getUserByName(IDAOFactory daoFactory, String userId) {
        PersonPE person = daoFactory.getPersonDAO().tryFindPersonByUserId(userId);
        if (person == null) {
            throw new IllegalArgumentException("The user with id " + userId + " doesn't exist");
        }
        return person;
    }

    public List<String> filterDataSetCodes(List<String> dataSetCodes) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String dataSetCode : dataSetCodes) {
            if (!this.canAccessDataSet(dataSetCode)) continue;
            resultList.add(dataSetCode);
        }
        return resultList;
    }

    public boolean canAccessDataSet(DataPE dataSet) {
        return this.canAccessDataSet(dataSet.getCode());
    }

    public boolean canAccessDataSet(AbstractExternalData dataSet) {
        return this.canAccessDataSet(dataSet.getCode());
    }

    private boolean canAccessDataSet(String dataSetCode) {
        DataSetCodePredicate predicate = new DataSetCodePredicate();
        predicate.init(new AuthorizationDataProvider(this.daoFactory));
        Status status = predicate.evaluate(this.user, this.userRoles, dataSetCode);
        return status.getFlag().equals((Object)StatusFlag.OK);
    }

    public List<String> filterExperimentIds(List<String> experimentIds) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String experimentId : experimentIds) {
            if (!this.canAccessExperiment(experimentId)) continue;
            resultList.add(experimentId);
        }
        return resultList;
    }

    public boolean canAccessMetaproject(MetaprojectPE metaprojectPE) {
        MetaprojectTechIdPredicate predicate = new MetaprojectTechIdPredicate();
        predicate.init(new AuthorizationDataProvider(this.daoFactory));
        Status status = predicate.evaluate(this.user, this.userRoles, new TechId(metaprojectPE.getId()));
        return status.getFlag().equals((Object)StatusFlag.OK);
    }

    public void checkAccessMetaproject(MetaprojectPE metaprojectPE) {
        if (!this.canAccessMetaproject(metaprojectPE)) {
            throw new AuthorizationFailureException("User: " + (this.user != null ? this.user.getUserId() : null) + " doesn't have access to metaproject: " + metaprojectPE.getIdentifier());
        }
    }

    public boolean canAccessExperiment(Experiment experiment) {
        return this.canAccessExperiment(experiment.getIdentifier());
    }

    public boolean canAccessExperiment(ExperimentPE experimentPE) {
        return this.canAccessExperiment(experimentPE.getIdentifier());
    }

    private boolean canAccessExperiment(String experimentId) {
        ExperimentAugmentedCodePredicate predicate = new ExperimentAugmentedCodePredicate();
        predicate.init(new AuthorizationDataProvider(this.daoFactory));
        Status status = predicate.evaluate(this.user, this.userRoles, experimentId);
        return status.getFlag().equals((Object)StatusFlag.OK);
    }

    public List<String> filterSampleIds(List<String> sampleIds) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String sampleIdentifier : sampleIds) {
            if (!this.canAccessSample(sampleIdentifier)) continue;
            resultList.add(sampleIdentifier);
        }
        return resultList;
    }

    public boolean canAccessSample(SamplePE sample) {
        return this.canAccessSample(sample.getIdentifier());
    }

    public boolean canAccessSample(Sample sample) {
        return this.canAccessSample(sample.getIdentifier());
    }

    private boolean canAccessSample(String sampleIdentifier) {
        DelegatedPredicate<SampleOwnerIdentifier, IIdentifierHolder> predicate = AuthorizationServiceUtils.createSampleOwnerPredicate(this.daoFactory);
        return this.canAccessSample(predicate, sampleIdentifier);
    }

    private boolean canAccessSample(DelegatedPredicate<SampleOwnerIdentifier, IIdentifierHolder> predicate, final String sampleIdentifier) {
        Status status = predicate.evaluate(this.user, this.userRoles, new IIdentifierHolder(){

            @Override
            public String getIdentifier() {
                return sampleIdentifier;
            }
        });
        return Status.OK.equals(status);
    }

    private static DelegatedPredicate<SampleOwnerIdentifier, IIdentifierHolder> createSampleOwnerPredicate(IDAOFactory daoFactory) {
        DelegatedPredicate<SampleOwnerIdentifier, IIdentifierHolder> predicate = new DelegatedPredicate<SampleOwnerIdentifier, IIdentifierHolder>((IPredicate)new SampleOwnerIdentifierPredicate()){

            @Override
            public SampleOwnerIdentifier tryConvert(IIdentifierHolder value) {
                return SampleIdentifierFactory.parse(value.getIdentifier());
            }

            @Override
            public String getCandidateDescription() {
                return "sample";
            }
        };
        predicate.init(new AuthorizationDataProvider(daoFactory));
        return predicate;
    }
}

