/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import java.util.List;

public class ProjectPermIdPredicate
extends AbstractSpacePredicate<String> {
    @Override
    public String getCandidateDescription() {
        return "project perm id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, String permId) {
        ProjectPE project = this.authorizationDataProvider.tryGetProjectByPermId(new PermId(permId));
        if (project == null) {
            return Status.createError(String.format("There is no project with perm id '%s'." + permId, new Object[0]));
        }
        return this.evaluateSpace(person, allowedRoles, project.getSpace());
    }
}

