/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardState;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.WizardWorkflowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.MsInjectionAnnotationWizardState;
import java.util.ArrayList;
import java.util.List;

public class MsInjectionSampleAnnotationModel
implements IWizardDataModel {
    private final IViewContext<IPhosphoNetXClientServiceAsync> context;
    private final WizardWorkflowModel workflowModel;
    private List<Sample> msInjectionSamples = new ArrayList<Sample>();
    private boolean chooseBiologicalSampleFlag;
    private Sample biologicalSample;
    private NewSample newBiologicalSample;

    public MsInjectionSampleAnnotationModel(IViewContext<IPhosphoNetXClientServiceAsync> context) {
        this.context = context;
        this.workflowModel = new WizardWorkflowModel(this);
        this.workflowModel.addTransition(MsInjectionAnnotationWizardState.MS_INJECTION_SAMPLE_CHOOSING, MsInjectionAnnotationWizardState.CHOOSE_OR_CREATE_QUESTION);
        this.workflowModel.addTransition(MsInjectionAnnotationWizardState.CHOOSE_OR_CREATE_QUESTION, MsInjectionAnnotationWizardState.BIOLOGICAL_SAMPLE_CHOOSING);
        this.workflowModel.addTransition(MsInjectionAnnotationWizardState.CHOOSE_OR_CREATE_QUESTION, MsInjectionAnnotationWizardState.BIOLOGICAL_SAMPLE_CREATING);
    }

    @Override
    public WizardWorkflowModel getWorkflow() {
        return this.workflowModel;
    }

    @Override
    public IWizardState determineNextState(IWizardState currentState) {
        return this.chooseBiologicalSampleFlag ? MsInjectionAnnotationWizardState.BIOLOGICAL_SAMPLE_CHOOSING : MsInjectionAnnotationWizardState.BIOLOGICAL_SAMPLE_CREATING;
    }

    public void setSelectedMsInjectionSample(List<Sample> samples) {
        this.msInjectionSamples = samples;
    }

    public List<Sample> getMsInjectionSamples() {
        return this.msInjectionSamples;
    }

    public void setChooseBiologicalSampleFlag(boolean flag) {
        this.chooseBiologicalSampleFlag = flag;
    }

    public void setBiologicalSample(Sample biologicalSample) {
        this.biologicalSample = biologicalSample;
    }

    public void defineBiologicalSample(SampleType sampleType, String identifier, String experimentIdentifierOrNull, List<IEntityProperty> properties) {
        this.newBiologicalSample = NewSample.createWithParents(identifier, sampleType, null, null);
        this.newBiologicalSample.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
        this.newBiologicalSample.setExperimentIdentifier(experimentIdentifierOrNull);
    }

    @Override
    public String finish() {
        VoidAsyncCallback<Void> callback = new VoidAsyncCallback<Void>(this.context);
        if (this.chooseBiologicalSampleFlag) {
            this.context.getService().linkSamples(this.biologicalSample, this.msInjectionSamples, callback);
        } else {
            this.context.getService().createAndLinkSamples(this.newBiologicalSample, this.msInjectionSamples, callback);
        }
        return String.valueOf(this.msInjectionSamples.size()) + " MS_INJECTION samples have been annotated.";
    }
}

