/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AminoAcid;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinRelatedSample;
import java.util.List;

public class ProteinRelatedSampleProvider
extends AbstractTableModelProvider<ProteinRelatedSample> {
    private static final String PROPERTIES_GROUP = "property-";
    private final IPhosphoNetXServer server;
    private final String sessionToken;
    private final TechId experimentID;
    private final TechId proteinReferenceID;

    public ProteinRelatedSampleProvider(IPhosphoNetXServer server, String sessionToken, TechId experimentID, TechId proteinReferenceID) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.experimentID = experimentID;
        this.proteinReferenceID = proteinReferenceID;
    }

    @Override
    protected TypedTableModel<ProteinRelatedSample> createTableModel() {
        List<ProteinRelatedSample> samples = this.server.listProteinRelatedSamplesByProtein(this.sessionToken, this.experimentID, this.proteinReferenceID);
        TypedTableModelBuilder<ProteinRelatedSample> builder = new TypedTableModelBuilder<ProteinRelatedSample>();
        builder.column("SAMPLE_IDENTIFIER");
        builder.column("SAMPLE_TYPE");
        builder.column("ABUNDANCE").withDataType(DataTypeCode.REAL).withDefaultWidth(100);
        builder.column("MODIFIED_AMINO_ACID");
        builder.column("MODIFICATION_POSITION").withDataType(DataTypeCode.INTEGER).withDefaultWidth(100);
        builder.column("MODIFICATION_MASS").withDataType(DataTypeCode.REAL).withDefaultWidth(100);
        builder.column("MODIFICATION_FRACTION").withDataType(DataTypeCode.REAL).withDefaultWidth(100);
        for (ProteinRelatedSample sample : samples) {
            builder.addRow(sample);
            builder.column("SAMPLE_IDENTIFIER").addString(sample.getIdentifier());
            builder.column("SAMPLE_TYPE").addString(sample.getEntityType().getCode());
            builder.column("ABUNDANCE").addDouble(sample.getAbundance());
            builder.column("MODIFIED_AMINO_ACID").addString(this.getAminoAcidName(sample));
            builder.column("MODIFICATION_POSITION").addInteger(sample.getModificationPosition());
            builder.column("MODIFICATION_MASS").addDouble(sample.getModificationMass());
            builder.column("MODIFICATION_FRACTION").addDouble(sample.getModificationFraction());
            builder.columnGroup(PROPERTIES_GROUP).addProperties(sample.getProperties());
        }
        return builder.getModel();
    }

    private String getAminoAcidName(ProteinRelatedSample sample) {
        char modifiedAminoAcid = sample.getModifiedAminoAcid();
        if (modifiedAminoAcid == '\u0000') {
            return null;
        }
        try {
            char aminoAcidSymbol = Character.toUpperCase(modifiedAminoAcid);
            return AminoAcid.valueOf(Character.toString(aminoAcidSymbol)).getName();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "?";
        }
    }
}

