/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class Loading
extends Composite {
    private static final int LOADING_WAIT_PERIOD = 100;
    private static final int LOADING_SHOW_PERIOD = 1000;
    private Widget msg = new Label("Loading...");
    private LoadingState state;

    public Loading() {
        this.setState(new LoadingHiddenState());
        this.initWidget(this.msg);
    }

    public void showLoading() {
        this.state.handleShowLoading();
    }

    public void hideLoading() {
        this.state.handleHideLoading();
    }

    private void setState(LoadingState state) {
        this.state = state;
        state.init();
    }

    private class LoadingHiddenState
    extends LoadingState {
        private Timer showTimer;

        private LoadingHiddenState() {
        }

        @Override
        public void init() {
            Loading.this.msg.getElement().getStyle().setVisibility(Style.Visibility.HIDDEN);
        }

        @Override
        public void handleShowLoading() {
            if (this.showTimer == null) {
                this.showTimer = new Timer(){

                    public void run() {
                        Loading.this.setState(new LoadingShownState());
                    }
                };
                this.showTimer.schedule(100);
            }
        }

        @Override
        public void handleHideLoading() {
            if (this.showTimer != null) {
                this.showTimer.cancel();
                this.showTimer = null;
            }
        }
    }

    private class LoadingShownState
    extends LoadingState {
        private long showTime;
        private Timer hideTimer;

        private LoadingShownState() {
        }

        @Override
        public void init() {
            Loading.this.msg.getElement().getStyle().setVisibility(Style.Visibility.VISIBLE);
            this.showTime = System.currentTimeMillis();
        }

        @Override
        public void handleShowLoading() {
            if (this.hideTimer != null) {
                this.hideTimer.cancel();
                this.hideTimer = null;
            }
        }

        @Override
        public void handleHideLoading() {
            long showPeriod = System.currentTimeMillis() - this.showTime;
            if (showPeriod >= 1000L) {
                Loading.this.setState(new LoadingHiddenState());
            } else if (this.hideTimer == null) {
                this.hideTimer = new Timer(){

                    public void run() {
                        Loading.this.setState(new LoadingHiddenState());
                    }
                };
                this.hideTimer.schedule((int)(1000L - showPeriod));
            }
        }
    }

    private abstract class LoadingState {
        private LoadingState() {
        }

        public abstract void init();

        public abstract void handleShowLoading();

        public abstract void handleHideLoading();
    }
}

