/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageID {
    public static final ImageID NULL = new ImageID(0, 0, 0, 0);
    private static final Pattern ID_PATTERN = Pattern.compile("(\\d+)-(\\d+)-(\\d+)-(\\d+)");
    private final int seriesIndex;
    private final int timeSeriesIndex;
    private final int focalPlaneIndex;
    private final int colorChannelIndex;
    private final String id;
    private String filename;

    public static ImageID parse(String imageIdAsString) {
        Matcher matcher = ID_PATTERN.matcher(imageIdAsString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid image ID: " + imageIdAsString);
        }
        return new ImageID(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
    }

    public void setFileName(String f) {
        this.filename = f;
    }

    public String getFileName() {
        return this.filename;
    }

    public ImageID(int seriesIndex, int timeSeriesIndex, int focalPlaneIndex, int colorChannelIndex) {
        this.seriesIndex = seriesIndex;
        this.timeSeriesIndex = timeSeriesIndex;
        this.focalPlaneIndex = focalPlaneIndex;
        this.colorChannelIndex = colorChannelIndex;
        this.id = String.valueOf(seriesIndex) + "-" + timeSeriesIndex + "-" + focalPlaneIndex + "-" + colorChannelIndex;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public int getTimeSeriesIndex() {
        return this.timeSeriesIndex;
    }

    public int getFocalPlaneIndex() {
        return this.focalPlaneIndex;
    }

    public int getColorChannelIndex() {
        return this.colorChannelIndex;
    }

    public String getID() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageID)) {
            return false;
        }
        ImageID that = (ImageID)obj;
        return this.seriesIndex == that.seriesIndex && this.timeSeriesIndex == that.timeSeriesIndex && this.focalPlaneIndex == that.focalPlaneIndex && this.colorChannelIndex == that.colorChannelIndex;
    }

    public int hashCode() {
        return ((this.seriesIndex * 37 + this.timeSeriesIndex) * 37 + this.focalPlaneIndex) * 37 + this.colorChannelIndex;
    }

    public String toString() {
        return this.getID();
    }
}

