CREATE TABLE EVENTS (
    LAST_SEEN_DELETION_EVENT_ID TECH_ID  NOT NULL
);


ALTER TABLE MODIFICATIONS DROP CONSTRAINT MODIFIED_PEPTIDES_MODIFICATIONS;
ALTER TABLE MODIFICATIONS ADD CONSTRAINT MODIFIED_PEPTIDES_MODIFICATIONS 
    FOREIGN KEY (MOPE_ID) REFERENCES MODIFIED_PEPTIDES (ID) ON DELETE CASCADE;

ALTER TABLE PEPTIDES DROP CONSTRAINT PE_PR_FK;
ALTER TABLE PEPTIDES ADD CONSTRAINT PE_PR_FK 
    FOREIGN KEY (PROT_ID) REFERENCES PROTEINS (ID) ON DELETE CASCADE;

ALTER TABLE PROTEINS DROP CONSTRAINT DATA_SETS_PROTEINS; 
ALTER TABLE PROTEINS ADD CONSTRAINT DATA_SETS_PROTEINS 
    FOREIGN KEY (DASE_ID) REFERENCES DATA_SETS (ID) ON DELETE CASCADE;

ALTER TABLE IDENTIFIED_PROTEINS DROP CONSTRAINT PROTEINS_IDENTIFIED_PROTEINS;
ALTER TABLE IDENTIFIED_PROTEINS ADD CONSTRAINT PROTEINS_IDENTIFIED_PROTEINS 
    FOREIGN KEY (PROT_ID) REFERENCES PROTEINS (ID) ON DELETE CASCADE;
    
ALTER TABLE ABUNDANCES DROP CONSTRAINT PROTEINS_ABUNDANCES;
ALTER TABLE ABUNDANCES ADD CONSTRAINT PROTEINS_ABUNDANCES 
    FOREIGN KEY (PROT_ID) REFERENCES PROTEINS (ID) ON DELETE CASCADE;

ALTER TABLE PROBABILITY_FDR_MAPPINGS DROP CONSTRAINT DATA_SETS_PROBABILITY_FDR_MAPPINGS;
ALTER TABLE PROBABILITY_FDR_MAPPINGS ADD CONSTRAINT DATA_SETS_PROBABILITY_FDR_MAPPINGS 
    FOREIGN KEY (DASE_ID) REFERENCES DATA_SETS (ID) ON DELETE CASCADE;

ALTER TABLE MODIFIED_PEPTIDES DROP CONSTRAINT PEPTIDES_MODIFIED_PEPTIDES;
ALTER TABLE MODIFIED_PEPTIDES ADD CONSTRAINT PEPTIDES_MODIFIED_PEPTIDES 
    FOREIGN KEY (PEPT_ID) REFERENCES PEPTIDES (ID) ON DELETE CASCADE;

ALTER TABLE SPECTRUM_REFERENCES DROP CONSTRAINT PEPTIDES_SPECTRUM_REFERENCES;
ALTER TABLE SPECTRUM_REFERENCES ADD CONSTRAINT PEPTIDES_SPECTRUM_REFERENCES 
    FOREIGN KEY (PEPT_ID) REFERENCES PEPTIDES (ID) ON DELETE CASCADE;

ALTER TABLE MODIFICATION_FRACTIONS DROP CONSTRAINT MODIFICATIONS_MODIFICATION_FRACTIONS;
ALTER TABLE MODIFICATION_FRACTIONS ADD CONSTRAINT MODIFICATIONS_MODIFICATION_FRACTIONS 
    FOREIGN KEY (MODI_ID) REFERENCES MODIFICATIONS (ID) ON DELETE CASCADE;
    