/*
 * Decompiled with CFR 0.152.
 */
package eu.basynthec.cisd.client.examples;

import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import eu.basynthec.cisd.client.examples.AbstractBaSynthecClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentLister
extends AbstractBaSynthecClient {
    private static final String STRAIN_NAMES_PROPERTY = "STRAIN_NAMES";
    private static final String STRAINS_HEADER = "Strains";
    private static final String REGISTERED_BY_HEADER = "Contact Person";
    private List<Experiment> experiments;
    private HashMap<String, ArrayList<DataSet>> experimentDataSets;

    public ExperimentLister(IOpenbisServiceFacade facade) {
        super(facade);
    }

    public void run(List<String> projectIdentifiers) {
        this.retrieveInformationFromOpenBis(projectIdentifiers);
        this.printHeader();
        for (Experiment experiment : this.experiments) {
            this.printExperiment(experiment);
        }
    }

    private void retrieveInformationFromOpenBis(List<String> projectIdentifiers) {
        this.experiments = this.openBis.listExperimentsForProjects(projectIdentifiers);
        ArrayList<String> experimentIdentifiers = new ArrayList<String>();
        for (Experiment experiment : this.experiments) {
            experimentIdentifiers.add(experiment.getIdentifier());
        }
        List dataSets = this.openBis.listDataSetsForExperiments(experimentIdentifiers);
        this.experimentDataSets = new HashMap();
        for (DataSet dataSet : dataSets) {
            ArrayList<Object> dataSetsForExperiment = this.experimentDataSets.get(dataSet.getExperimentIdentifier());
            if (dataSetsForExperiment == null) {
                dataSetsForExperiment = new ArrayList();
                this.experimentDataSets.put(dataSet.getExperimentIdentifier(), dataSetsForExperiment);
            }
            dataSetsForExperiment.add(dataSet);
        }
    }

    private void printHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("Experiment");
        MetadataField[] metadataFieldArray = MetadataField.values();
        int n = metadataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataField field = metadataFieldArray[n2];
            sb.append("\t");
            sb.append(field.headerText);
            ++n2;
        }
        sb.append("\t");
        sb.append(STRAINS_HEADER);
        sb.append("\t");
        sb.append(REGISTERED_BY_HEADER);
        this.println(sb.toString());
    }

    private void printExperiment(Experiment experiment) {
        StringBuffer sb = new StringBuffer();
        sb.append(experiment.getIdentifier());
        this.printExperimentPropertiesOn(experiment.getProperties(), sb);
        this.printExperimentStrainsOn(experiment, sb);
        this.printRegisteredByOn(experiment.getRegistrationDetails(), sb);
        this.println(sb.toString());
    }

    private void printExperimentPropertiesOn(Map<String, String> properties, StringBuffer sb) {
        MetadataField[] metadataFieldArray = MetadataField.values();
        int n = metadataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataField field = metadataFieldArray[n2];
            sb.append("\t");
            String value = properties.get(field.toString());
            if (value != null) {
                sb.append(value);
            }
            ++n2;
        }
    }

    private void printExperimentStrainsOn(Experiment experiment, StringBuffer sb) {
        sb.append("\t");
        ArrayList<DataSet> dataSets = this.experimentDataSets.get(experiment.getIdentifier());
        if (dataSets == null) {
            return;
        }
        ArrayList<String> strains = new ArrayList<String>();
        for (DataSet dataSet : dataSets) {
            String strainNames = (String)dataSet.getProperties().get(STRAIN_NAMES_PROPERTY);
            if (strainNames == null) continue;
            strains.add(strainNames);
        }
        if (strains.size() < 1) {
            return;
        }
        sb.append((String)strains.get(0));
        int i = 1;
        while (i < strains.size()) {
            sb.append(",");
            sb.append((String)strains.get(i));
            ++i;
        }
    }

    private void printRegisteredByOn(EntityRegistrationDetails registrationDetails, StringBuffer sb) {
        sb.append("\t");
        if (registrationDetails != null) {
            sb.append(registrationDetails.getUserEmail());
        }
    }

    private static enum MetadataField {
        EXPERIMENT_DATE("Date"),
        DESCRIPTION("Description"),
        MEDIUM("Medium"),
        TEMPERATURE("Temperature"),
        MISC_GROWTH_CONDITIONS("Growth Conditions");

        private final String headerText;

        private MetadataField(String headerText) {
            this.headerText = headerText;
        }
    }
}

