/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import eu.basysbio.cisd.dss.DataSetPropertiesExtractor;
import eu.basysbio.cisd.dss.HeaderUtils;
import eu.basysbio.cisd.dss.TimeSeriesPropertyType;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

class LcaMicDataSetPropertiesExtractor
extends DataSetPropertiesExtractor {
    static final String GROWTH_RATE = "GROWTH_RATE";

    LcaMicDataSetPropertiesExtractor(Properties properties) {
        super(properties, true);
    }

    @Override
    public List<NewProperty> extractDataSetProperties(File incomingDataSetPath) {
        File file = HeaderUtils.getTabSeparatedValueFile(incomingDataSetPath);
        List lines = FileUtilities.loadToStringList((File)file);
        if (lines.isEmpty()) {
            throw new UserFailureException("Empty file: " + file);
        }
        String[] items = StringUtils.split((String)((String)lines.get(0)), (String)" \t");
        NewProperty growthRate = new NewProperty(GROWTH_RATE, items[items.length - 1]);
        List<NewProperty> properties = HeaderUtils.extractHeaderProps(incomingDataSetPath, this.ignoreEmptyLines, true, true, new TimeSeriesPropertyType[0]);
        properties.add(growthRate);
        return properties;
    }
}

