/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.etlserver.utils.Column;
import eu.basysbio.cisd.dss.AbstractColumnInjection;
import eu.basysbio.cisd.dss.IColumnInjection;
import eu.basysbio.cisd.dss.IInjectionFactory;
import eu.basysbio.cisd.dss.TimeSeriesValue;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

enum TimeSeriesInjectionFactory implements IInjectionFactory<TimeSeriesValue>
{
    IDENTIFIER(1, ".+"){

        @Override
        public IColumnInjection<TimeSeriesValue> create(Column column) {
            return new AbstractColumnInjection<TimeSeriesValue>(column){

                @Override
                void inject(TimeSeriesValue dataValue, String value) {
                    dataValue.setIdentifier(value);
                }
            };
        }
    }
    ,
    HUMAN_READABLE(2, "HumanReadable"){

        @Override
        public IColumnInjection<TimeSeriesValue> create(Column column) {
            return new AbstractColumnInjection<TimeSeriesValue>(column){

                @Override
                void inject(TimeSeriesValue dataValue, String value) {
                    dataValue.setHumanReadable(value);
                }
            };
        }
    }
    ,
    BSB_ID(2, "BSB_ID"){

        @Override
        public IColumnInjection<TimeSeriesValue> create(Column column) {
            return new AbstractColumnInjection<TimeSeriesValue>(column){

                @Override
                void inject(TimeSeriesValue dataValue, String value) {
                    dataValue.setBsbId(value);
                }
            };
        }
    }
    ,
    CONFIDENCE_LEVEL(3, "confidence level"){

        @Override
        public IColumnInjection<TimeSeriesValue> create(Column column) {
            return new AbstractColumnInjection<TimeSeriesValue>(column){

                @Override
                void inject(TimeSeriesValue dataValue, String value) {
                    dataValue.setConfidenceLevel(value);
                }
            };
        }
    }
    ,
    CONTROLLED_GENE(3, "ControlledGene"){

        @Override
        public IColumnInjection<TimeSeriesValue> create(Column column) {
            return new AbstractColumnInjection<TimeSeriesValue>(column){

                @Override
                void inject(TimeSeriesValue dataValue, String value) {
                    dataValue.setControlledGene(value);
                }
            };
        }
    }
    ,
    NUMBER_OF_REPLICATES(2, "no of replicates"){

        @Override
        public IColumnInjection<TimeSeriesValue> create(Column column) {
            return new AbstractColumnInjection<TimeSeriesValue>(column){

                @Override
                void inject(TimeSeriesValue dataValue, String value) {
                    Integer number = null;
                    if (StringUtils.isNotBlank((String)value)) {
                        number = Integer.parseInt(value);
                    }
                    dataValue.setNumberOfReplicates(number);
                }
            };
        }
    };

    private final int columnNumber;
    private final Pattern pattern;

    private TimeSeriesInjectionFactory(int columnNumber, String columnHeaderPattern) {
        this.columnNumber = columnNumber;
        this.pattern = Pattern.compile(columnHeaderPattern);
    }

    @Override
    public IColumnInjection<TimeSeriesValue> tryToCreate(List<Column> columns) {
        int colIndex = this.columnNumber - 1;
        if (colIndex >= columns.size()) {
            return null;
        }
        Column column = columns.get(colIndex);
        return this.pattern.matcher(column.getHeader()).matches() ? this.create(column) : null;
    }

    public abstract IColumnInjection<TimeSeriesValue> create(Column var1);

    /* synthetic */ TimeSeriesInjectionFactory(String string, int n, int n2, String string2, TimeSeriesInjectionFactory timeSeriesInjectionFactory) {
        this(n2, string2);
    }
}

