/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.LocalExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformation;
import ch.systemsx.cisd.yeastx.etl.LogUtils;
import ch.systemsx.cisd.yeastx.etl.MLConversionType;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

class DatasetMappingResolver {
    private static final String UNIQUE_SAMPLE_NAME_PROPERTY = "unique-sample-name-property-code";
    private static final String UNIQUE_EXPERIMENT_NAME_PROPERTY = "unique-experiment-name-property-code";
    private final IEncapsulatedOpenBISService openbisService;
    private final String samplePropertyCodeOrNull;
    private final String experimentPropertyCodeOrNull;

    public static String getUniqueSampleNamePropertyCode(Properties properties) {
        return DatasetMappingResolver.getUniqueNamePropertyCode(properties, UNIQUE_SAMPLE_NAME_PROPERTY);
    }

    public static String getUniqueExperimentNamePropertyCode(Properties properties) {
        return DatasetMappingResolver.getUniqueNamePropertyCode(properties, UNIQUE_EXPERIMENT_NAME_PROPERTY);
    }

    private static String tryGetUniqueSampleNamePropertyCode(Properties properties) {
        return DatasetMappingResolver.tryGetUniqueNamePropertyCode(properties, UNIQUE_SAMPLE_NAME_PROPERTY);
    }

    private static String tryGetUniqueExperimentNamePropertyCode(Properties properties) {
        return DatasetMappingResolver.tryGetUniqueNamePropertyCode(properties, UNIQUE_EXPERIMENT_NAME_PROPERTY);
    }

    private static String getUniqueNamePropertyCode(Properties properties, String propertyName) {
        String name = DatasetMappingResolver.tryGetUniqueNamePropertyCode(properties, propertyName);
        if (name == null) {
            throw EnvironmentFailureException.fromTemplate((String)"Property '%s' is not set.", (Object[])new Object[]{propertyName});
        }
        return name;
    }

    private static String tryGetUniqueNamePropertyCode(Properties properties, String propertyName) {
        return properties.getProperty(propertyName);
    }

    public DatasetMappingResolver(Properties properties, IEncapsulatedOpenBISService openbisService) {
        this.openbisService = openbisService;
        this.samplePropertyCodeOrNull = DatasetMappingResolver.tryGetUniqueSampleNamePropertyCode(properties);
        this.experimentPropertyCodeOrNull = DatasetMappingResolver.tryGetUniqueExperimentNamePropertyCode(properties);
    }

    public String tryFigureSampleCode(DataSetMappingInformation mapping, LogUtils log) {
        String sampleCodeOrLabel = mapping.getSampleCodeOrLabel();
        if (sampleCodeOrLabel == null) {
            return null;
        }
        if (this.samplePropertyCodeOrNull == null) {
            return sampleCodeOrLabel;
        }
        Boolean sampleExistsAndBelongsToExperiment = null;
        if (mapping.getExperimentName() == null && (sampleExistsAndBelongsToExperiment = Boolean.valueOf(this.sampleExistsAndBelongsToExperiment(mapping, sampleCodeOrLabel, log))).booleanValue()) {
            return sampleCodeOrLabel;
        }
        ListSamplesByPropertyCriteria criteria = this.createFindSampleByNameCriteria(mapping, sampleCodeOrLabel);
        List<Sample> samples = this.tryListSamplesByCriteria(criteria, mapping, log);
        if (samples == null) {
            return null;
        }
        if (samples.size() == 1) {
            return samples.get(0).getCode();
        }
        if (samples.size() == 0) {
            if (sampleExistsAndBelongsToExperiment == null) {
                sampleExistsAndBelongsToExperiment = this.sampleExistsAndBelongsToExperiment(mapping, sampleCodeOrLabel, log);
            }
            if (sampleExistsAndBelongsToExperiment.booleanValue()) {
                return sampleCodeOrLabel;
            }
            log.datasetMappingError(mapping, "there is no sample which matches the criteria <" + criteria + ">", new Object[0]);
            return null;
        }
        String errMsg = String.format("there should be exacty one sample which matches the criteria '%s', but %d of them were found. Consider using the unique sample code.", criteria, samples.size());
        log.datasetMappingError(mapping, errMsg, new Object[0]);
        return null;
    }

    private List<Sample> tryListSamplesByCriteria(ListSamplesByPropertyCriteria criteria, DataSetMappingInformation mapping, LogUtils log) {
        try {
            return this.openbisService.listSamplesByCriteria(criteria);
        }
        catch (UserFailureException e) {
            log.datasetMappingError(mapping, e.getMessage(), new Object[0]);
            return null;
        }
    }

    private ListSamplesByPropertyCriteria createFindSampleByNameCriteria(DataSetMappingInformation mapping, String sampleCodeOrLabel) {
        LocalExperimentIdentifier experimentIdentifier = DatasetMappingResolver.tryGetExperimentIdentifier(mapping, this.experimentPropertyCodeOrNull);
        ListSamplesByPropertyCriteria criteria = new ListSamplesByPropertyCriteria(this.samplePropertyCodeOrNull, sampleCodeOrLabel, mapping.getSpaceOrGroupCode(), experimentIdentifier);
        return criteria;
    }

    private static LocalExperimentIdentifier tryGetExperimentIdentifier(DataSetMappingInformation mapping, String experimentPropertyCodeOrNull) {
        String experimentName = mapping.getExperimentName();
        String projectCode = mapping.getProjectCode();
        if (experimentName != null && projectCode != null) {
            if (experimentPropertyCodeOrNull != null) {
                return new LocalExperimentIdentifier(projectCode, experimentPropertyCodeOrNull, experimentName);
            }
            return new LocalExperimentIdentifier(projectCode, experimentName);
        }
        return null;
    }

    public boolean isMappingCorrect(DataSetMappingInformation mapping, LogUtils log) {
        if (mapping.getSpaceOrGroupCode() == null) {
            log.datasetMappingError(mapping, "mandatory property 'space' (previously called 'group') not specified. Note: the name 'group' may still be used but will be forbidden in the future.", new Object[0]);
            return false;
        }
        if (mapping.getSpaceCode() != null && mapping.getGroupCode() != null) {
            log.datasetMappingError(mapping, "either 'space' or 'group' should be specified - but not both. Note: the name 'group' may still be used but will be forbidden in the future.", new Object[0]);
            return false;
        }
        if (!this.isExperimentColumnCorrect(mapping, log)) {
            return false;
        }
        if (!DatasetMappingResolver.isConversionColumnValid(mapping, log)) {
            return false;
        }
        ExperimentIdentifier experimentIdentifier = DatasetMappingResolver.tryFigureExperimentIdentifier(mapping);
        if (mapping.getSampleCodeOrLabel() == null && experimentIdentifier == null) {
            log.datasetMappingError(mapping, "neither sample nor experiment has been specified.", new Object[0]);
            return false;
        }
        String sampleCode = this.tryFigureSampleCode(mapping, log);
        if (sampleCode == null) {
            if (mapping.getSampleCodeOrLabel() != null) {
                return false;
            }
            assert (experimentIdentifier != null) : "experimentIdentifier should be not null here";
            return this.experimentExists(mapping, log, experimentIdentifier);
        }
        if (!StringUtils.isBlank((String)mapping.getParentDataSetCodes())) {
            log.datasetMappingError(mapping, "when dataset is connected to a sample it cannot have parent datasets.", new Object[0]);
            return false;
        }
        return this.sampleExistsAndBelongsToExperiment(mapping, sampleCode, log);
    }

    private boolean experimentExists(DataSetMappingInformation mapping, LogUtils log, ExperimentIdentifier experimentIdentifier) {
        try {
            Experiment experiment = this.openbisService.tryGetExperiment(experimentIdentifier);
            if (experiment == null) {
                log.datasetMappingError(mapping, "experiment '%s' does not exist", experimentIdentifier);
                return false;
            }
            return true;
        }
        catch (UserFailureException ex) {
            log.datasetMappingError(mapping, "experiment '%s' does not exist: %s", experimentIdentifier, ex.getMessage());
            return false;
        }
    }

    public static ExperimentIdentifier tryFigureExperimentIdentifier(DataSetMappingInformation mapping) {
        String project = mapping.getProjectCode();
        String experimentCode = mapping.getExperimentName();
        if (project != null && experimentCode != null) {
            return new ExperimentIdentifier(null, mapping.getSpaceOrGroupCode(), project, experimentCode);
        }
        return null;
    }

    private static boolean isConversionColumnValid(DataSetMappingInformation mapping, LogUtils log) {
        String conversionText = mapping.getConversion();
        MLConversionType conversion = MLConversionType.tryCreate(conversionText);
        if (conversion == null) {
            String availableConvTypes = CollectionUtils.abbreviate((Object[])MLConversionType.values(), (int)MLConversionType.values().length);
            log.datasetMappingError(mapping, "unexpected value '%s' in 'conversion' column. Leave the column empty or use one of the allowed values: %s.", conversionText, availableConvTypes);
            return false;
        }
        boolean conversionAllowed = DatasetMappingResolver.isConversionAllowed(mapping);
        if (conversion != MLConversionType.NONE && !conversionAllowed) {
            log.datasetMappingError(mapping, "conversion column must be empty for this type of file.", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean isConversionAllowed(DataSetMappingInformation dataset) {
        String extension = FilenameUtils.getExtension((String)dataset.getFileName());
        boolean conversionRequired = extension.equalsIgnoreCase("mzXML");
        return conversionRequired;
    }

    private boolean sampleExistsAndBelongsToExperiment(DataSetMappingInformation mapping, String sampleCode, LogUtils log) {
        SampleIdentifier sampleIdentifier = this.createSampleIdentifier(sampleCode, mapping);
        if (!this.isConnectedToExperiment(mapping, sampleIdentifier, log)) {
            log.datasetMappingError(mapping, "sample '%s' does not exist or is not connected to any experiment.", sampleIdentifier);
            return false;
        }
        return true;
    }

    private boolean isConnectedToExperiment(DataSetMappingInformation mapping, SampleIdentifier sampleIdentifier, LogUtils log) {
        try {
            Sample sample = this.openbisService.tryGetSampleWithExperiment(sampleIdentifier);
            return sample != null && sample.getExperiment() != null;
        }
        catch (UserFailureException e) {
            log.datasetMappingError(mapping, "error when checking if sample '%s' belongs to an experiment: %s", sampleIdentifier, e.getMessage());
            return false;
        }
    }

    private SampleIdentifier createSampleIdentifier(String sampleCode, DataSetMappingInformation mapping) {
        return new SampleIdentifier(new SpaceIdentifier(null, mapping.getSpaceOrGroupCode()), sampleCode);
    }

    private boolean isExperimentColumnCorrect(DataSetMappingInformation mapping, LogUtils log) {
        if (mapping.getExperimentName() == null != (mapping.getProjectCode() == null)) {
            log.datasetMappingError(mapping, "experiment and project columns should be both empty or should be both filled.", new Object[0]);
            return false;
        }
        if (this.samplePropertyCodeOrNull == null && mapping.getExperimentName() != null) {
            log.datasetMappingError(mapping, "openBis is not configured to use the sample label to identify the sample. You can still identify the sample by the code (clear the experiment column in this case). You can also contact your administrator to change the server configuration and set the property type code which should be used.", new Object[0]);
            return false;
        }
        return true;
    }
}

