/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDropboxProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.yeastx.etl.AbstractDatasetDropboxHandlerYeastX;
import java.io.File;
import java.util.Properties;

public class DropboxProcessingPluginYeastX
extends AbstractDropboxProcessingPlugin {
    public static final String DROPBOX_INCOMING_DIRECTORY_PROPERTY = "dropbox-dir";
    private static final long serialVersionUID = 1L;

    public DropboxProcessingPluginYeastX() {
        this(null, null);
    }

    public DropboxProcessingPluginYeastX(Properties properties, File storeRoot) {
        super(properties, storeRoot, (IPostRegistrationDatasetHandler)new DatasetDropboxHandler(properties));
    }

    protected String getProcessingDescription(DatasetDescription dataset, DataSetProcessingContext context) {
        return "Copy to " + this.properties.getProperty(DROPBOX_INCOMING_DIRECTORY_PROPERTY);
    }

    private static final class DatasetDropboxHandler
    extends AbstractDatasetDropboxHandlerYeastX {
        private static final long serialVersionUID = 1L;
        private final File dropboxDir;

        public DatasetDropboxHandler(Properties properties) {
            super(properties);
            this.dropboxDir = this.getDropboxDir(properties);
        }

        private File getDropboxDir(Properties properties) {
            File dir = this.tryGetDirectory(DropboxProcessingPluginYeastX.DROPBOX_INCOMING_DIRECTORY_PROPERTY, properties);
            if (dir == null) {
                throw EnvironmentFailureException.fromTemplate((String)"Property '%s' is not set.", (Object[])new Object[]{DropboxProcessingPluginYeastX.DROPBOX_INCOMING_DIRECTORY_PROPERTY});
            }
            return dir;
        }

        protected File tryGetDropboxDir(File originalData, DataSetInformation dataSetInformation) {
            return this.dropboxDir;
        }
    }
}

