/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.cli.AbstractExecutor;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CommandPreferencesLister
extends AbstractCinaCommand<CommandListPreferencesArguments> {
    public CommandPreferencesLister() {
        super(new CommandListPreferencesArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new PreferencesListerExecutor(this).execute(args);
    }

    @Override
    public String getName() {
        return "listprefs";
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "[<sample type code>]";
    }

    static class CommandListPreferencesArguments
    extends GlobalArguments {
        CommandListPreferencesArguments() {
        }

        public String getSampleTypeCode() {
            if (this.getArguments().size() < 1) {
                return "CINA_BROWSER_PREFERENCES";
            }
            String sampleTypeCode = this.getArguments().get(0);
            if (sampleTypeCode.length() > 0) {
                return sampleTypeCode.toUpperCase();
            }
            return "CINA_BROWSER_PREFERENCES";
        }

        @Override
        public boolean allAdditionalMandatoryArgumentsPresent() {
            return this.getSampleTypeCode() != null;
        }
    }

    private static class PreferencesListerExecutor
    extends AbstractExecutor<CommandListPreferencesArguments> {
        private static final String FIELD_SEPARATOR = "\t";

        PreferencesListerExecutor(CommandPreferencesLister command) {
            super(command);
        }

        @Override
        protected ResultCode doExecute(ICinaUtilities component) {
            SearchCriteria searchCriteria = new SearchCriteria();
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.TYPE, ((CommandListPreferencesArguments)this.arguments).getSampleTypeCode()));
            List<Sample> samples = component.searchForSamples(searchCriteria);
            List<DataSet> results = component.listDataSets(samples);
            this.printHeader();
            this.printResults(results);
            return ResultCode.OK;
        }

        private void printHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append("DATE");
            sb.append(FIELD_SEPARATOR);
            sb.append("DATA SET CODE");
            System.out.println(sb.toString());
        }

        private void printResults(List<DataSet> results) {
            Collections.sort(results, new Comparator<DataSet>(){

                @Override
                public int compare(DataSet o1, DataSet o2) {
                    return o2.getRegistrationDate().compareTo(o1.getRegistrationDate());
                }
            });
            for (DataSet dataSet : results) {
                StringBuilder sb = new StringBuilder();
                String registrationDate = DateFormat.getDateTimeInstance().format(dataSet.getRegistrationDate());
                sb.append(registrationDate);
                sb.append(FIELD_SEPARATOR);
                sb.append(dataSet.getCode());
                System.out.println(sb.toString());
            }
        }
    }
}

