/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogAnnotation;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class LogInvocationHandler
implements InvocationHandler {
    private final Object object;
    private final String name;
    private final Level defaultLogLevel;
    private final Class<?> classUsedToNameLogger;
    private final boolean onlyIfAnnotated;

    public LogInvocationHandler(Object object, String name, Level logLevel, Class<?> classUsedToNameLogger) {
        this(object, name, logLevel, classUsedToNameLogger, false);
    }

    public LogInvocationHandler(Object object, String name, Level logLevel, Class<?> classUsedToNameLogger, boolean onlyIfAnnotated) {
        this.object = object;
        this.name = name;
        this.defaultLogLevel = logLevel;
        this.classUsedToNameLogger = classUsedToNameLogger;
        this.onlyIfAnnotated = onlyIfAnnotated;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StringBuilder builder;
        Logger logger;
        Level logLevel;
        Throwable throwable3;
        Throwable throwable2;
        long time;
        block17: {
            int i;
            block18: {
                Object object;
                time = System.currentTimeMillis();
                throwable2 = null;
                try {
                    object = method.invoke(this.object, args);
                }
                catch (InvocationTargetException e) {
                    try {
                        throwable2 = e.getCause();
                        throw throwable2;
                        catch (UndeclaredThrowableException e2) {
                            throwable2 = e2.getCause();
                            throw throwable2;
                        }
                        catch (Throwable t) {
                            throwable2 = t;
                            throw t;
                        }
                    }
                    catch (Throwable throwable3) {
                        LogAnnotation logAnnotationOrNull = this.tryGetAnnotation(method);
                        if (this.onlyIfAnnotated) {
                            if (logAnnotationOrNull == null) throw throwable3;
                        }
                        logLevel = this.getLogLevel(method, logAnnotationOrNull);
                        logger = this.createLogger(method, logAnnotationOrNull);
                        if (throwable2 == null) {
                            if (!logger.isEnabledFor((Priority)logLevel)) throw throwable3;
                        }
                        builder = new StringBuilder(throwable2 == null ? "Successful" : "Failed");
                        builder.append(" invocation of ");
                        builder.append(this.name).append('.').append(method.getName()).append('(');
                        if (args == null) break block17;
                        i = 0;
                        break block18;
                    }
                }
                LogAnnotation logAnnotationOrNull = this.tryGetAnnotation(method);
                if (this.onlyIfAnnotated) {
                    if (logAnnotationOrNull == null) return object;
                }
                Level logLevel2 = this.getLogLevel(method, logAnnotationOrNull);
                Logger logger2 = this.createLogger(method, logAnnotationOrNull);
                if (throwable2 == null) {
                    if (!logger2.isEnabledFor((Priority)logLevel2)) return object;
                }
                StringBuilder builder2 = new StringBuilder(throwable2 == null ? "Successful" : "Failed");
                builder2.append(" invocation of ");
                builder2.append(this.name).append('.').append(method.getName()).append('(');
                if (args != null) {
                    int i2 = 0;
                    while (i2 < args.length) {
                        builder2.append(args[i2]);
                        if (i2 < args.length - 1) {
                            builder2.append(", ");
                        }
                        ++i2;
                    }
                }
                builder2.append(") took ").append(System.currentTimeMillis() - time).append(" msec");
                if (throwable2 == null) {
                    logger2.log((Priority)logLevel2, (Object)builder2.toString());
                    return object;
                }
                logger2.error((Object)builder2.toString(), throwable2);
                return object;
            }
            while (i < args.length) {
                builder.append(args[i]);
                if (i < args.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
        }
        builder.append(") took ").append(System.currentTimeMillis() - time).append(" msec");
        if (throwable2 == null) {
            logger.log((Priority)logLevel, (Object)builder.toString());
            throw throwable3;
        }
        logger.error((Object)builder.toString(), throwable2);
        throw throwable3;
    }

    private final LogAnnotation tryGetAnnotation(Method method) {
        return method.getAnnotation(LogAnnotation.class);
    }

    private final Level getLogLevel(Method method, LogAnnotation annotationOrNull) {
        if (annotationOrNull == null) {
            return Level.DEBUG;
        }
        if (annotationOrNull.logLevel().equals((Object)LogLevel.UNDEFINED)) {
            return this.defaultLogLevel;
        }
        return Log4jSimpleLogger.toLog4jPriority(annotationOrNull.logLevel());
    }

    private final Logger createLogger(Method method, LogAnnotation annotationOrNull) {
        LogCategory logCategory = annotationOrNull == null ? LogCategory.OPERATION : annotationOrNull.logCategory();
        return LogFactory.getLogger(logCategory, this.classUsedToNameLogger);
    }
}

