/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class ExternalDataLocationNode
implements IDatasetLocationNode {
    private AbstractExternalData externalData;

    public ExternalDataLocationNode(AbstractExternalData externalData) {
        if (externalData == null) {
            throw new IllegalArgumentException("ExternalData cannot be null");
        }
        this.externalData = externalData;
    }

    @Override
    public IDatasetLocation getLocation() {
        PhysicalDataSet dataSet = this.externalData.tryGetAsDataSet();
        if (dataSet == null) {
            throw new IllegalArgumentException("Couldn't retrieve full data set infomation from data set " + this.externalData.getCode());
        }
        return dataSet;
    }

    @Override
    public boolean isContainer() {
        return this.externalData.isContainer();
    }

    @Override
    public Collection<IDatasetLocationNode> getComponents() {
        if (!this.isContainer()) {
            return Collections.emptyList();
        }
        ContainerDataSet container = this.externalData.tryGetAsContainerDataSet();
        List<AbstractExternalData> containedExternalDatas = container.getContainedDataSets();
        if (containedExternalDatas != null) {
            TreeMap<String, ExternalDataLocationNode> containedLocationNodes = new TreeMap<String, ExternalDataLocationNode>();
            for (AbstractExternalData containedExternalData : containedExternalDatas) {
                containedLocationNodes.put(containedExternalData.getCode(), new ExternalDataLocationNode(containedExternalData));
            }
            return containedLocationNodes.values();
        }
        return Collections.emptyList();
    }
}

