/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="authorization_groups")
@Friend(toClasses={RoleAssignmentPE.class})
public class AuthorizationGroupPE
extends HibernateAbstractRegistrationHolder
implements Comparable<AuthorizationGroupPE>,
IIdAndCodeHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    private Long id;
    private DatabaseInstancePE databaseInstance;
    private String code;
    private String description;
    private Date modificationDate;
    private Set<RoleAssignmentPE> roleAssignments = new HashSet<RoleAssignmentPE>();
    private Set<PersonPE> persons = new HashSet<PersonPE>();

    @Override
    @SequenceGenerator(name="AUTHORIZATION_GROUP_ID_SEQ", sequenceName="AUTHORIZATION_GROUP_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTHORIZATION_GROUP_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="authorizationGroupInternal")
    private Set<RoleAssignmentPE> getRoleAssignmentsInternal() {
        return this.roleAssignments;
    }

    private void setRoleAssignmentsInternal(Set<RoleAssignmentPE> rolesAssignments) {
        this.roleAssignments = rolesAssignments;
    }

    public final void setRoleAssignments(Set<RoleAssignmentPE> rolesAssignments) {
        this.getRoleAssignmentsInternal().clear();
        for (RoleAssignmentPE child : rolesAssignments) {
            this.addRoleAssignment(child);
        }
    }

    @Transient
    public final Set<RoleAssignmentPE> getRoleAssignments() {
        return new UnmodifiableSetDecorator<RoleAssignmentPE>(this.getRoleAssignmentsInternal());
    }

    public void addRoleAssignment(RoleAssignmentPE roleAssignment) {
        AuthorizationGroupPE authGroup = roleAssignment.getAuthorizationGroup();
        if (authGroup != null) {
            authGroup.removeRoleAssigment(roleAssignment);
        }
        roleAssignment.setAuthorizationGroupInternal(this);
        this.getRoleAssignmentsInternal().add(roleAssignment);
    }

    public void removeRoleAssigment(RoleAssignmentPE roleAssignment) {
        assert (roleAssignment != null) : "Unspecified role assignment.";
        this.getRoleAssignmentsInternal().remove(roleAssignment);
        roleAssignment.setAuthorizationGroupInternal(null);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="authorizationGroupsInternal")
    private Set<PersonPE> getPersonsInternal() {
        return this.persons;
    }

    @Transient
    public final Set<PersonPE> getPersons() {
        return new UnmodifiableSetDecorator<PersonPE>(this.getPersonsInternal());
    }

    public void removePerson(PersonPE person) {
        assert (person != null) : "Unspecified person.";
        this.getPersonsInternal().remove(person);
        person.getAuthorizationGroupsInternal().remove(this);
    }

    public void addPerson(PersonPE person) {
        assert (person != null) : "Unspecified person.";
        person.getAuthorizationGroupsInternal().add(this);
        this.getPersonsInternal().add(person);
    }

    private void setPersonsInternal(Set<PersonPE> persons) {
        this.persons = persons;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AuthorizationGroupPE)) {
            return false;
        }
        AuthorizationGroupPE that = (AuthorizationGroupPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("dbInstance", (Object)this.getDatabaseInstance());
        return builder.toString();
    }

    @Override
    public int compareTo(AuthorizationGroupPE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }
}

