/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractFileSystemTestCase
extends AssertJUnit {
    protected static final String UNIT_TEST_WORKING_DIRECTORY = "unit-test-wd";
    protected static final String TARGETS_DIRECTORY = "targets";
    protected static final File UNIT_TEST_ROOT_DIRECTORY = new File("targets" + File.separator + "unit-test-wd");
    protected final File workingDirectory = this.createWorkingDirectory();
    private final boolean cleanAfterMethod;

    protected AbstractFileSystemTestCase() {
        this(true);
    }

    protected AbstractFileSystemTestCase(boolean cleanAfterMethod) {
        this.cleanAfterMethod = cleanAfterMethod;
    }

    protected File create(String name) {
        File file = new File(this.workingDirectory, name);
        file.delete();
        file.deleteOnExit();
        return file;
    }

    protected final File createDirectoryInUnitTestRoot(String dirName) {
        File directory = new File(UNIT_TEST_ROOT_DIRECTORY, dirName);
        directory.mkdirs();
        directory.deleteOnExit();
        return directory;
    }

    private final File createWorkingDirectory() {
        return this.createDirectoryInUnitTestRoot(((Object)((Object)this)).getClass().getName());
    }

    @BeforeMethod
    public void setUp() throws IOException {
        this.cleanUpDirectoryBeforeTheTest(this.workingDirectory);
    }

    protected void cleanUpDirectoryBeforeTheTest(File directory) {
        this.deleteDirectory(directory);
        directory.mkdirs();
        AbstractFileSystemTestCase.assertEquals((boolean)true, (boolean)directory.isDirectory());
        File[] files = directory.listFiles();
        if (files != null) {
            AbstractFileSystemTestCase.assertEquals((String)("Unexpected files " + Arrays.asList(files)), (int)0, (int)files.length);
        }
    }

    private void deleteDirectory(File dir) {
        try {
            FileUtils.deleteDirectory(dir);
        }
        catch (IOException e) {
            System.err.println("Could not delete the directory " + dir.getPath() + " because: " + e.getMessage());
            try {
                FileUtils.deleteDirectory(dir);
            }
            catch (IOException e2) {
                System.err.println("Could not delete the directory " + dir.getPath() + " in second try because: " + e2.getMessage());
            }
        }
    }

    @AfterClass
    public void afterClass() throws IOException {
        if (!this.cleanAfterMethod) {
            return;
        }
        try {
            FileUtils.deleteDirectory(this.workingDirectory);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }
}

