/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.tar;

import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.io.MonitoredIOStreamCopier;
import ch.systemsx.cisd.common.logging.ConsoleLogger;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class Tar
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private static final Map<Integer, String> userMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> groupMap = new HashMap<Integer, String>();
    private final TarArchiveOutputStream out;
    private final MonitoredIOStreamCopier copier;

    public Tar(File tarFile) throws FileNotFoundException {
        this(tarFile, 131072);
    }

    public Tar(File tarFile, int bufferSize) throws FileNotFoundException {
        this(tarFile, new MonitoredIOStreamCopier(bufferSize));
    }

    public Tar(File tarFile, MonitoredIOStreamCopier copier) throws FileNotFoundException {
        this.out = new TarArchiveOutputStream((OutputStream)new FileOutputStream(tarFile));
        this.out.setLongFileMode(2);
        this.out.setBigNumberMode(2);
        this.out.setAddPaxHeadersForNonAsciiNames(true);
        this.copier = copier;
    }

    public void add(File file, int stripFromName) throws IOException {
        if (file.isDirectory()) {
            this.addDirectory(stripFromName, file);
        } else {
            this.addFile(stripFromName, file);
        }
    }

    public void add(String name) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        if (Unix.isOperational()) {
            entry.setUserId(Unix.getUid());
            entry.setGroupId(Unix.getGid());
        }
        this.add(entry, (InputStream)null);
    }

    public void add(String name, byte[] data) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        if (Unix.isOperational()) {
            entry.setUserId(Unix.getUid());
            entry.setGroupId(Unix.getGid());
        }
        this.add(entry, data);
    }

    public void add(TarArchiveEntry entry, byte[] data) throws IOException {
        entry.setSize((long)data.length);
        this.add(entry, new ByteArrayInputStream(data));
    }

    public void add(TarArchiveEntry entry, InputStream input) throws IOException {
        if (StringUtils.isBlank(entry.getUserName())) {
            String username = this.tryGetUserName(entry.getUserId());
            if (username == null) {
                username = System.getProperty("user.name", "");
            }
            entry.setUserName(username);
        }
        if (StringUtils.isBlank(entry.getGroupName())) {
            String groupname = this.tryGetGroupName(entry.getGroupId());
            if (groupname == null) {
                groupname = "";
            }
            entry.setGroupName(groupname);
        }
        this.out.putArchiveEntry((ArchiveEntry)entry);
        try {
            if (input != null) {
                this.copier.copy(input, (OutputStream)this.out);
            }
        }
        finally {
            this.out.closeArchiveEntry();
        }
    }

    @Override
    public void close() throws IOException {
        this.copier.close();
        this.out.close();
    }

    private void addDirectory(int rootDirectoryLength, File directory) throws IOException {
        File[] files;
        String relativeDirName = directory.getPath().substring(rootDirectoryLength);
        if (!relativeDirName.isEmpty()) {
            this.out.putArchiveEntry((ArchiveEntry)this.createArchiveEntry(directory, rootDirectoryLength, true));
            this.out.closeArchiveEntry();
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.addDirectory(rootDirectoryLength, f);
            } else {
                this.addFile(rootDirectoryLength, f);
            }
            ++n2;
        }
    }

    private void addFile(int rootDirectoryLength, File f) throws IOException, FileNotFoundException {
        this.out.putArchiveEntry((ArchiveEntry)this.createArchiveEntry(f, rootDirectoryLength, false));
        FileInputStream in = new FileInputStream(f);
        try {
            this.copier.copy(in, (OutputStream)this.out);
        }
        finally {
            this.out.closeArchiveEntry();
            ((InputStream)in).close();
        }
    }

    private String tryGetGroupName(int gid) {
        String cached = groupMap.get(gid);
        if (cached == null) {
            String name = Unix.tryGetGroupNameForGid(gid);
            if (name != null) {
                groupMap.put(gid, name);
            }
            return name;
        }
        return cached;
    }

    private String tryGetUserName(int uid) {
        String cached = userMap.get(uid);
        if (cached == null) {
            String name = Unix.tryGetUserNameForUid(uid);
            if (name != null) {
                userMap.put(uid, name);
            }
            return name;
        }
        return cached;
    }

    private TarArchiveEntry createArchiveEntry(File file, int rootDirectoryLength, boolean addSlash) {
        Unix.Stat stat = Unix.isOperational() ? Unix.tryGetLinkInfo(file.getPath()) : null;
        String relativeName = file.getPath().substring(rootDirectoryLength + 1);
        if (addSlash) {
            relativeName = String.valueOf(relativeName) + "/";
        }
        if (stat == null) {
            return new TarArchiveEntry(file, relativeName);
        }
        TarArchiveEntry e = this.createArchiveEntry(relativeName, stat);
        return e;
    }

    private TarArchiveEntry createArchiveEntry(String name, Unix.Stat stat) {
        String groupname;
        byte linkType = stat.getLinkType() == FileLinkType.SYMLINK ? (byte)50 : (stat.getLinkType() == FileLinkType.DIRECTORY ? (byte)53 : 48);
        TarArchiveEntry e = new TarArchiveEntry(name, linkType, false);
        e.setModTime(stat.getLastModified() * 1000L);
        e.setMode((int)stat.getPermissions());
        e.setUserId(stat.getUid());
        String username = this.tryGetUserName(stat.getUid());
        if (username != null) {
            e.setUserName(username);
        }
        if ((groupname = this.tryGetGroupName(stat.getGid())) != null) {
            e.setGroupName(groupname);
        }
        e.setGroupId(stat.getGid());
        if (linkType == 50) {
            e.setLinkName(stat.tryGetSymbolicLink());
            e.setSize(0L);
        } else if (linkType == 53) {
            e.setSize(0L);
        } else {
            e.setSize(stat.getSize());
        }
        return e;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Tar [-p] <tarfile> <directory>");
            System.exit(1);
        }
        int tarFileIndex = 0;
        int dirIndex = 1;
        boolean parallel = args[0].equals("-p");
        if (parallel) {
            ++tarFileIndex;
            ++dirIndex;
        }
        File tarFile = new File(args[tarFileIndex]);
        File directory = new File(args[dirIndex]);
        Tar tar = null;
        try {
            Long maxQueueSize = parallel ? Long.valueOf(0x500000L) : null;
            MonitoredIOStreamCopier copier = new MonitoredIOStreamCopier(0x100000, maxQueueSize);
            copier.setLogger(new ConsoleLogger());
            tar = new Tar(tarFile, copier);
            tar.add(directory, directory.getPath().length());
        }
        finally {
            if (tar != null) {
                tar.close();
            }
        }
    }
}

