/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public final class BufferedAppender
extends WriterAppender {
    private final ByteArrayOutputStream logRecorder = new ByteArrayOutputStream();

    public BufferedAppender() {
        this(Level.DEBUG);
    }

    public BufferedAppender(Level logLevel) {
        this(null, logLevel);
    }

    public BufferedAppender(String pattern, Level logLevel) {
        this(pattern, logLevel, null);
    }

    public BufferedAppender(String patternOrNull, Level logLevel, String loggerNameRegex) {
        if (loggerNameRegex != null) {
            final Pattern pattern = Pattern.compile(loggerNameRegex);
            this.addFilter(new Filter(){

                @Override
                public int decide(LoggingEvent event) {
                    String loggerName = event.getLoggerName();
                    return pattern.matcher(loggerName).matches() ? 1 : -1;
                }
            });
        }
        this.setWriter(this.createWriter(this.logRecorder));
        this.setLayout(this.createLayout(patternOrNull));
        this.configureRootLogger();
        this.setThreshold(logLevel);
    }

    public void addRegexForLoggingEventsToBeDropped(String loggerNameRegex) {
        final Pattern pattern = Pattern.compile(loggerNameRegex);
        this.addFilter(new Filter(){

            @Override
            public int decide(LoggingEvent event) {
                String loggerName = event.getLoggerName();
                return pattern.matcher(loggerName).matches() ? -1 : 1;
            }
        });
    }

    private final void configureRootLogger() {
        Logger.getRootLogger().addAppender(this);
    }

    protected Layout createLayout(String pattern) {
        return new PatternLayout(pattern);
    }

    public final String getLogContent() {
        return new String(this.logRecorder.toByteArray()).trim();
    }

    public List<String> getLogLines() {
        return Arrays.asList(this.getLogContent().split("\n"));
    }

    public final void resetLogContent() {
        this.logRecorder.reset();
    }

    @Override
    public final void reset() {
        Logger.getRootLogger().removeAppender(this);
        super.reset();
    }

    public final String toString() {
        return this.getEncoding();
    }
}

