/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractScriptExecutor
implements PanelAction {
    protected static final String INSTALL_BIN_PATH_VARNAME = "INSTALL_BIN_PATH";

    @Override
    public final synchronized void executeAction(AutomatedInstallData data, AbstractUIHandler handler) {
        try {
            this.executeAction(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handler.emitErrorAndBlockNext("Error", ex.toString());
        }
    }

    protected abstract void executeAction(AutomatedInstallData var1);

    protected String getAdminScript(AutomatedInstallData data, String scriptFileName) {
        File adminScriptFile = this.getAdminScriptFile(data, scriptFileName);
        return adminScriptFile.getAbsolutePath();
    }

    protected File getAdminScriptFile(AutomatedInstallData data, String scriptFileName) {
        return new File(data.getVariable(INSTALL_BIN_PATH_VARNAME), scriptFileName);
    }

    protected void executeAdminScript(Map<String, String> customEnv, String ... command) {
        this.executeAdminScript(customEnv, System.out, System.err, command);
    }

    protected void executeAdminScript(Map<String, String> customEnv, OutputStream out, OutputStream err, String ... command) {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().putAll(System.getenv());
        if (customEnv != null) {
            pb.environment().putAll(customEnv);
        }
        try {
            ByteArrayOutputStream stdOutput = new ByteArrayOutputStream();
            ByteArrayOutputStream errOutput = new ByteArrayOutputStream();
            Process process = pb.start();
            this.pipe(process.getErrorStream(), new DelegatingOutputStream(errOutput, err));
            this.pipe(process.getInputStream(), new DelegatingOutputStream(stdOutput, out));
            int returnValue = process.waitFor();
            if (returnValue != 0) {
                System.err.println("Executing of command " + pb.command() + " has failed. Aborting ...");
                throw new RuntimeException("Executing of command " + pb.command() + " has failed:\n" + "Exit value: " + returnValue + "\n" + "-------- Std out ---------\n" + stdOutput + "\n" + "-------- Err out ---------\n" + errOutput);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error executing " + command[0] + ": " + e.getMessage(), e);
        }
    }

    private void pipe(final InputStream src, final OutputStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        dest.write(buffer, 0, n);
                        n = src.read(buffer);
                    }
                }
                catch (IOException iOException) {}
            }
        }).start();
    }

    private static final class DelegatingOutputStream
    extends OutputStream {
        private OutputStream[] outputStreams;

        DelegatingOutputStream(OutputStream ... outputStreams) {
            this.outputStreams = outputStreams;
        }

        @Override
        public void write(int b) throws IOException {
            OutputStream[] outputStreamArray = this.outputStreams;
            int n = this.outputStreams.length;
            int n2 = 0;
            while (n2 < n) {
                OutputStream outputStream = outputStreamArray[n2];
                outputStream.write(b);
                ++n2;
            }
        }
    }
}

