/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class Extractor {
    public static void main(String[] args) throws Exception {
        Parameters parameters = Parameters.parse(args);
        if (parameters.getErrorMessageOrNull() != null) {
            System.err.println("ERROR: " + parameters.getErrorMessageOrNull());
            System.err.println("Usage: java " + Extractor.class.getName() + " [-q] as|dss|scripts <installation path>");
            System.exit(1);
        }
        ConsoleOutput out = new ConsoleOutput(parameters.isQuiet());
        VariableResolver variableResolver = new VariableResolver(parameters.getInstallationPath());
        ResourceManager resourceManager = ResourceManager.getInstance();
        Info info = (Info)Extractor.readObject(resourceManager, "info");
        out.println(String.valueOf(info.getAppName()) + " Version " + info.getAppVersion());
        List<Pack> availablePacks = Extractor.getAvailablePacks(resourceManager);
        for (Pack pack : availablePacks) {
            if (!parameters.getPackageName().equals(pack.name)) continue;
            out.println("Extract package '" + pack.name + "' (" + pack.nbytes + " bytes)");
            Extractor.extractPackage(pack, info, resourceManager, variableResolver, out);
            break;
        }
    }

    private static void extractPackage(Pack pack, Info info, ResourceManager resourceManager, VariableResolver variableResolver, ConsoleOutput out) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(Extractor.getPackAsStream(resourceManager, pack.id, info));
        try {
            int numberOfFiles = objectInputStream.readInt();
            int j = 0;
            while (j < numberOfFiles) {
                PackFile packFile = (PackFile)objectInputStream.readObject();
                String targetPath = variableResolver.resolve(packFile.getTargetPath());
                out.println(targetPath);
                File target = new File(targetPath);
                if (packFile.isDirectory()) {
                    target.mkdirs();
                } else {
                    target.getParentFile().mkdirs();
                    Extractor.extractFile(packFile, objectInputStream, target, resourceManager);
                }
                ++j;
            }
        }
        finally {
            objectInputStream.close();
        }
    }

    private static void extractFile(PackFile packFile, ObjectInputStream objectInputStream, File target, ResourceManager resourceManager) throws Exception {
        block10: {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(target);
                if (packFile.isPack200Jar()) {
                    int key = objectInputStream.readInt();
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    InputStream pack200Input = resourceManager.getInputStream("/packs/pack200-" + key);
                    JarOutputStream jarOutputStream = null;
                    try {
                        jarOutputStream = new JarOutputStream(outputStream);
                        unpacker.unpack(pack200Input, jarOutputStream);
                        break block10;
                    }
                    finally {
                        if (jarOutputStream != null) {
                            jarOutputStream.close();
                        }
                    }
                }
                byte[] buffer = new byte[5120];
                long numberOfBytesAlreadyRead = 0L;
                while (numberOfBytesAlreadyRead < packFile.length()) {
                    numberOfBytesAlreadyRead = Extractor.writeBuffer(packFile, buffer, outputStream, objectInputStream, numberOfBytesAlreadyRead);
                }
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
    }

    private static List<Pack> getAvailablePacks(ResourceManager resourceManager) throws Exception {
        InputStream in = resourceManager.getInputStream("packs.info");
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(in);
            int size = objectInputStream.readInt();
            ArrayList<Pack> availablePacks = new ArrayList<Pack>();
            int i = 0;
            while (i < size) {
                Pack pack = (Pack)objectInputStream.readObject();
                if (OsConstraintHelper.oneMatchesCurrentSystem(pack.osConstraints)) {
                    availablePacks.add(pack);
                }
                ++i;
            }
            ArrayList<Pack> arrayList = availablePacks;
            return arrayList;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    private static long writeBuffer(PackFile packFile, byte[] buffer, OutputStream out, InputStream inputStream, long numberOfBytesAlreadyRead) throws IOException {
        int maxBytes = (int)Math.min(packFile.length() - numberOfBytesAlreadyRead, (long)buffer.length);
        int numberOfBytesRead = inputStream.read(buffer, 0, maxBytes);
        if (numberOfBytesRead == -1) {
            throw new IOException("Unexpected end of input stream.");
        }
        out.write(buffer, 0, numberOfBytesRead);
        return numberOfBytesAlreadyRead + (long)numberOfBytesRead;
    }

    private static InputStream getPackAsStream(ResourceManager resourceManager, String packid, Info info) throws Exception {
        InputStream in = resourceManager.getInputStream("packs/pack-" + packid);
        if (in == null) {
            throw new IOException("Unkown package '" + packid + "'.");
        }
        String decoderClassName = info.getPackDecoderClassName();
        if (decoderClassName == null) {
            return in;
        }
        Class<?> decoder = Class.forName(decoderClassName);
        Class[] paramsClasses = new Class[]{Class.forName("java.io.InputStream")};
        Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
        BufferedInputStream buffer = new BufferedInputStream(in);
        Object[] params = new Object[]{buffer};
        Object instance = null;
        instance = constructor.newInstance(params);
        if (!InputStream.class.isInstance(instance)) {
            throw new InstallerException("'" + decoderClassName + "' must be derived from " + InputStream.class.toString());
        }
        return instance;
    }

    private static Object readObject(ResourceManager resourceManager, String resourceId) throws Exception {
        InputStream inputStream = resourceManager.getInputStream(resourceId);
        ObjectInputStream objectInputStream = null;
        try {
            Object model;
            objectInputStream = new ObjectInputStream(inputStream);
            Object object = model = objectInputStream.readObject();
            return object;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    private static final class ConsoleOutput {
        private final boolean quiet;

        ConsoleOutput(boolean quiet) {
            this.quiet = quiet;
        }

        void println(String message) {
            if (!this.quiet) {
                System.out.println(message);
            }
        }
    }

    private static final class Parameters {
        private static final String MISSING_PARAMETER_ERROR = "Missing parameters.";
        private boolean quiet;
        private String packageName;
        private String installationPath;
        private String errorMessage;

        private Parameters() {
        }

        static Parameters parse(String[] args) {
            Parameters parameters = new Parameters();
            if (args.length < 2) {
                return Parameters.setErrorMessage(parameters, MISSING_PARAMETER_ERROR);
            }
            String shortPackageName = args[0];
            parameters.installationPath = args[1];
            if (args[0].equals("-q")) {
                parameters.quiet = true;
                if (args.length < 3) {
                    return Parameters.setErrorMessage(parameters, MISSING_PARAMETER_ERROR);
                }
                shortPackageName = args[1];
                parameters.installationPath = args[2];
            }
            if (shortPackageName.equals("as")) {
                parameters.packageName = "openBIS Server";
            } else if (shortPackageName.equals("dss")) {
                parameters.packageName = "Datastore Server";
            } else if (shortPackageName.equals("scripts")) {
                parameters.packageName = "Administration Scripts";
            } else {
                parameters.errorMessage = "Unkown package '" + shortPackageName + "'.";
            }
            return parameters;
        }

        private static Parameters setErrorMessage(Parameters parameters, String errorMessage) {
            parameters.errorMessage = errorMessage;
            return parameters;
        }

        boolean isQuiet() {
            return this.quiet;
        }

        String getPackageName() {
            return this.packageName;
        }

        String getInstallationPath() {
            return this.installationPath;
        }

        String getErrorMessageOrNull() {
            return this.errorMessage;
        }
    }

    private static final class VariableResolver {
        private final List<String[]> substitutions = new ArrayList<String[]>();

        VariableResolver(String rootPath) {
            this.substitutions.add(new String[]{"$INSTALL_PATH/servers", rootPath});
            this.substitutions.add(new String[]{"$INSTALL_PATH", rootPath});
            this.substitutions.add(new String[]{"$INSTALL_TMPEXTRACT", rootPath});
            this.substitutions.add(new String[]{"$DATA_TMPEXTRACT", String.valueOf(rootPath) + "/datastore_server"});
        }

        public String resolve(String string) {
            String result = string;
            for (String[] pair : this.substitutions) {
                result = result.replace(pair[0], pair[1]);
            }
            return result;
        }
    }
}

