/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.injectors.SingleMemberInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjector<T>
extends SingleMemberInjector<T> {
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard instantiationGuard;
    private final String methodName;

    public MethodInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, String methodName, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
        this.methodName = methodName;
    }

    protected Method getInjectorMethod() {
        Method[] methods = new Method[]{};
        try {
            methods = super.getComponentImplementation().getMethods();
        }
        catch (AbstractInjector.AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        for (Method method : methods) {
            if (!method.getName().equals(this.methodName)) continue;
            return method;
        }
        return null;
    }

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Object inst = null;
                    ComponentMonitor componentMonitor = MethodInjector.this.currentMonitor();
                    try {
                        componentMonitor.instantiating(container, MethodInjector.this, null);
                        long startTime = System.currentTimeMillis();
                        Object[] methodParameters = null;
                        inst = MethodInjector.this.getComponentImplementation().newInstance();
                        if (method != null) {
                            methodParameters = MethodInjector.this.getMemberArguments(this.guardedContainer, method);
                            MethodInjector.this.invokeMethod(method, methodParameters, inst, container);
                        }
                        componentMonitor.instantiated(container, MethodInjector.this, null, inst, methodParameters, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InstantiationException e) {
                        return MethodInjector.this.caughtInstantiationException(componentMonitor, null, e, container);
                    }
                    catch (IllegalAccessException e) {
                        return MethodInjector.this.caughtIllegalAccessException(componentMonitor, method, inst, e);
                    }
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected Object[] getMemberArguments(PicoContainer container, Method method) {
        return super.getMemberArguments(container, method, method.getParameterTypes(), this.getBindings(method.getParameterAnnotations()));
    }

    @Override
    public Object decorateComponentInstance(final PicoContainer container, Type into, final T instance) {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Method method = MethodInjector.this.getInjectorMethod();
                    if (method.getDeclaringClass().isAssignableFrom(instance.getClass())) {
                        Object[] methodParameters = MethodInjector.this.getMemberArguments(this.guardedContainer, method);
                        return MethodInjector.this.invokeMethod(method, methodParameters, instance, container);
                    }
                    return null;
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        Object o = this.instantiationGuard.observe(this.getComponentImplementation());
        return o;
    }

    private Object invokeMethod(Method method, Object[] methodParameters, T instance, PicoContainer container) {
        try {
            Object rv = this.currentMonitor().invoking(container, this, method, instance, methodParameters);
            if (rv == ComponentMonitor.KEEP) {
                long str = System.currentTimeMillis();
                rv = method.invoke(instance, methodParameters);
                this.currentMonitor().invoked(container, this, method, instance, System.currentTimeMillis() - str, methodParameters, rv);
            }
            return rv;
        }
        catch (IllegalAccessException e) {
            return this.caughtIllegalAccessException(this.currentMonitor(), method, instance, e);
        }
        catch (InvocationTargetException e) {
            this.currentMonitor().invocationFailed(method, instance, e);
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new PicoCompositionException(e);
        }
    }

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run() {
                    Method method = MethodInjector.this.getInjectorMethod();
                    Type[] parameterTypes = method.getParameterTypes();
                    Parameter[] currentParameters = MethodInjector.this.parameters != null ? MethodInjector.this.parameters : MethodInjector.this.createDefaultParameters(parameterTypes);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, MethodInjector.this, parameterTypes[i], new ParameterNameBinding(MethodInjector.this.getParanamer(), method, i), MethodInjector.this.useNames(), MethodInjector.this.getBindings(method.getParameterAnnotations())[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    @Override
    public String getDescriptor() {
        return "MethodInjector-";
    }

    @Override
    protected boolean isNullParamAllowed(AccessibleObject member, int i) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = ((Method)member).getParameterAnnotations()[i]) {
            if (!(annotation instanceof Nullable)) continue;
            return true;
        }
        return false;
    }

    public static class ByReflectionMethod
    extends MethodInjector {
        private final Method injectionMethod;

        public ByReflectionMethod(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, Method injectionMethod, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
            super(componentKey, componentImplementation, parameters, monitor, null, useNames);
            this.injectionMethod = injectionMethod;
        }

        protected Method getInjectorMethod() {
            return this.injectionMethod;
        }

        public String getDescriptor() {
            return "ReflectionMethodInjector[" + this.injectionMethod + "]-";
        }
    }
}

