/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ArrayContainsExactlyMatcher<T>
extends TypeSafeMatcher<T[]> {
    private T[] expectedArray;

    public ArrayContainsExactlyMatcher(T ... expected) {
        this.expectedArray = expected;
    }

    public void describeTo(Description description) {
        description.appendText("A collection containing exactly items " + this.expectedArray.toString());
    }

    public boolean matchesSafely(T[] actualArray) {
        if (actualArray.length != this.expectedArray.length) {
            return false;
        }
        HashSet<T> actualCollection = new HashSet<T>(Arrays.asList(actualArray));
        HashSet<T> expectedCollection = new HashSet<T>(Arrays.asList(actualArray));
        return actualCollection.equals(expectedCollection);
    }

    public static <T> ArrayContainsExactlyMatcher<T> containsExactly(T ... items) {
        return new ArrayContainsExactlyMatcher<T>(items);
    }
}

