/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIsStub;
import ch.systemsx.cisd.openbis.generic.shared.basic.ITaggable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistrationAndModificationDate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Material
extends CodeWithRegistrationAndModificationDate<Material>
implements IEntityInformationHolderWithProperties,
ITaggable,
IIsStub {
    private static final long serialVersionUID = 35L;
    private DatabaseInstance databaseInstance;
    private MaterialType materialType;
    private Long id;
    private Date modificationDate;
    private List<IEntityProperty> properties;
    private Collection<Metaproject> metaprojects;

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(MaterialType experimentType) {
        this.materialType = experimentType;
    }

    @Override
    public List<IEntityProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<IEntityProperty> properties) {
        this.properties = properties;
    }

    public DatabaseInstance getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstance databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    public EntityType getEntityType() {
        return this.getMaterialType();
    }

    @Override
    public EntityKind getEntityKind() {
        return EntityKind.MATERIAL;
    }

    @Override
    public String getIdentifier() {
        return new MaterialIdentifier(this.getCode(), this.getMaterialType().getCode()).print();
    }

    public void setMetaprojects(Collection<Metaproject> metaprojects) {
        this.metaprojects = metaprojects;
    }

    @Override
    public Collection<Metaproject> getMetaprojects() {
        return this.metaprojects;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Material other = (Material)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    @Override
    public final int compareTo(Material o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    @Override
    public String getPermId() {
        return this.getIdentifier();
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public boolean isStub() {
        return false;
    }
}

