/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.util.Assert;

public class CachingMapDecorator
implements Map,
Serializable {
    protected static Object NULL_VALUE = new Object();
    private final Map targetMap;
    private final boolean synchronize;
    private final boolean weak;

    public CachingMapDecorator() {
        this(false);
    }

    public CachingMapDecorator(boolean weak) {
        AbstractMap internalMap = weak ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public CachingMapDecorator(boolean weak, int size) {
        AbstractMap internalMap = weak ? new WeakHashMap(size) : new HashMap(size);
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public CachingMapDecorator(Map targetMap) {
        this(targetMap, false, false);
    }

    public CachingMapDecorator(Map targetMap, boolean synchronize2, boolean weak) {
        Assert.notNull(targetMap, "Target Map is required");
        this.targetMap = synchronize2 ? Collections.synchronizedMap(targetMap) : targetMap;
        this.synchronize = synchronize2;
        this.weak = weak;
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object valueToCheck = value;
        if (valueToCheck == null) {
            valueToCheck = NULL_VALUE;
        }
        if (this.synchronize) {
            Map map = this.targetMap;
            synchronized (map) {
                return this.containsValueOrReference(valueToCheck);
            }
        }
        return this.containsValueOrReference(valueToCheck);
    }

    private boolean containsValueOrReference(Object value) {
        if (this.targetMap.containsValue(value)) {
            return true;
        }
        Iterator it = this.targetMap.values().iterator();
        while (it.hasNext()) {
            Object mapVal = it.next();
            if (!(mapVal instanceof Reference) || !value.equals(((Reference)mapVal).get())) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object key) {
        return this.targetMap.remove(key);
    }

    public void putAll(Map map) {
        this.targetMap.putAll(map);
    }

    public void clear() {
        this.targetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        if (this.synchronize) {
            Map map = this.targetMap;
            synchronized (map) {
                return new LinkedHashSet(this.targetMap.keySet());
            }
        }
        return new LinkedHashSet(this.targetMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        if (this.synchronize) {
            Map map = this.targetMap;
            synchronized (map) {
                return this.valuesCopy();
            }
        }
        return this.valuesCopy();
    }

    private Collection valuesCopy() {
        LinkedList values = new LinkedList();
        Iterator it = this.targetMap.values().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            values.add(value instanceof Reference ? ((Reference)value).get() : value);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.synchronize) {
            Map map = this.targetMap;
            synchronized (map) {
                return new LinkedHashSet(this.targetMap.entrySet());
            }
        }
        return new LinkedHashSet(this.targetMap.entrySet());
    }

    public Object put(Object key, Object value) {
        WeakReference<Object> newValue = value;
        if (newValue == null) {
            newValue = NULL_VALUE;
        }
        if (this.useWeakValue(key, newValue)) {
            newValue = new WeakReference<Object>(newValue);
        }
        return this.targetMap.put(key, newValue);
    }

    protected boolean useWeakValue(Object key, Object value) {
        return this.weak;
    }

    public Object get(Object key) {
        Object value = this.targetMap.get(key);
        if (value instanceof Reference) {
            value = ((Reference)value).get();
        }
        if (value == null && (value = this.create(key)) != null) {
            this.put(key, value);
        }
        return value == NULL_VALUE ? null : value;
    }

    protected Object create(Object key) {
        return null;
    }

    public String toString() {
        return "CachingMapDecorator [" + this.getClass().getName() + "]:" + this.targetMap;
    }
}

