/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import org.springframework.util.ClassUtils;

public class CustomizableThreadCreator {
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    private ThreadGroup threadGroup;
    private int threadCount = 0;
    private final Object threadCountMonitor = new Object();

    public CustomizableThreadCreator() {
        this.threadNamePrefix = this.getDefaultThreadNamePrefix();
    }

    public CustomizableThreadCreator(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix != null ? threadNamePrefix : this.getDefaultThreadNamePrefix();
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix != null ? threadNamePrefix : this.getDefaultThreadNamePrefix();
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setThreadGroupName(String name) {
        this.threadGroup = new ThreadGroup(name);
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Thread createThread(Runnable runnable) {
        Thread thread2 = new Thread(this.getThreadGroup(), runnable, this.nextThreadName());
        thread2.setPriority(this.getThreadPriority());
        thread2.setDaemon(this.isDaemon());
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextThreadName() {
        int threadNumber = 0;
        Object object = this.threadCountMonitor;
        synchronized (object) {
            ++this.threadCount;
            threadNumber = this.threadCount;
        }
        return this.getThreadNamePrefix() + threadNumber;
    }

    protected String getDefaultThreadNamePrefix() {
        return ClassUtils.getShortName(this.getClass()) + "-";
    }
}

