/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1;

import ch.systemsx.cisd.common.api.IRpcService;
import ch.systemsx.cisd.common.api.MinimalMinorVersion;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetImageRepresentationFormats;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentImageMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureVectorDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public interface IScreeningApiServer
extends IRpcService {
    public static final String SERVICE_NAME = "screening";
    public static final int MAJOR_VERSION = 1;
    public static final String SERVICE_URL = "/rmi-screening-api-v1";
    public static final String JSON_SERVICE_URL = "/rmi-screening-api-v1.json";

    @Transactional
    public String tryLoginScreening(String var1, String var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    public void logoutScreening(String var1) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    public List<Plate> listPlates(String var1) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=5)
    public List<Plate> listPlates(String var1, ExperimentIdentifier var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=8)
    public List<PlateMetadata> getPlateMetadataList(String var1, List<? extends PlateIdentifier> var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=1)
    public List<ExperimentIdentifier> listExperiments(String var1);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=6)
    public List<ExperimentIdentifier> listExperiments(String var1, String var2);

    @Transactional(readOnly=true)
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(String var1, List<? extends PlateIdentifier> var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    public List<ImageDatasetReference> listImageDatasets(String var1, List<? extends PlateIdentifier> var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=6)
    public List<ImageDatasetReference> listRawImageDatasets(String var1, List<? extends PlateIdentifier> var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=6)
    public List<ImageDatasetReference> listSegmentationImageDatasets(String var1, List<? extends PlateIdentifier> var2) throws IllegalArgumentException;

    @Transactional(readOnly=true)
    public List<IDatasetIdentifier> getDatasetIdentifiers(String var1, List<String> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=1)
    public List<PlateWellReferenceWithDatasets> listPlateWells(String var1, ExperimentIdentifier var2, MaterialIdentifier var3, boolean var4);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=2)
    public List<PlateWellReferenceWithDatasets> listPlateWells(String var1, MaterialIdentifier var2, boolean var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=3)
    public List<WellIdentifier> listPlateWells(String var1, PlateIdentifier var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=3)
    public Sample getWellSample(String var1, WellIdentifier var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=7)
    public Sample getPlateSample(String var1, PlateIdentifier var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=2)
    public List<PlateWellMaterialMapping> listPlateMaterialMapping(String var1, List<? extends PlateIdentifier> var2, MaterialTypeIdentifier var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=1)
    public ExperimentImageMetadata getExperimentImageMetadata(String var1, ExperimentIdentifier var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> listAvailableFeatureCodes(String var1, List<? extends IFeatureVectorDatasetIdentifier> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<FeatureInformation> listAvailableFeatures(String var1, List<? extends IFeatureVectorDatasetIdentifier> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<FeatureVectorDataset> loadFeatures(String var1, List<FeatureVectorDatasetReference> var2, List<String> var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<FeatureVectorWithDescription> loadFeaturesForDatasetWellReferences(String var1, List<FeatureVectorDatasetWellReference> var2, List<String> var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2, @JsonRpcParam(value="convertToPng") boolean var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadThumbnailImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2, @JsonRpcParam(value="size") ImageSize var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2, @JsonRpcParam(value="configuration") LoadImageConfiguration var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2, @JsonRpcParam(value="format") ImageRepresentationFormat var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadImagesBase64(@JsonRpcParam(value="sessionToken") String var1, @JsonRpcParam(value="imageReferences") List<PlateImageReference> var2, IImageRepresentationFormatSelectionCriterion ... var3);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<ImageDatasetMetadata> listImageMetadata(String var1, List<? extends IImageDatasetIdentifier> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<DatasetImageRepresentationFormats> listAvailableImageRepresentationFormats(String var1, List<? extends IDatasetIdentifier> var2);

    @Transactional(readOnly=true)
    @MinimalMinorVersion(value=10)
    public List<String> loadPhysicalThumbnailsBase64(String var1, List<PlateImageReference> var2, ImageRepresentationFormat var3);
}

