/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonObject(value="FeatureVector")
public class FeatureVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WellPosition wellPosition;
    private double[] values;
    private boolean[] vocabularyFeatureFlags;
    private String[] vocabularyTerms;

    public FeatureVector(WellPosition well, double[] values) {
        this(well, values, new boolean[values.length], new String[values.length]);
    }

    public FeatureVector(WellPosition well, double[] values, boolean[] vocabularyFeatureFlags, String[] vocabularyTerms) {
        this.wellPosition = well;
        this.values = values;
        this.vocabularyFeatureFlags = vocabularyFeatureFlags;
        this.vocabularyTerms = vocabularyTerms;
        if (values.length != vocabularyFeatureFlags.length || values.length != vocabularyTerms.length) {
            throw new IllegalArgumentException("Array lengths different: " + values.length + " " + vocabularyFeatureFlags.length + " " + vocabularyTerms.length);
        }
    }

    public WellPosition getWellPosition() {
        return this.wellPosition;
    }

    public double[] getValues() {
        return this.values;
    }

    public final boolean[] getVocabularyFeatureFlags() {
        return this.vocabularyFeatureFlags;
    }

    public final String[] getVocabularyTerms() {
        return this.vocabularyTerms;
    }

    @JsonIgnore
    public List<Object> getValueObjects() {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.values.length) {
            if (this.vocabularyFeatureFlags[i]) {
                result.add(this.vocabularyTerms[i]);
            } else {
                double number = this.values[i];
                result.add(Double.isNaN(number) ? null : Double.valueOf(number));
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return "wellPosition: " + this.wellPosition + ", values: " + this.getValueObjects();
    }

    private FeatureVector() {
    }

    private void setWellPosition(WellPosition wellPosition) {
        this.wellPosition = wellPosition;
    }

    private void setValues(double[] values) {
        this.values = values;
    }

    private void setVocabularyFeatureFlags(boolean[] vocabularyFeatureFlags) {
        this.vocabularyFeatureFlags = vocabularyFeatureFlags;
    }

    private void setVocabularyTerms(String[] vocabularyTerms) {
        this.vocabularyTerms = vocabularyTerms;
    }
}

