/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;

@JsonObject(value="MicroscopyImageReference")
public class MicroscopyImageReference
extends DatasetIdentifier {
    private static final long serialVersionUID = 1L;
    private int tile;
    private String channel;

    public MicroscopyImageReference(int tile, String channel, IDatasetIdentifier dataset) {
        super(dataset.getDatasetCode(), dataset.getDatastoreServerUrl());
        this.tile = tile;
        this.channel = channel.toUpperCase();
    }

    public int getTile() {
        return this.tile;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toString() {
        return "Image for [dataset " + this.getDatasetCode() + ", channel " + this.channel + ", tile " + this.tile + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + this.channel.hashCode();
        result = 31 * result + this.tile;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MicroscopyImageReference other = (MicroscopyImageReference)obj;
        if (!this.channel.equals(other.channel)) {
            return false;
        }
        return this.tile == other.tile;
    }

    private MicroscopyImageReference() {
        super(null, null);
    }

    private void setTile(int tile) {
        this.tile = tile;
    }

    private void setChannel(String channel) {
        this.channel = channel;
    }
}

