/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.util.JsonPropertyUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="FileInfoDssDTO")
public class FileInfoDssDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String pathInDataSet;
    private String pathInListing;
    private boolean isDirectory;
    private long fileSize;
    private Integer crc32Checksum;

    public FileInfoDssDTO(String pathInDataSet, String pathInListing, boolean isDirectory, long fileSize) {
        this(pathInDataSet, pathInListing, isDirectory, fileSize, null);
    }

    public FileInfoDssDTO(String pathInDataSet, String pathInListing, boolean isDirectory, long fileSize, Integer crc32Checksum) {
        this.pathInDataSet = pathInDataSet;
        this.pathInListing = pathInListing;
        this.isDirectory = isDirectory;
        this.fileSize = fileSize;
        this.crc32Checksum = crc32Checksum;
    }

    public String getPathInDataSet() {
        return this.pathInDataSet;
    }

    public String getPathInListing() {
        return this.pathInListing;
    }

    @JsonProperty(value="isDirectory")
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @JsonIgnore
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty(value="crc32Checksum")
    public Integer tryGetCrc32Checksum() {
        return this.crc32Checksum;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        sb.append((Object)this.getPathInDataSet());
        sb.append((Object)this.getPathInListing());
        sb.append(this.getFileSize());
        if (this.tryGetCrc32Checksum() != null) {
            sb.append((Object)IOUtilities.crc32ToString((int)this.tryGetCrc32Checksum()));
        }
        return sb.toString();
    }

    private FileInfoDssDTO() {
    }

    private void setPathInDataSet(String pathInDataSet) {
        this.pathInDataSet = pathInDataSet;
    }

    private void setPathInListing(String pathInListing) {
        this.pathInListing = pathInListing;
    }

    @JsonProperty(value="isDirectory")
    private void setIsDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    @JsonIgnore
    private void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @JsonProperty(value="fileSize")
    private String getFileSizeAsString() {
        return JsonPropertyUtil.toStringOrNull(this.fileSize);
    }

    private void setFileSizeAsString(String fileSize) {
        this.fileSize = JsonPropertyUtil.toLongOrNull(fileSize);
    }

    private void setCrc32Checksum(int crc32Checksum) {
        this.crc32Checksum = crc32Checksum;
    }
}

