/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.parser.BeanProperty;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertiesBean;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Identifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.List;

public class NewSample
extends Identifier<NewSample>
implements Comparable<NewSample>,
IPropertiesBean {
    private static final long serialVersionUID = 35L;
    public static final String SAMPLE_REGISTRATION_TEMPLATE_COMMENT = "# The \"container\" and \"parents\" columns are optional, only one should be specified.\n# \"container\" should contain a sample identifier, e.g. /SPACE/SAMPLE_1, while \"parents\" should contain comma separated list of sample identifiers. \n# If \"container\" sample is provided, the registered sample will become a \"component\" of it.\n# The column \"container\" has an alias \"current_container\", which has a different meaning when samples are updated.\n# If \"parents\" are provided, the registered sample will become a \"child\" of all specified samples.\n";
    public static String WITH_EXPERIMENTS_COMMENT = "# The \"experiment\" column is optional, cannot be specified for shared samples and should contain experiment identifier, e.g. /SPACE/PROJECT/EXP_1\n";
    public static String WITH_SPACE_COMMENT = "# The \"default_space\" column is optional, it can be used to override home space for the row\n";
    public static final String CONTAINER = "container";
    public static final String CURRENT_CONTAINER = "current_container";
    public static final String PARENT = "parent";
    public static final String PARENTS = "parents";
    public static final String EXPERIMENT = "experiment";
    public static final String SPACE = "default_space";
    private SampleType sampleType;
    private String[] parentsOrNull;
    private String containerIdentifier;
    private String currentContainerIdentifier;
    private String experimentIdentifier;
    private String defaultSpaceIdentifier;
    private IEntityProperty[] properties = IEntityProperty.EMPTY_ARRAY;
    private List<NewAttachment> attachments;
    private String[] metaprojectsOrNull;

    public NewSample() {
    }

    private NewSample(String identifier, SampleType sampleType, String containerIdentifier) {
        this.setIdentifier(identifier);
        this.setSampleType(sampleType);
        this.setContainerIdentifier(containerIdentifier);
    }

    public static NewSample createWithParent(String identifier, SampleType sampleType, String containerIdentifier, String parentIdentifier) {
        NewSample result = new NewSample(identifier, sampleType, containerIdentifier);
        result.setParentIdentifier(parentIdentifier);
        return result;
    }

    public static NewSample createWithParents(String identifier, SampleType sampleType, String containerIdentifier, String[] parents) {
        NewSample result = new NewSample(identifier, sampleType, containerIdentifier);
        result.setParentsOrNull(parents);
        return result;
    }

    public NewSample(String identifier, SampleType sampleType, String containerIdentifier, String[] parentsOrNull, String experimentIdentifier, String defaultSpaceIdentifier, String currentContainerIdentifier, IEntityProperty[] properties, List<NewAttachment> attachments) {
        this(identifier, sampleType, containerIdentifier);
        this.parentsOrNull = parentsOrNull;
        this.setExperimentIdentifier(experimentIdentifier);
        this.setDefaultSpaceIdentifier(defaultSpaceIdentifier);
        this.setCurrentContainerIdentifier(currentContainerIdentifier);
        this.properties = properties;
        this.attachments = attachments;
    }

    public List<NewAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<NewAttachment> attachments) {
        this.attachments = attachments;
    }

    public final SampleType getSampleType() {
        return this.sampleType;
    }

    public final void setSampleType(SampleType sampleType) {
        this.sampleType = sampleType;
    }

    public String[] getParentsOrNull() {
        return this.parentsOrNull;
    }

    public void setParentsOrNull(String[] parents) {
        this.parentsOrNull = parents;
    }

    @BeanProperty(label="parents", optional=true)
    public void setParents(String parents) {
        if (parents != null) {
            String[] split = parents.split(",");
            this.setParentsOrNull(split);
        } else {
            this.setParentsOrNull(new String[0]);
        }
    }

    @Deprecated
    public final String getParentIdentifier() {
        if (this.getParentsOrNull() == null || this.getParentsOrNull().length == 0) {
            return null;
        }
        if (this.getParentsOrNull().length > 1) {
            throw new IllegalStateException("Sample " + this.getIdentifier() + " has more than one parent");
        }
        return this.getParentsOrNull()[0];
    }

    @Deprecated
    @BeanProperty(label="parent", optional=true)
    public final void setParentIdentifier(String parent) {
        this.setParents(parent);
    }

    public final String getContainerIdentifier() {
        return this.containerIdentifier;
    }

    @BeanProperty(label="container", optional=true)
    public final void setContainerIdentifier(String container) {
        this.containerIdentifier = NewSample.toUpperCase(StringUtils.trimToNull((String)container));
    }

    public final String getCurrentContainerIdentifier() {
        return this.currentContainerIdentifier;
    }

    @BeanProperty(label="current_container", optional=true)
    public final void setCurrentContainerIdentifier(String currentContainerIdentifier) {
        this.currentContainerIdentifier = NewSample.toUpperCase(StringUtils.trimToNull((String)currentContainerIdentifier));
    }

    public String getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    @BeanProperty(label="experiment", optional=true)
    public void setExperimentIdentifier(String experimentIdentifier) {
        this.experimentIdentifier = NewSample.toUpperCase(experimentIdentifier);
    }

    public String getDefaultSpaceIdentifier() {
        return this.defaultSpaceIdentifier;
    }

    @BeanProperty(label="default_space", optional=true)
    public void setDefaultSpaceIdentifier(String defaultSpaceIdentifier) {
        this.defaultSpaceIdentifier = StringUtils.isBlank((String)defaultSpaceIdentifier) || defaultSpaceIdentifier.contains("/") ? NewSample.toUpperCase(defaultSpaceIdentifier) : "/" + NewSample.toUpperCase(defaultSpaceIdentifier);
    }

    @Override
    public final IEntityProperty[] getProperties() {
        return this.properties;
    }

    @Override
    public final void setProperties(IEntityProperty[] properties) {
        this.properties = properties;
    }

    public String[] getMetaprojectsOrNull() {
        return this.metaprojectsOrNull;
    }

    public void setMetaprojectsOrNull(String[] metaprojectsOrNull) {
        this.metaprojectsOrNull = metaprojectsOrNull;
    }

    public final String toString() {
        return this.getIdentifier();
    }

    public String getContainerIdentifierForNewSample() {
        return this.currentContainerIdentifier != null ? this.currentContainerIdentifier : this.containerIdentifier;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NewSample)) {
            return false;
        }
        NewSample that = (NewSample)obj;
        String thisCombinedIdentifier = String.valueOf(StringUtils.emptyIfNull((String)this.getDefaultSpaceIdentifier())) + this.getIdentifier() + this.getContainerIdentifier() + this.getCurrentContainerIdentifier();
        String thatCombinedIdentifier = String.valueOf(StringUtils.emptyIfNull((String)this.getDefaultSpaceIdentifier())) + that.getIdentifier() + that.getContainerIdentifier() + that.getCurrentContainerIdentifier();
        return thisCombinedIdentifier.equals(thatCombinedIdentifier);
    }
}

