/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.model;

import java.io.File;

public class ValidatedFile {
    private File file;
    private long lastValidated;
    private boolean fileExisted = true;

    public ValidatedFile(File file) {
        this.file = file;
        this.lastValidated = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public boolean validationRequired() {
        if (this.fileExisted) {
            return !this.file.exists() || this.lastValidated < this.file.lastModified();
        }
        return this.file.exists();
    }

    public void markValidation() {
        this.fileExisted = this.file.exists();
        this.lastValidated = this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof ValidatedFile) {
            return this.file.equals(((ValidatedFile)o).getFile());
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

