/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractDataSetInfoExtractor
implements IDataSetInfoExtractor {
    @Private
    static final String ENTITY_SEPARATOR_PROPERTY_NAME = "entity-separator";
    protected static final char DEFAULT_ENTITY_SEPARATOR = '.';
    @Private
    static final String STRIP_EXTENSION = "strip-file-extension";
    @Private
    static final String GROUP_CODE = "space-code";
    protected final Properties properties;
    protected final char entitySeparator;
    protected final boolean stripExtension;

    protected AbstractDataSetInfoExtractor(Properties properties) {
        assert (properties != null) : "Properties can not be null.";
        this.properties = properties;
        this.stripExtension = PropertyUtils.getBoolean(properties, STRIP_EXTENSION, false);
        this.entitySeparator = PropertyUtils.getChar(properties, ENTITY_SEPARATOR_PROPERTY_NAME, '.');
        if (Character.isWhitespace(this.entitySeparator)) {
            throw new ConfigurationFailureException("Entity separator is a whitespace character.");
        }
    }

    protected String getGroupCode() {
        return this.properties.getProperty(GROUP_CODE);
    }

    public static List<NewProperty> extractDataSetProperties(File incomingDataSetPath, String fileNameOrNull) {
        ArrayList<NewProperty> result = new ArrayList<NewProperty>();
        if (fileNameOrNull != null && incomingDataSetPath.isDirectory()) {
            File propertiesFile = new File(incomingDataSetPath, fileNameOrNull);
            if (!propertiesFile.exists()) {
                return result;
            }
            if (propertiesFile.isFile()) {
                TabFileLoader<NewProperty> tabFileLoader = new TabFileLoader<NewProperty>(NewProperty.class);
                Map<String, String> defauts = Collections.emptyMap();
                result.addAll(tabFileLoader.load(propertiesFile, defauts));
            } else {
                throw new UserFailureException("Data set properties file '" + propertiesFile + "' does not exist or is not a 'normal' file.");
            }
        }
        return result;
    }
}

