/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.plugins.BaseGroupingPolicy;
import ch.systemsx.cisd.etlserver.plugins.grouping.DatasetListWithTotal;
import ch.systemsx.cisd.etlserver.plugins.grouping.Grouping;
import ch.systemsx.cisd.etlserver.plugins.grouping.IGroupKeyProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class GroupingPolicy
extends BaseGroupingPolicy {
    static final String GROUPING_KEYS_KEY = "grouping-keys";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, GroupingPolicy.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, GroupingPolicy.class);
    private final List<CombinedGroupKeys> groupKeyProviders = new ArrayList<CombinedGroupKeys>();

    public GroupingPolicy(Properties properties) {
        super(properties);
        List<String> groupingKeys = PropertyUtils.getList(properties, GROUPING_KEYS_KEY);
        for (String groupingKey : groupingKeys) {
            String[] splitted = groupingKey.split(":", 2);
            boolean merge = false;
            if (splitted.length > 1) {
                if (!"merge".equals(splitted[1])) {
                    throw new ConfigurationFailureException("Invalid grouping key in property 'grouping-keys' because 'merge' is expected after ':': " + groupingKey);
                }
                merge = true;
            }
            String[] keyItems = splitted[0].split("#");
            ArrayList<IGroupKeyProvider> groupings = new ArrayList<IGroupKeyProvider>();
            String[] stringArray = keyItems;
            int n = keyItems.length;
            int n2 = 0;
            while (n2 < n) {
                String keyItem = stringArray[n2];
                try {
                    groupings.add(Grouping.valueOf(keyItem));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ConfigurationFailureException("Invalid basic grouping key in property 'grouping-keys': " + keyItem + " (valid values are " + Arrays.asList(Grouping.values()) + ")");
                }
                ++n2;
            }
            this.groupKeyProviders.add(new CombinedGroupKeys(groupings, merge));
        }
    }

    @Override
    protected List<AbstractExternalData> filterDataSetsWithSizes(List<AbstractExternalData> dataSets) {
        ArrayList<String> log = new ArrayList<String>();
        this.log(log, "Search for a group of data sets with total size between " + FileUtils.byteCountToDisplaySize((long)this.minArchiveSize) + " and " + FileUtils.byteCountToDisplaySize((long)this.maxArchiveSize) + ". Data sets: " + CollectionUtils.abbreviate(Code.extractCodes(dataSets), 50));
        for (CombinedGroupKeys combinedGroupKeys : this.groupKeyProviders) {
            List<AbstractExternalData> result;
            List<DatasetListWithTotal> groups = this.splitIntoGroups(dataSets, combinedGroupKeys);
            this.log(log, combinedGroupKeys + " has grouped " + dataSets.size() + " data sets into " + groups.size() + " groups.");
            if (groups.isEmpty() || (result = this.tryFindGroupOrMerge(groups, combinedGroupKeys.isMerge(), log)) == null) continue;
            this.log(log, "filtered data sets: " + CollectionUtils.abbreviate(Code.extractCodes(result), 20));
            return result;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("From " + dataSets.size() + " data sets no group could be found to be fit between ");
        builder.append(FileUtils.byteCountToDisplaySize((long)this.minArchiveSize)).append(" and ");
        builder.append(FileUtils.byteCountToDisplaySize((long)this.maxArchiveSize));
        builder.append("\n\nLog:");
        for (String logMessage : log) {
            builder.append('\n').append(logMessage);
        }
        notificationLog.warn(builder.toString());
        return new ArrayList<AbstractExternalData>();
    }

    private List<AbstractExternalData> tryFindGroupOrMerge(List<DatasetListWithTotal> groups, boolean merge, List<String> log) {
        ArrayList<DatasetListWithTotal> tooSmallGroups = new ArrayList<DatasetListWithTotal>();
        ArrayList<DatasetListWithTotal> fittingGroups = new ArrayList<DatasetListWithTotal>();
        for (DatasetListWithTotal group : groups) {
            long size = group.getCumulatedSize();
            if (size < this.minArchiveSize) {
                tooSmallGroups.add(group);
                continue;
            }
            if (size > this.maxArchiveSize) continue;
            fittingGroups.add(group);
        }
        this.log(log, String.valueOf(fittingGroups.size()) + " groups match in size, " + tooSmallGroups.size() + " groups are too small and " + (groups.size() - fittingGroups.size() - tooSmallGroups.size()) + " groups are too large.");
        if (!fittingGroups.isEmpty()) {
            return this.getOldestGroup(fittingGroups, log);
        }
        if (tooSmallGroups.size() < 2 || !merge) {
            return null;
        }
        return this.tryMerge(tooSmallGroups, log);
    }

    private List<AbstractExternalData> getOldestGroup(List<DatasetListWithTotal> groups, List<String> log) {
        if (groups.size() == 1) {
            return groups.get(0).getList();
        }
        GroupWithAge oldestGroup = this.sortGroupsByAge(groups).get(0);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(oldestGroup.age));
        this.log(log, "All data sets of the selected group have been accessed at " + timestamp + " or before.");
        return oldestGroup.group.getList();
    }

    private List<GroupWithAge> sortGroupsByAge(List<DatasetListWithTotal> groups) {
        ArrayList<GroupWithAge> groupsWithAge = new ArrayList<GroupWithAge>();
        for (DatasetListWithTotal group : groups) {
            groupsWithAge.add(new GroupWithAge(group));
        }
        Collections.sort(groupsWithAge);
        return groupsWithAge;
    }

    private List<AbstractExternalData> tryMerge(List<DatasetListWithTotal> groups, List<String> log) {
        List<GroupWithAge> groupsWithAge = this.sortGroupsByAge(groups);
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>();
        long total = 0L;
        int i = 0;
        while (i < groupsWithAge.size()) {
            DatasetListWithTotal group = groupsWithAge.get(i).group;
            result.addAll(group.getList());
            if ((total += group.getCumulatedSize()) >= this.minArchiveSize) {
                if (total <= this.maxArchiveSize) {
                    this.log(log, String.valueOf(i + 1) + " groups have been merged.");
                    return result;
                }
                this.log(log, String.valueOf(i + 1) + " groups have been merged, but the total size of " + FileUtils.byteCountToDisplaySize((long)total) + " is above the required maximum of " + FileUtils.byteCountToDisplaySize((long)this.maxArchiveSize));
                return null;
            }
            ++i;
        }
        this.log(log, "Merging all " + groups.size() + " groups gives a total size of " + FileUtils.byteCountToDisplaySize((long)total) + " which is still below required minimum of " + FileUtils.byteCountToDisplaySize((long)this.minArchiveSize));
        return null;
    }

    private List<DatasetListWithTotal> splitIntoGroups(List<AbstractExternalData> dataSets, IGroupKeyProvider groupKeyProvider) {
        ArrayList<DatasetListWithTotal> groups = new ArrayList<DatasetListWithTotal>(this.splitDataSetsInGroupsAccordingToCriteria(dataSets, groupKeyProvider));
        Collections.sort(groups);
        return groups;
    }

    private void log(List<String> log, Object logMessage) {
        log.add(logMessage.toString());
        operationLog.info(logMessage.toString());
    }

    private static final class CombinedGroupKeys
    implements IGroupKeyProvider {
        private final List<IGroupKeyProvider> groupKeyProviders;
        private final boolean merge;

        CombinedGroupKeys(List<IGroupKeyProvider> groupKeyProviders, boolean merge) {
            this.groupKeyProviders = groupKeyProviders;
            this.merge = merge;
        }

        public boolean isMerge() {
            return this.merge;
        }

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            StringBuilder builder = new StringBuilder();
            for (IGroupKeyProvider groupKeyProvider : this.groupKeyProviders) {
                if (builder.length() > 0) {
                    builder.append('#');
                }
                builder.append(groupKeyProvider.getGroupKey(dataset));
            }
            return builder.toString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (IGroupKeyProvider keyProvider : this.groupKeyProviders) {
                if (builder.length() > 0) {
                    builder.append('#');
                }
                builder.append(keyProvider);
            }
            if (this.merge) {
                builder.append(":merge");
            }
            return "Grouping key: '" + builder.toString() + "'";
        }
    }

    private static class GroupWithAge
    implements Comparable<GroupWithAge> {
        private long age;
        private DatasetListWithTotal group;

        GroupWithAge(DatasetListWithTotal group) {
            this.group = group;
            List<AbstractExternalData> dataSets = group.getList();
            for (AbstractExternalData dataSet : dataSets) {
                this.age = Math.max(this.age, dataSet.getAccessTimestamp().getTime());
            }
        }

        @Override
        public int compareTo(GroupWithAge that) {
            return Long.signum(this.age - that.age);
        }
    }
}

