/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins.grouping;

import ch.systemsx.cisd.etlserver.plugins.grouping.IGroupKeyProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;

public enum Grouping implements IGroupKeyProvider
{
    All{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return "all";
        }
    }
    ,
    Space{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return dataset.getExperiment().getProject().getSpace().getCode();
        }
    }
    ,
    Project{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return dataset.getExperiment().getProject().getIdentifier();
        }
    }
    ,
    Experiment{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return dataset.getExperiment().getIdentifier();
        }
    }
    ,
    Sample{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            Sample sample = dataset.getSample();
            return sample != null ? sample.getIdentifier() : "no_sample";
        }
    }
    ,
    DataSet{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return dataset.getCode();
        }
    }
    ,
    DataSetType{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return dataset.getDataSetType().getCode();
        }
    }
    ,
    ExperimentAndDataSetType{

        @Override
        public String getGroupKey(AbstractExternalData dataset) {
            return String.valueOf(dataset.getExperiment().getIdentifier()) + "#" + dataset.getDataSetType().getCode();
        }
    };


    private Grouping() {
    }

    /* synthetic */ Grouping(String string, int n, Grouping grouping) {
        this();
    }
}

