/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.IWaitingCondition;
import ch.systemsx.cisd.common.utilities.WaitingHelper;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.FilteredHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.AbstractDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestination;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestinationFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class MultiDataSetFileOperationsManager
extends AbstractDataSetFileOperationsManager
implements IMultiDataSetFileOperationsManager,
Serializable {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MultiDataSetFileOperationsManager.class);
    private static final long serialVersionUID = 1L;
    public static final String STAGING_DESTINATION_KEY = "staging-destination";
    public static final String FINAL_DESTINATION_KEY = "final-destination";
    public static final String REPLICATED_DESTINATION_KEY = "replicated-destination";
    public static final String WITH_SHARDING_KEY = "with-sharding";
    public static final String WAITING_FOR_FREE_SPACE_POLLING_TIME_KEY = "waiting-for-free-space-polling-time";
    public static final String WAITING_FOR_FREE_SPACE_TIME_OUT_KEY = "waiting-for-free-space-time-out";
    public static final String MINIMUM_FREE_SPACE_IN_MB_KEY = "minimum-free-space-in-MB";
    public static final String HDF5_FILES_IN_DATA_SET = "hdf5-files-in-data-set";
    private static final long DEFAULT_WAITING_FOR_FREE_SPACE_POLLING_TIME = 60000L;
    private static final long DEFAULT_WAITING_FOR_FREE_SPACE_TIME_OUT = 14400000L;
    private static final long DEFAULT_MINIMUM_FREE_SPACE_IN_MB = 1024L;
    private transient ArchiveDestination stageArchive;
    private transient ArchiveDestination finalArchive;
    private transient ArchiveDestination finalReplicatedArchive;
    private final ArchiveDestinationFactory stageArchivefactory;
    private final ArchiveDestinationFactory finalArchivefactory;
    private final ArchiveDestinationFactory finalReplicatedArchivefactory;
    private final boolean withSharding;
    private final ITimeAndWaitingProvider timeProvider;
    private final IFreeSpaceProvider freeSpaceProviderOrNull;
    protected IMultiDataSetPackageManager packageManager;
    private long waitingForFreeSpacePollingTime;
    private long waitingForFreeSpaceTimeOut;
    private long minimumFreeSpace;
    private boolean hdf5FilesInDataSet;
    private static final IHierarchicalContentNodeFilter METADATA_IN_CONTAINER_FILTER = new IHierarchicalContentNodeFilter(){

        @Override
        public boolean accept(IHierarchicalContentNode node) {
            return !"meta-data.tsv".equals(node.getName());
        }
    };

    public MultiDataSetFileOperationsManager(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory, IFreeSpaceProvider freeSpaceProviderOrNull, ITimeAndWaitingProvider timeProvider) {
        this.freeSpaceProviderOrNull = freeSpaceProviderOrNull;
        this.timeProvider = timeProvider;
        this.packageManager = new MultiDataSetPackageManager(properties, new Log4jSimpleLogger(operationLog));
        this.withSharding = PropertyUtils.getBoolean(properties, WITH_SHARDING_KEY, false);
        this.hdf5FilesInDataSet = PropertyUtils.getBoolean(properties, HDF5_FILES_IN_DATA_SET, true);
        long timeoutInSeconds = PropertyUtils.getLong(properties, "timeout", 15L);
        long timeoutInMillis = timeoutInSeconds * 1000L;
        this.finalArchivefactory = this.createArchiveFactory(FINAL_DESTINATION_KEY, "final destination", properties, pathCopierFactory, sshCommandExecutorFactory, timeoutInMillis);
        this.stageArchivefactory = StringUtils.isNotBlank((String)properties.getProperty(STAGING_DESTINATION_KEY)) ? this.createArchiveFactory(STAGING_DESTINATION_KEY, "stage area", properties, pathCopierFactory, sshCommandExecutorFactory, timeoutInMillis) : this.finalArchivefactory;
        this.finalReplicatedArchivefactory = StringUtils.isNotBlank((String)properties.getProperty(REPLICATED_DESTINATION_KEY)) ? this.createArchiveFactory(REPLICATED_DESTINATION_KEY, "final cloned destination", properties, pathCopierFactory, sshCommandExecutorFactory, timeoutInMillis) : this.finalArchivefactory;
        this.waitingForFreeSpacePollingTime = DateTimeUtils.getDurationInMillis(properties, WAITING_FOR_FREE_SPACE_POLLING_TIME_KEY, 60000L);
        this.waitingForFreeSpaceTimeOut = DateTimeUtils.getDurationInMillis(properties, WAITING_FOR_FREE_SPACE_TIME_OUT_KEY, 14400000L);
        this.minimumFreeSpace = PropertyUtils.getLong(properties, MINIMUM_FREE_SPACE_IN_MB_KEY, 1024L) * 0x100000L;
    }

    private ArchiveDestinationFactory createArchiveFactory(String key, String name, Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory, long timeoutInMillis) {
        String finalHostFile = PropertyUtils.getMandatoryProperty(properties, key);
        if (!new File(finalHostFile).isDirectory()) {
            throw new ConfigurationFailureException("Archiving " + name + " '" + finalHostFile + "' is not an existing directory");
        }
        return new ArchiveDestinationFactory(properties, pathCopierFactory, sshCommandExecutorFactory, finalHostFile, timeoutInMillis);
    }

    private ArchiveDestination getStageArchive() {
        if (this.stageArchive == null) {
            this.stageArchive = this.stageArchivefactory.createArchiveDestination();
        }
        return this.stageArchive;
    }

    private ArchiveDestination getFinalArchive() {
        if (this.finalArchive == null) {
            this.finalArchive = this.finalArchivefactory.createArchiveDestination();
        }
        return this.finalArchive;
    }

    private ArchiveDestination getFinalReplicatedArchive() {
        if (this.finalReplicatedArchive == null) {
            this.finalReplicatedArchive = this.finalReplicatedArchivefactory.createArchiveDestination();
        }
        return this.finalReplicatedArchive;
    }

    @Override
    public Status deleteContainerFromStage(IMultiDataSetArchiveCleaner cleaner, String containerPath) {
        if (!this.isStagingAreaDefined()) {
            return Status.OK;
        }
        File stageArchiveContainerFile = new File(this.getStageArchive().getDestination(), containerPath);
        if (!stageArchiveContainerFile.isFile()) {
            operationLog.warn("Archive container '" + containerPath + "' doesn't exist.");
            return Status.OK;
        }
        cleaner.delete(stageArchiveContainerFile);
        return Status.OK;
    }

    @Override
    public Status restoreDataSetsFromContainerInFinalDestination(String containerPath, List<? extends IDatasetLocation> dataSetLocations) {
        HashMap<String, File> dataSetToLocation = new HashMap<String, File>();
        for (IDatasetLocation iDatasetLocation : dataSetLocations) {
            File location = this.getDirectoryProvider().getDataSetDirectory(iDatasetLocation);
            dataSetToLocation.put(iDatasetLocation.getDataSetCode(), location);
        }
        File file = new File(this.getFinalArchive().getDestination(), containerPath);
        this.packageManager.extractMultiDataSets(file, dataSetToLocation);
        return Status.OK;
    }

    @Override
    public Status createContainer(String containerPath, List<DatasetDescription> datasetDescriptions) {
        Status status;
        long totalSize = SegmentedStoreUtils.calculateTotalSize(datasetDescriptions);
        if (this.isStagingAreaDefined()) {
            status = this.createContainerFile(containerPath, datasetDescriptions);
            if (status.isError()) {
                return status;
            }
            this.waitUntilEnoughFreeSpace(totalSize);
            status = this.copyToFinalDestination(containerPath);
        } else {
            this.waitUntilEnoughFreeSpace(totalSize);
            status = this.createContainerFile(containerPath, datasetDescriptions);
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private Status createContainerFile(String containerPath, List<DatasetDescription> datasetDescriptions) {
        block19: {
            block18: {
                containerFile = new File(this.getStageArchive().getDestination(), containerPath);
                shareIdManager = this.getDirectoryProvider().getShareIdManager();
                status = Status.OK;
                try {
                    try {
                        dataSets = new LinkedList<AbstractExternalData>();
                        for (DatasetDescription datasetDescription : datasetDescriptions) {
                            dataSet = this.getDataSetWithAllMetaData(datasetDescription);
                            dataSets.add(dataSet);
                            shareIdManager.lock(dataSet.getCode());
                            MultiDataSetFileOperationsManager.operationLog.info("Archive dataset " + dataSet.getCode() + " in " + containerFile);
                        }
                        result = this.createFolderIfNotExists(this.stageArchive, containerFile.getParentFile());
                        if (result) {
                            MultiDataSetFileOperationsManager.operationLog.warn("File already exists in archive " + containerFile.getParentFile());
                        }
                        this.packageManager.create(containerFile, dataSets);
                        break block18;
                    }
                    catch (Exception ex) {
                        status = Status.createError(ex.toString());
                        MultiDataSetFileOperationsManager.operationLog.error("Couldn't create package file: " + containerPath, ex);
                        try {
                            if (Status.OK.equals(status) && (errors = this.packageManager.verify(containerFile)).size() > 0) {
                                status = Status.createError(errors.toString());
                                throw new RuntimeException(errors.toString());
                            }
                            MultiDataSetFileOperationsManager.operationLog.info("Data sets archived: " + containerPath);
                        }
                        catch (Exception ex) {
                            MultiDataSetFileOperationsManager.operationLog.error("Couldn't create package file: " + containerPath, ex);
                        }
                        ** for (datasetDescription : datasetDescriptions)
                    }
                }
                catch (Throwable var10_21) {
                    try {
                        if (Status.OK.equals(status) && (errors = this.packageManager.verify(containerFile)).size() > 0) {
                            status = Status.createError(errors.toString());
                            throw new RuntimeException(errors.toString());
                        }
                        MultiDataSetFileOperationsManager.operationLog.info("Data sets archived: " + containerPath);
                    }
                    catch (Exception ex) {
                        MultiDataSetFileOperationsManager.operationLog.error("Couldn't create package file: " + containerPath, ex);
                    }
                    ** for (datasetDescription : datasetDescriptions)
                }
lbl-1000:
                // 1 sources

                {
                    shareIdManager.releaseLock(datasetDescription.getDataSetCode());
                    continue;
lbl33:
                    // 1 sources

                    break block19;
                }
lbl-1000:
                // 1 sources

                {
                    shareIdManager.releaseLock(datasetDescription.getDataSetCode());
                    continue;
                }
lbl46:
                // 1 sources

                throw var10_21;
            }
            try {
                if (Status.OK.equals(status) && (errors = this.packageManager.verify(containerFile)).size() > 0) {
                    status = Status.createError(errors.toString());
                    throw new RuntimeException(errors.toString());
                }
                MultiDataSetFileOperationsManager.operationLog.info("Data sets archived: " + containerPath);
            }
            catch (Exception ex) {
                MultiDataSetFileOperationsManager.operationLog.error("Couldn't create package file: " + containerPath, ex);
            }
            for (DatasetDescription datasetDescription : datasetDescriptions) {
                shareIdManager.releaseLock(datasetDescription.getDataSetCode());
            }
        }
        return status;
    }

    @Override
    public String generateContainerPath(List<DatasetDescription> dataSets) {
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        String name = this.packageManager.getName(String.valueOf(dataSets.get(0).getDataSetCode()) + "-" + timestamp);
        if (this.withSharding) {
            return String.valueOf(dataSets.get(0).getDataSetLocation()) + "/" + name;
        }
        return name;
    }

    @Override
    public boolean isStagingAreaDefined() {
        return this.finalArchivefactory != this.stageArchivefactory;
    }

    @Override
    public boolean isReplicatedArchiveDefined() {
        return this.finalArchivefactory != this.finalReplicatedArchivefactory;
    }

    @Override
    public String getOriginalArchiveFilePath(String containerPath) {
        return this.getFilePath(this.getFinalArchive(), containerPath);
    }

    @Override
    public String getReplicatedArchiveFilePath(String containerPath) {
        return this.getFilePath(this.getFinalReplicatedArchive(), containerPath);
    }

    private String getFilePath(ArchiveDestination archive, String containerPath) {
        return new File(archive.getDestination(), containerPath).getAbsolutePath();
    }

    private void waitUntilEnoughFreeSpace(final long totalSize) {
        ArchiveDestination finalDestination = this.getFinalArchive();
        final IDataSetFileOperationsExecutor operationsExecutor = finalDestination.getExecutor();
        final String destinationPath = new File(finalDestination.getDestination()).getAbsolutePath();
        Log4jSimpleLogger logger = new Log4jSimpleLogger(operationLog);
        WaitingHelper waitingHelper = new WaitingHelper(this.waitingForFreeSpaceTimeOut, this.waitingForFreeSpacePollingTime, this.timeProvider, logger, true);
        boolean conditionFulfilled = waitingHelper.waitOn(new IWaitingCondition(){
            private long freeSpace;

            @Override
            public boolean conditionFulfilled() {
                this.freeSpace = MultiDataSetFileOperationsManager.this.getFreeSpace(operationsExecutor, destinationPath);
                return totalSize + MultiDataSetFileOperationsManager.this.minimumFreeSpace < this.freeSpace;
            }

            public String toString() {
                return "Free space: " + FileUtilities.byteCountToDisplaySize(this.freeSpace) + ", needed space: " + FileUtilities.byteCountToDisplaySize(totalSize + MultiDataSetFileOperationsManager.this.minimumFreeSpace);
            }
        });
        if (!conditionFulfilled) {
            long freeSpace = this.getFreeSpace(operationsExecutor, destinationPath);
            throw new EnvironmentFailureException("Still no free space on '" + destinationPath + "' after " + DateTimeUtils.renderDuration(this.waitingForFreeSpaceTimeOut) + ". " + FileUtils.byteCountToDisplaySize((long)totalSize) + " needed but only " + FileUtilities.byteCountToDisplaySize(freeSpace) + " available.");
        }
    }

    private long getFreeSpace(IDataSetFileOperationsExecutor operationsExecutor, String destinationPath) {
        if (this.freeSpaceProviderOrNull != null) {
            HostAwareFile hostAwareFile = new HostAwareFile(null, destinationPath, null);
            try {
                return this.freeSpaceProviderOrNull.freeSpaceKb(hostAwareFile) * 1024L;
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        return operationsExecutor.freeSpaceKb(destinationPath) * 1024L;
    }

    private Status copyToFinalDestination(String containerLocalPath) {
        ArchiveDestination stageDestination = this.getStageArchive();
        File containerFile = new File(stageDestination.getDestination(), containerLocalPath);
        ArchiveDestination finalDestination = this.getFinalArchive();
        try {
            File destinationFolder = new File(finalDestination.getDestination(), containerLocalPath);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            IDataSetFileOperationsExecutor operationsExecutor = finalDestination.getExecutor();
            File parentFolder = destinationFolder.getParentFile();
            if (this.createFolderIfNotExists(finalDestination, parentFolder) || !this.destinationExists(finalDestination, destinationFolder).isSuccess()) {
                operationLog.info("Copy archive container from '" + containerFile + "' to '" + parentFolder);
                operationsExecutor.copyDataSetToDestination(containerFile, parentFolder);
                operationLog.info("Copying archive container took " + stopWatch);
            } else {
                operationLog.info("Update archive container from '" + containerFile + "' to '" + parentFolder);
                operationsExecutor.syncDataSetWithDestination(containerFile, parentFolder);
                operationLog.info("Updating archive container took " + stopWatch);
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public Status deleteContainerFromFinalDestination(IMultiDataSetArchiveCleaner cleaner, String containerLocalPath) {
        try {
            ArchiveDestination finalDestination = this.getFinalArchive();
            File containerInFinalDestination = new File(finalDestination.getDestination(), containerLocalPath);
            cleaner.delete(containerInFinalDestination);
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public IHierarchicalContent getContainerAsHierarchicalContent(String containerPath) {
        ArchiveDestination archiveDestination = this.getFinalArchive();
        String destinationRoot = archiveDestination.getDestination();
        File containerInDestination = new File(destinationRoot, containerPath);
        IHierarchicalContent containerMetaData = this.packageManager.asHierarchialContent(containerInDestination, !this.hdf5FilesInDataSet);
        return new FilteredHierarchicalContent(containerMetaData, METADATA_IN_CONTAINER_FILTER);
    }

    private boolean createFolderIfNotExists(ArchiveDestination archiveDestination, File destinationFolder) {
        BooleanStatus destinationExists = this.destinationExists(archiveDestination, destinationFolder);
        if (!destinationExists.isSuccess()) {
            archiveDestination.getExecutor().createFolder(destinationFolder);
            return true;
        }
        return false;
    }

    private BooleanStatus destinationExists(ArchiveDestination archiveDestination, File destinationFolder) {
        BooleanStatus destinationExists = archiveDestination.getExecutor().exists(destinationFolder);
        if (destinationExists.isError()) {
            throw new ExceptionWithStatus(Status.createError("CHECK_EXISTENCE_FAILED"));
        }
        return destinationExists;
    }
}

