/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BlastUtils {
    public static final String BLAST_TOOLS_DIRECTORY_PROPERTY = "blast-tools-directory";
    public static final String BLAST_DATABASES_FOLDER_PROPERTY = "blast-databases-folder";
    public static final String DEFAULT_BLAST_DATABASES_FOLDER = "blast-databases";

    public static File getBlastDatabaseFolder(Properties properties, File storeRoot) {
        return BlastUtils.getFile(properties, BLAST_DATABASES_FOLDER_PROPERTY, DEFAULT_BLAST_DATABASES_FOLDER, storeRoot);
    }

    public static String getBLASTToolDirectory(Properties properties) {
        String blastToolsDirectory = properties.getProperty(BLAST_TOOLS_DIRECTORY_PROPERTY, "");
        if (blastToolsDirectory.endsWith("/") || blastToolsDirectory.isEmpty()) {
            return blastToolsDirectory;
        }
        return String.valueOf(blastToolsDirectory) + "/";
    }

    public static File getFile(Properties properties, String pathProperty, String defaultPath, File storeRoot) {
        String path = properties.getProperty(pathProperty);
        return path == null ? new File(storeRoot, defaultPath) : new File(path);
    }

    public static void logMissingTools(Logger operationLog) {
        operationLog.error("BLAST isn't installed or property 'blast-tools-directory' hasn't been correctly specified.");
    }
}

