/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.util.Set;

public class DatabaseModificationAwareObject<T>
implements IDatabaseModificationObserver {
    private final T object;
    private final IDatabaseModificationObserver modificationObserver;

    public static <T> DatabaseModificationAwareObject<T> createUnaware(T object) {
        IDatabaseModificationObserver dummyObserver = DatabaseModificationAwareObject.createDummyModificationObserver();
        return new DatabaseModificationAwareObject<T>(object, dummyObserver);
    }

    protected static IDatabaseModificationObserver createDummyModificationObserver() {
        return new IDatabaseModificationObserver(){

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return DatabaseModificationKind.EMPTY_ARRAY;
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications) {
            }
        };
    }

    public DatabaseModificationAwareObject(T holder, IDatabaseModificationObserver modificationObserver) {
        this.object = holder;
        this.modificationObserver = modificationObserver;
    }

    public IDatabaseModificationObserver getModificationObserver() {
        return this.modificationObserver;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.modificationObserver.getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.modificationObserver.update(observedModifications);
    }

    public T get() {
        return this.object;
    }
}

