/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SpaceModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SessionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.User;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.MessageBox;
import java.util.ArrayList;
import java.util.List;

public class SpaceSelectionWidget
extends DropDownList<SpaceModel, Space> {
    public static final String SUFFIX = "group-select";
    private final IViewContext<?> viewContext;
    private String initialSpaceOrNull;
    public static final String SHARED_SPACE_CODE = "(Shared)";
    public static final String ALL_SPACES_CODE = "(all)";
    private final boolean addShared;
    public boolean dataLoaded = false;
    private final boolean addAll;

    public static final boolean isSharedSpace(Space g) {
        return SHARED_SPACE_CODE.equals(g.getCode());
    }

    public static final boolean isAllSpaces(Space g) {
        return ALL_SPACES_CODE.equals(g.getCode());
    }

    public static final String tryToGetSpaceCode(Space space) {
        String code = space.getCode();
        return code.equals(ALL_SPACES_CODE) ? null : code;
    }

    public SpaceSelectionWidget(IViewContext<?> viewContext, String idSuffix, boolean addShared, boolean addAll) {
        this(viewContext, idSuffix, addShared, addAll, null);
    }

    public SpaceSelectionWidget(IViewContext<?> viewContext, String idSuffix, boolean addShared, boolean addAll, String initialSpaceCodeOrNull) {
        super(viewContext, SUFFIX + idSuffix, "group", "code", viewContext.getMessage("group", new Object[0]), viewContext.getMessage("group", new Object[0]));
        this.viewContext = viewContext;
        this.addShared = addShared;
        this.addAll = addAll;
        this.initialSpaceOrNull = initialSpaceCodeOrNull;
    }

    public final Space tryGetSelectedSpace() {
        return (Space)super.tryGetSelected();
    }

    private Space createSharedSpace() {
        Space space = new Space();
        space.setCode(SHARED_SPACE_CODE);
        space.setIdentifier("/");
        return space;
    }

    private Space createAllSpaces() {
        Space space = new Space();
        space.setCode(ALL_SPACES_CODE);
        return space;
    }

    public void selectSpaceAndUpdateOriginal(String space) {
        this.initialSpaceOrNull = space;
        if (this.dataLoaded && this.initialSpaceOrNull != null) {
            try {
                GWTUtils.setSelectedItem(this, "code", this.initialSpaceOrNull);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageBox.alert((String)"Error", (String)("Space '" + space + "' doesn't exist."), null);
            }
            this.updateOriginalValue();
        }
    }

    @Override
    protected List<SpaceModel> convertItems(List<Space> result) {
        return SpaceModel.convert(result);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<Space>> callback) {
        DefaultResultSetConfig<String, TableModelRowWithObject<Space>> config = DefaultResultSetConfig.createFetchAll();
        this.viewContext.getCommonService().listSpaces(config, new ListSpaceCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.SPACE);
    }

    private final class ListSpaceCallback
    extends AbstractAsyncCallback<TypedTableResultSet<Space>> {
        ListSpaceCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(TypedTableResultSet<Space> result) {
            SpaceSelectionWidget.this.resultSetKey = result.getResultSet().getResultSetKey();
            ListStore spaceStore = SpaceSelectionWidget.this.getStore();
            spaceStore.removeAll();
            if (SpaceSelectionWidget.this.addShared) {
                spaceStore.add((ModelData)new SpaceModel(SpaceSelectionWidget.this.createSharedSpace()));
            }
            if (SpaceSelectionWidget.this.addAll) {
                spaceStore.add((ModelData)new SpaceModel(SpaceSelectionWidget.this.createAllSpaces()));
            }
            List<TableModelRowWithObject<Space>> tableRows = result.getResultSet().getList().extractOriginalObjects();
            ArrayList<Space> spaces = new ArrayList<Space>();
            for (TableModelRowWithObject<Space> tableModelRowWithObject : tableRows) {
                spaces.add(tableModelRowWithObject.getObjectOrNull());
            }
            spaceStore.add(SpaceSelectionWidget.this.convertItems((List<Space>)spaces));
            SpaceSelectionWidget.this.dataLoaded = true;
            if (spaceStore.getCount() > 0) {
                SpaceSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_choose", this.viewContext.getMessage("group", new Object[0])));
                SpaceSelectionWidget.this.setReadOnly(false);
                if (SpaceSelectionWidget.this.initialSpaceOrNull != null) {
                    SpaceSelectionWidget.this.selectSpaceAndUpdateOriginal(SpaceSelectionWidget.this.initialSpaceOrNull);
                } else {
                    int homeGroupIndex = this.getSpaceGroupIndex((ListStore<SpaceModel>)spaceStore);
                    if (homeGroupIndex > -1) {
                        SpaceSelectionWidget.this.setValue((ModelData)((SpaceModel)spaceStore.getAt(homeGroupIndex)));
                        SpaceSelectionWidget.this.setOriginalValue((Object)((SpaceModel)((Object)SpaceSelectionWidget.this.getValue())));
                    }
                }
            } else {
                SpaceSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_empty", this.viewContext.getMessage("groups", new Object[0])));
                SpaceSelectionWidget.this.setReadOnly(true);
            }
            SpaceSelectionWidget.this.removeResultSetFromCache();
        }

        int getSpaceGroupIndex(ListStore<SpaceModel> spaceStore) {
            SessionContext sessionContext = this.viewContext.getModel().getSessionContext();
            User user = sessionContext.getUser();
            String homeSpace = user.getHomeGroupCode();
            if (homeSpace != null) {
                int i = 0;
                while (i < spaceStore.getCount()) {
                    if (((SpaceModel)spaceStore.getAt(i)).get("code").equals(homeSpace)) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }
    }
}

