/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.string.ReflectingStringUnescaper;
import ch.systemsx.cisd.common.string.UnicodeUtils;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ArchivingResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DataSetUploadParameters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedCriteriaOrSelectedEntityHolder;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedIdHolderCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.EntityPropertyUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.EntityPropertyUpdatesResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListEntityHistoryCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListExperimentsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMaterialDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMetaprojectsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListPersonsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria2;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListScriptsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.RelatedDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetWithEntityTypes;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.InvalidSessionException;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AttachmentRegistrationHelper;
import ch.systemsx.cisd.openbis.generic.client.web.server.ListSamplesOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ITableDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractExternalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractMaterialProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AttachmentVersionsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AuthorizationGroupProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.CacheManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.CustomGridColumnProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DataSetTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DeletionsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityHistoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypePropertyTypeBrowserProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypePropertyTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ExperimentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.FileFormatTypesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.GridCustomFilterProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.MatchingEntitiesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.MetaprojectProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.PersonsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ProjectsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.PropertyTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.RoleAssignmentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SampleProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SampleTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ScriptProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SpacesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableDataProviderFactory;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableForUpdateExporter;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.VocabulariesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.VocabularyTermsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.ResultSetTranslator;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.SearchableEntityTranslator;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.TSVRenderer;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignmentsIds;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.DataSetTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.ExperimentTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.MaterialTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.MetaprojectIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.MetaprojectTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SampleTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentVersions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroupUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelationshipRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DynamicPropertyEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityValidationEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertyTypeUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IScriptUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISpaceUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsCount;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ProjectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.ValidationException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;

public final class CommonClientService
extends AbstractClientService
implements ICommonClientService {
    private final ICommonServer commonServer;
    private static final String MANAGED_PROPERTY_UPDATE_ERROR_MSG = "Problem occured when updating managed property. Contact instance admin about a possible bug in script definition.";

    public CommonClientService(ICommonServer commonServer, IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
        this.commonServer = commonServer;
    }

    @Override
    protected final IServer getServer() {
        return this.commonServer;
    }

    private final <T> TableExportCriteria<T> getAndRemoveExportCriteria(String exportDataKey) {
        CacheManager exportManager = this.getExportManager();
        TableExportCriteria exportCriteria = (TableExportCriteria)exportManager.tryGetData(exportDataKey);
        assert (exportCriteria != null) : "No export criteria found at key " + exportDataKey;
        exportManager.removeData(exportDataKey);
        return exportCriteria;
    }

    protected final <T> GridRowModels<T> fetchCachedEntities(TableExportCriteria<T> exportCriteria) {
        return this.fetchCachedEntities(exportCriteria, ResultSetTranslator.Escape.NO);
    }

    protected final <T> GridRowModels<T> fetchCachedEntities(TableExportCriteria<T> exportCriteria, ResultSetTranslator.Escape escape) {
        IResultSetConfig<String, T> resultSetConfig = CommonClientService.createExportListCriteria(exportCriteria);
        IOriginalDataProvider dummyDataProvider = CommonClientService.createDummyDataProvider();
        IResultSet<String, T> result = this.getResultSet(resultSetConfig, dummyDataProvider);
        ResultSet<T> entities = ResultSetTranslator.translate(result, escape);
        return entities.getList();
    }

    private static <T> IResultSetConfig<String, T> createExportListCriteria(TableExportCriteria<T> exportCriteria) {
        DefaultResultSetConfig<String, T> criteria = DefaultResultSetConfig.createFetchAll();
        criteria.setSortInfo(exportCriteria.getSortInfo());
        criteria.setFilters(exportCriteria.getFilters());
        criteria.setCacheConfig(ResultSetFetchConfig.createFetchFromCache(exportCriteria.getResultSetKey()));
        criteria.setAvailableColumns(exportCriteria.getAvailableColumns());
        criteria.setPresentedColumns(exportCriteria.getColumnDefs());
        criteria.setGridDisplayId(exportCriteria.getGridDisplayId());
        return criteria;
    }

    @Override
    public final String getExportTable(String exportDataKey, String lineSeparator) {
        return this.getGenericExportTable(exportDataKey, lineSeparator);
    }

    private final <T> String getGenericExportTable(String exportDataKey, String lineSeparator) {
        String session = this.getSessionToken();
        TableExportCriteria<T> exportCriteria = this.getAndRemoveExportCriteria(exportDataKey);
        GridRowModels<T> entities = this.fetchCachedEntities(exportCriteria);
        EntityKind entityKindForUpdate = exportCriteria.getEntityKindForUpdateOrNull();
        if (entityKindForUpdate != null) {
            return TableForUpdateExporter.getExportTableForUpdate(entities, entityKindForUpdate, lineSeparator, this.commonServer, session);
        }
        ITableDataProvider dataProvider = TableDataProviderFactory.createDataProvider(entities, exportCriteria.getColumnDefs());
        return TSVRenderer.createTable(dataProvider, lineSeparator);
    }

    @Override
    public final void removeResultSet(String resultSetKey) {
        try {
            this.getSessionToken();
            this.getResultSetManager().removeResultSet(resultSetKey);
        }
        catch (ch.systemsx.cisd.common.exceptions.InvalidSessionException invalidSessionException) {
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    @Override
    public final void registerSpace(String groupCode, String descriptionOrNull) {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerSpace(sessionToken, groupCode, descriptionOrNull);
    }

    @Override
    public final void updateSpace(ISpaceUpdates updates) {
        assert (updates != null) : "Unspecified updates.";
        String sessionToken = this.getSessionToken();
        this.commonServer.updateSpace(sessionToken, updates);
    }

    @Override
    public final ScriptUpdateResult updateScript(IScriptUpdates updates) {
        assert (updates != null) : "Unspecified updates.";
        String sessionToken = this.getSessionToken();
        return this.commonServer.updateScript(sessionToken, updates);
    }

    @Override
    public final void registerPerson(String code) {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerPerson(sessionToken, code);
    }

    @Override
    public final void registerSpaceRole(RoleWithHierarchy role, String group, Grantee grantee) {
        String sessionToken = this.getSessionToken();
        SpaceIdentifier groupIdentifier = new SpaceIdentifier(DatabaseInstanceIdentifier.HOME, group);
        this.commonServer.registerSpaceRole(sessionToken, role.getRoleCode(), groupIdentifier, grantee);
    }

    @Override
    public final void registerInstanceRole(RoleWithHierarchy role, Grantee grantee) {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerInstanceRole(sessionToken, role.getRoleCode(), grantee);
    }

    @Override
    public final void deleteSpaceRole(RoleWithHierarchy role, String group, Grantee grantee) {
        String sessionToken = this.getSessionToken();
        SpaceIdentifier groupIdentifier = new SpaceIdentifier(DatabaseInstanceIdentifier.HOME, group);
        this.commonServer.deleteSpaceRole(sessionToken, role.getRoleCode(), groupIdentifier, grantee);
    }

    @Override
    public final void deleteInstanceRole(RoleWithHierarchy role, Grantee grantee) {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteInstanceRole(sessionToken, role.getRoleCode(), grantee);
    }

    @Override
    public final List<SampleType> listSampleTypes() {
        String sessionToken = this.getSessionToken();
        List<SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        return sampleTypes;
    }

    @Override
    public Map<String, List<IManagedInputWidgetDescription>> listManagedInputWidgetDescriptions(EntityKind entityKind, String entityTypeCode) {
        String sessionToken = this.getSessionToken();
        return this.commonServer.listManagedInputWidgetDescriptions(sessionToken, entityKind, entityTypeCode);
    }

    @Override
    public String prepareExportSamples(TableExportCriteria<TableModelRowWithObject<Sample>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public final String prepareExportExperiments(TableExportCriteria<TableModelRowWithObject<Experiment>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public final String prepareExportMatchingEntities(TableExportCriteria<TableModelRowWithObject<MatchingEntity>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportPropertyTypes(TableExportCriteria<TableModelRowWithObject<PropertyType>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportEntityHistory(TableExportCriteria<TableModelRowWithObject<EntityHistory>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportPropertyTypeAssignments(TableExportCriteria<TableModelRowWithObject<EntityTypePropertyType<?>>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportProjects(TableExportCriteria<TableModelRowWithObject<Project>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportDeletions(TableExportCriteria<TableModelRowWithObject<Deletion>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportVocabularies(TableExportCriteria<TableModelRowWithObject<Vocabulary>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportVocabularyTerms(TableExportCriteria<TableModelRowWithObject<VocabularyTermWithStats>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportMaterialTypes(TableExportCriteria<TableModelRowWithObject<MaterialType>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportExperimentTypes(TableExportCriteria<TableModelRowWithObject<ExperimentType>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportSampleTypes(TableExportCriteria<TableModelRowWithObject<SampleType>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportDataSetTypes(TableExportCriteria<TableModelRowWithObject<DataSetType>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportFileTypes(TableExportCriteria<FileFormatType> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportAttachmentVersions(TableExportCriteria<TableModelRowWithObject<AttachmentVersions>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportScripts(TableExportCriteria<TableModelRowWithObject<Script>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportMetaprojects(TableExportCriteria<TableModelRowWithObject<Metaproject>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportSpaces(TableExportCriteria<TableModelRowWithObject<Space>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportPersons(TableExportCriteria<TableModelRowWithObject<Person>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public String prepareExportRoleAssignments(TableExportCriteria<TableModelRowWithObject<RoleAssignment>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public final ResultSetWithEntityTypes<Sample> listSamples(ListSampleDisplayCriteria listCriteria) {
        String sessionToken = this.getSessionToken();
        return this.listEntitiesWithTypes(listCriteria, new ListSamplesOriginalDataProvider(this.commonServer, sessionToken, listCriteria));
    }

    @Override
    public TypedTableResultSet<Sample> listSamples2(ListSampleDisplayCriteria2 criteria) {
        SampleProvider provider = new SampleProvider(this.commonServer, this.getSessionToken(), criteria);
        return this.listEntities(provider, criteria);
    }

    @Override
    public List<Sample> listMetaprojectSamples(Long metaprojectId) {
        return this.commonServer.listMetaprojectSamples(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId));
    }

    @Override
    public TypedTableResultSet<AbstractExternalData> searchForDataSets(final DetailedSearchCriteria criteria, IResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig) {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new AbstractExternalDataProvider(this.commonServer, sessionToken){

            @Override
            protected List<AbstractExternalData> getDataSets() {
                return this.commonServer.searchForDataSets(this.sessionToken, criteria);
            }
        }, resultSetConfig);
    }

    @Override
    public TypedTableResultSet<AbstractExternalData> searchForDataSets(RelatedDataSetCriteria<? extends IEntityInformationHolder> criteria, IResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig) {
        String sessionToken = this.getSessionToken();
        final DataSetRelatedEntities entities = this.extractRelatedEntities(criteria);
        return this.listEntities(new AbstractExternalDataProvider(this.commonServer, sessionToken){

            @Override
            protected List<AbstractExternalData> getDataSets() {
                return this.commonServer.listRelatedDataSets(this.sessionToken, entities, false);
            }
        }, resultSetConfig);
    }

    private <E extends IEntityInformationHolder> DataSetRelatedEntities extractRelatedEntities(RelatedDataSetCriteria<E> criteria) {
        List<TableModelRowWithObject<E>> rows = criteria.tryGetSelectedEntities();
        if (rows == null) {
            TableExportCriteria<TableModelRowWithObject<E>> displayedEntitiesCriteria = criteria.tryGetDisplayedEntities();
            assert (displayedEntitiesCriteria != null) : "displayedEntitiesCriteria is null";
            rows = this.fetchCachedEntities(displayedEntitiesCriteria).extractOriginalObjects();
        }
        ArrayList<IEntityInformationHolder> entities = new ArrayList<IEntityInformationHolder>();
        for (TableModelRowWithObject<E> row : rows) {
            entities.add((IEntityInformationHolder)row.getObjectOrNull());
        }
        return new DataSetRelatedEntities(entities);
    }

    @Override
    public final TypedTableResultSet<Experiment> listExperiments(ListExperimentsCriteria listCriteria) {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new ExperimentProvider(this.commonServer, sessionToken, listCriteria), listCriteria);
    }

    @Override
    public final List<Experiment> listMetaprojectExperiments(Long metaprojectId) {
        return this.commonServer.listMetaprojectExperiments(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId));
    }

    @Override
    public TypedTableResultSet<PropertyType> listPropertyTypes(DefaultResultSetConfig<String, TableModelRowWithObject<PropertyType>> criteria) {
        return this.listEntities(new PropertyTypeProvider(this.commonServer, this.getSessionToken()), criteria);
    }

    @Override
    public TypedTableResultSet<EntityHistory> listEntityHistory(ListEntityHistoryCriteria criteria) {
        String sessionToken = this.getSessionToken();
        return this.listEntities(new EntityHistoryProvider(this.commonServer, sessionToken, criteria), criteria);
    }

    @Override
    public final TypedTableResultSet<MatchingEntity> listMatchingEntities(ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity searchableEntityOrNull, String queryText, boolean useWildcardSearchMode, IResultSetConfig<String, TableModelRowWithObject<MatchingEntity>> resultSetConfig) {
        SearchableEntity[] matchingEntities = SearchableEntityTranslator.translate(searchableEntityOrNull);
        MatchingEntitiesProvider provider = new MatchingEntitiesProvider(this.commonServer, this.getSessionToken(), matchingEntities, queryText, useWildcardSearchMode);
        return this.listEntities(provider, resultSetConfig);
    }

    @Override
    public TypedTableResultSet<EntityTypePropertyType<?>> listPropertyTypeAssignmentsFromBrowser(DefaultResultSetConfig<String, TableModelRowWithObject<EntityTypePropertyType<?>>> criteria, EntityType entity, List<NewPTNewAssigment> propertyTypesAsgs) {
        return this.listEntities(new EntityTypePropertyTypeBrowserProvider(entity, propertyTypesAsgs), criteria);
    }

    @Override
    public TypedTableResultSet<EntityTypePropertyType<?>> listPropertyTypeAssignments(DefaultResultSetConfig<String, TableModelRowWithObject<EntityTypePropertyType<?>>> criteria, EntityType entity) {
        return this.listEntities(new EntityTypePropertyTypeProvider(this.commonServer, this.getSessionToken(), entity), criteria);
    }

    @Override
    public List<EntityTypePropertyType<?>> listPropertyTypeAssignments(EntityType entityType) {
        return this.commonServer.listEntityTypePropertyTypes(this.getSessionToken(), entityType);
    }

    @Override
    public TypedTableResultSet<Space> listSpaces(DefaultResultSetConfig<String, TableModelRowWithObject<Space>> criteria) {
        SpacesProvider spacesProvider = new SpacesProvider(this.commonServer, this.getSessionToken());
        return this.listEntities(spacesProvider, criteria);
    }

    @Override
    public TypedTableResultSet<Script> listScripts(ListScriptsCriteria criteria) {
        ScriptProvider scriptProvider = new ScriptProvider(this.commonServer, this.getSessionToken(), criteria.tryGetScriptType(), criteria.tryGetEntityKind());
        return this.listEntities(scriptProvider, criteria);
    }

    @Override
    public List<Metaproject> listMetaprojects() throws UserFailureException {
        return this.commonServer.listMetaprojects(this.getSessionToken());
    }

    @Override
    public TypedTableResultSet<Metaproject> listMetaprojects(ListMetaprojectsCriteria criteria) throws ch.systemsx.cisd.common.exceptions.UserFailureException {
        MetaprojectProvider metaprojectProvider = new MetaprojectProvider(this.commonServer, this.getSessionToken(), criteria);
        return this.listEntities(metaprojectProvider, criteria);
    }

    @Override
    public List<MetaprojectAssignmentsCount> listMetaprojectAssignmentsCounts() throws UserFailureException {
        return this.commonServer.listMetaprojectAssignmentsCounts(this.getSessionToken());
    }

    @Override
    public MetaprojectAssignmentsCount getMetaprojectAssignmentsCount(Long metaprojectId) throws UserFailureException {
        return this.commonServer.getMetaprojectAssignmentsCount(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId));
    }

    @Override
    public Metaproject getMetaproject(Long metaprojectId) throws UserFailureException {
        return this.commonServer.getMetaproject(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId));
    }

    @Override
    public Metaproject getMetaproject(String metaprojectIdentifier) throws UserFailureException {
        return this.commonServer.getMetaproject(this.getSessionToken(), new MetaprojectIdentifierId(metaprojectIdentifier));
    }

    @Override
    public Metaproject updateMetaproject(Long metaprojectId, IMetaprojectUpdates updates) throws UserFailureException {
        return this.commonServer.updateMetaproject(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId), updates);
    }

    @Override
    public List<AuthorizationGroup> listAuthorizationGroups() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<AuthorizationGroup> authGroups = this.commonServer.listAuthorizationGroups(sessionToken);
        return authGroups;
    }

    @Override
    public TypedTableResultSet<Person> listPersons(ListPersonsCriteria criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        TechId authorizationGroupId = criteria.getAuthorizationGroupId();
        return this.listEntities(new PersonsProvider(this.commonServer, sessionToken, authorizationGroupId), criteria);
    }

    @Override
    public final List<Person> listPersons() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<Person> persons = this.commonServer.listPersons(sessionToken);
        return persons;
    }

    @Override
    public final List<Person> listActivePersons() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<Person> persons = this.commonServer.listActivePersons(sessionToken);
        return persons;
    }

    @Override
    public TypedTableResultSet<RoleAssignment> listRoleAssignments(DefaultResultSetConfig<String, TableModelRowWithObject<RoleAssignment>> criteria) throws UserFailureException {
        return this.listEntities(new RoleAssignmentProvider(this.commonServer, this.getSessionToken()), criteria);
    }

    public final List<RoleAssignment> listRoleAssignments() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<RoleAssignment> roles = this.commonServer.listRoleAssignments(sessionToken);
        return roles;
    }

    @Override
    public TypedTableResultSet<Project> listProjects(DefaultResultSetConfig<String, TableModelRowWithObject<Project>> criteria) throws UserFailureException {
        ProjectsProvider projectsProvider = new ProjectsProvider(this.commonServer, this.getSessionToken());
        return this.listEntities(projectsProvider, criteria);
    }

    @Override
    public List<Project> listProjectsForTree() throws UserFailureException {
        return this.commonServer.listProjects(this.getSessionToken());
    }

    @Override
    public TypedTableResultSet<Vocabulary> listVocabularies(boolean withTerms, boolean excludeInternal, DefaultResultSetConfig<String, TableModelRowWithObject<Vocabulary>> criteria) throws UserFailureException {
        VocabulariesProvider provider = new VocabulariesProvider(this.commonServer, this.getSessionToken(), withTerms, excludeInternal);
        return this.listEntities(provider, criteria);
    }

    @Override
    public TypedTableResultSet<VocabularyTermWithStats> listVocabularyTerms(Vocabulary vocabulary, DefaultResultSetConfig<String, TableModelRowWithObject<VocabularyTermWithStats>> criteria) {
        VocabularyTermsProvider vocabularyTermsProvider = new VocabularyTermsProvider(this.commonServer, this.getSessionToken(), vocabulary);
        return this.listEntities(vocabularyTermsProvider, criteria);
    }

    @Override
    public TypedTableResultSet<MaterialType> listMaterialTypes(DefaultResultSetConfig<String, TableModelRowWithObject<MaterialType>> criteria) throws UserFailureException {
        return this.listEntities(new EntityTypeProvider<MaterialType>(this.commonServer, this.getSessionToken()){

            @Override
            protected List<MaterialType> listTypes() {
                return this.commonServer.listMaterialTypes(this.sessionToken);
            }
        }, criteria);
    }

    @Override
    public TypedTableResultSet<SampleType> listSampleTypes(DefaultResultSetConfig<String, TableModelRowWithObject<SampleType>> criteria) throws UserFailureException {
        return this.listEntities(new SampleTypeProvider(this.commonServer, this.getSessionToken()), criteria);
    }

    @Override
    public TypedTableResultSet<ExperimentType> listExperimentTypes(DefaultResultSetConfig<String, TableModelRowWithObject<ExperimentType>> criteria) throws UserFailureException {
        return this.listEntities(new EntityTypeProvider<ExperimentType>(this.commonServer, this.getSessionToken()){

            @Override
            protected List<ExperimentType> listTypes() {
                return this.commonServer.listExperimentTypes(this.sessionToken);
            }
        }, criteria);
    }

    @Override
    public TypedTableResultSet<DataSetType> listDataSetTypes(DefaultResultSetConfig<String, TableModelRowWithObject<DataSetType>> criteria) throws UserFailureException {
        return this.listEntities(new DataSetTypeProvider(this.commonServer, this.getSessionToken()), criteria);
    }

    @Override
    public TypedTableResultSet<FileFormatType> listFileTypes(DefaultResultSetConfig<String, TableModelRowWithObject<FileFormatType>> criteria) throws UserFailureException {
        FileFormatTypesProvider provider = new FileFormatTypesProvider(this.commonServer, this.getSessionToken());
        return this.listEntities(provider, criteria);
    }

    @Override
    public TypedTableResultSet<AbstractExternalData> listSampleDataSets(final TechId sampleId, DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> criteria, final boolean showOnlyDirectlyConnected) throws UserFailureException {
        return this.listEntities(new AbstractExternalDataProvider(this.commonServer, this.getSessionToken()){

            @Override
            protected List<AbstractExternalData> getDataSets() {
                return this.commonServer.listSampleExternalData(this.sessionToken, sampleId, showOnlyDirectlyConnected);
            }
        }, criteria);
    }

    @Override
    public TypedTableResultSet<AbstractExternalData> listExperimentDataSets(final TechId experimentId, DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> criteria, final boolean onlyDirectlyConnected) throws UserFailureException {
        return this.listEntities(new AbstractExternalDataProvider(this.commonServer, this.getSessionToken()){

            @Override
            protected List<AbstractExternalData> getDataSets() {
                return this.commonServer.listExperimentExternalData(this.sessionToken, experimentId, onlyDirectlyConnected);
            }
        }, criteria);
    }

    @Override
    public TypedTableResultSet<AbstractExternalData> listMetaprojectDataSets(final TechId metaprojectId, DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> criteria) throws UserFailureException {
        return this.listEntities(new AbstractExternalDataProvider(this.commonServer, this.getSessionToken()){

            @Override
            protected List<AbstractExternalData> getDataSets() {
                return this.commonServer.listMetaprojectExternalData(this.sessionToken, new MetaprojectTechIdId(metaprojectId));
            }
        }, criteria);
    }

    @Override
    public List<AbstractExternalData> listMetaprojectDataSets(Long metaprojectId) {
        return this.commonServer.listMetaprojectExternalData(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId));
    }

    @Override
    public TypedTableResultSet<AbstractExternalData> listDataSetRelationships(final TechId datasetId, final DataSetRelationshipRole role, DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> criteria) throws UserFailureException {
        return this.listEntities(new AbstractExternalDataProvider(this.commonServer, this.getSessionToken()){

            @Override
            protected List<AbstractExternalData> getDataSets() {
                return this.commonServer.listDataSetRelationships(this.sessionToken, datasetId, role);
            }
        }, criteria);
    }

    @Override
    public final List<ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity> listSearchableEntities() throws UserFailureException {
        try {
            this.getSessionToken();
            List<ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity> searchableEntities = BeanUtils.createBeanList(ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity.class, Arrays.asList(SearchableEntity.values()));
            return searchableEntities;
        }
        catch (ch.systemsx.cisd.common.exceptions.UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public List<ExperimentType> listExperimentTypes() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        return experimentTypes;
    }

    @Override
    public List<PropertyType> listPropertyTypes(boolean withRelations) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<PropertyType> propertyTypes = this.commonServer.listPropertyTypes(sessionToken, withRelations);
        return propertyTypes;
    }

    @Override
    public final List<DataType> listDataTypes() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<DataType> dataTypes = this.commonServer.listDataTypes(sessionToken);
        return dataTypes;
    }

    @Override
    public String registerEntitytypeAndAssignPropertyTypes(NewETNewPTAssigments newETNewPTAssigments) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.registerEntitytypeAndAssignPropertyTypes(sessionToken, newETNewPTAssigments);
    }

    @Override
    public String updateEntitytypeAndPropertyTypes(NewETNewPTAssigments newETNewPTAssigments) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.updateEntitytypeAndPropertyTypes(sessionToken, newETNewPTAssigments);
    }

    @Override
    public String registerAndAssignPropertyType(PropertyType propertyType, NewETPTAssignment assignment) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.registerAndAssignPropertyType(sessionToken, propertyType, assignment);
    }

    @Override
    public String assignPropertyType(NewETPTAssignment assignment) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.assignPropertyType(sessionToken, assignment);
    }

    @Override
    public void updatePropertyTypeAssignment(NewETPTAssignment assignmentUpdates) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.updatePropertyTypeAssignment(sessionToken, assignmentUpdates);
    }

    @Override
    public void unassignPropertyType(EntityKind entityKind, String propertyTypeCode, String entityTypeCode) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.unassignPropertyType(sessionToken, entityKind, propertyTypeCode, entityTypeCode);
    }

    @Override
    public int countPropertyTypedEntities(EntityKind entityKind, String propertyTypeCode, String entityTypeCode) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.countPropertyTypedEntities(sessionToken, entityKind, propertyTypeCode, entityTypeCode);
    }

    @Override
    public final void registerPropertyType(PropertyType propertyType) throws UserFailureException {
        assert (propertyType != null) : "Unspecified property type.";
        String sessionToken = this.getSessionToken();
        this.commonServer.registerPropertyType(sessionToken, propertyType);
    }

    @Override
    public final void updatePropertyType(IPropertyTypeUpdates updates) throws UserFailureException {
        assert (updates != null) : "Unspecified updates.";
        String sessionToken = this.getSessionToken();
        this.commonServer.updatePropertyType(sessionToken, updates);
    }

    @Override
    public final void updateVocabularyTerm(IVocabularyTermUpdates updates) throws UserFailureException {
        assert (updates != null) : "Unspecified updates.";
        String sessionToken = this.getSessionToken();
        this.commonServer.updateVocabularyTerm(sessionToken, updates);
    }

    @Override
    public final void registerVocabulary(String termsSessionKey, NewVocabulary vocabulary) throws UserFailureException {
        assert (vocabulary != null) : "Unspecified vocabulary.";
        String sessionToken = this.getSessionToken();
        if (vocabulary.isUploadedFromFile()) {
            List<VocabularyTerm> extractedTerms = this.extractVocabularyTermsFromUploadedData(termsSessionKey, BatchOperationKind.REGISTRATION);
            vocabulary.setTerms(extractedTerms);
        }
        this.commonServer.registerVocabulary(sessionToken, vocabulary);
    }

    @Override
    public final void updateVocabulary(IVocabularyUpdates updates) throws UserFailureException {
        assert (updates != null) : "Unspecified updates.";
        String sessionToken = this.getSessionToken();
        this.commonServer.updateVocabulary(sessionToken, updates);
    }

    private final List<VocabularyTerm> extractVocabularyTermsFromUploadedData(String sessionKey, BatchOperationKind operationKind) {
        VocabularyTermsExtractor extractor = new VocabularyTermsExtractor(operationKind).prepareTerms(sessionKey);
        return extractor.getTerms();
    }

    @Override
    public void addVocabularyTerms(TechId vocabularyId, List<VocabularyTerm> vocabularyTerms, Long previousTermOrdinal) throws UserFailureException {
        assert (vocabularyId != null) : "Unspecified vocabulary id.";
        if (vocabularyTerms != null && !vocabularyTerms.isEmpty()) {
            String sessionToken = this.getSessionToken();
            this.commonServer.addVocabularyTerms(sessionToken, vocabularyId, vocabularyTerms, previousTermOrdinal, false);
        }
    }

    @Override
    public void addUnofficialVocabularyTerm(TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) throws UserFailureException {
        assert (vocabularyId != null) : "Unspecified vocabulary id.";
        String sessionToken = this.getSessionToken();
        this.commonServer.addUnofficialVocabularyTerm(sessionToken, vocabularyId, code, label, description, previousTermOrdinal);
    }

    @Override
    public void deleteVocabularyTerms(TechId vocabularyId, List<VocabularyTerm> termsToBeDeleted, List<VocabularyTermReplacement> termsToBeReplaced) throws UserFailureException {
        assert (vocabularyId != null) : "Unspecified vocabulary id.";
        assert (termsToBeDeleted != null) : "Unspecified term to be deleted.";
        assert (termsToBeReplaced != null) : "Unspecified term to be replaced.";
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteVocabularyTerms(sessionToken, vocabularyId, termsToBeDeleted, termsToBeReplaced);
    }

    @Override
    public void makeVocabularyTermsOfficial(TechId vocabularyId, List<VocabularyTerm> termsToBeOfficial) {
        assert (vocabularyId != null) : "Unspecified vocabulary id.";
        assert (termsToBeOfficial != null) : "Unspecified term to be official.";
        String sessionToken = this.getSessionToken();
        this.commonServer.makeVocabularyTermsOfficial(sessionToken, vocabularyId, termsToBeOfficial);
    }

    @Override
    public List<VocabularyTerm> listVocabularyTerms(Vocabulary vocabulary) {
        String sessionToken = this.getSessionToken();
        Set<VocabularyTerm> terms = this.commonServer.listVocabularyTerms(sessionToken, vocabulary);
        return new ArrayList<VocabularyTerm>(terms);
    }

    @Override
    public void registerProject(String sessionKey, final Project project) throws UserFailureException {
        assert (project != null) : "Unspecified project.";
        final String sessionToken = this.getSessionToken();
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(project.getIdentifier()).createIdentifier();
                Person leader = project.getProjectLeader();
                String leaderId = leader == null ? null : project.getProjectLeader().getUserId();
                CommonClientService.this.commonServer.registerProject(sessionToken, projectIdentifier, project.getDescription(), leaderId, attachments);
            }
        }.process(sessionKey, this.getHttpSession(), project.getNewAttachments());
    }

    @Override
    public String prepareExportDataSetSearchHits(TableExportCriteria<TableModelRowWithObject<AbstractExternalData>> exportCriteria) throws UserFailureException {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public List<MaterialType> listMaterialTypes() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<MaterialType> materialTypes = this.commonServer.listMaterialTypes(sessionToken);
        return materialTypes;
    }

    @Override
    public List<DataSetType> listDataSetTypes() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<DataSetType> types = this.commonServer.listDataSetTypes(sessionToken);
        return types;
    }

    @Override
    public TypedTableResultSet<Material> listMaterials(final ListMaterialDisplayCriteria criteria) throws UserFailureException {
        return this.listEntities(new AbstractMaterialProvider(){

            @Override
            protected List<Material> getMaterials() {
                if (criteria.getListCriteria() != null) {
                    return CommonClientService.this.commonServer.listMaterials(CommonClientService.this.getSessionToken(), criteria.getListCriteria(), true);
                }
                if (criteria.getMetaprojectCriteria() != null) {
                    return CommonClientService.this.commonServer.listMetaprojectMaterials(CommonClientService.this.getSessionToken(), new MetaprojectTechIdId(criteria.getMetaprojectCriteria().getMetaprojectId()));
                }
                throw new IllegalArgumentException("Unsupported criteria: " + criteria);
            }
        }, criteria);
    }

    @Override
    public List<Material> listMetaprojectMaterials(Long metaprojectId) {
        return this.commonServer.listMetaprojectMaterials(this.getSessionToken(), new MetaprojectTechIdId(metaprojectId));
    }

    @Override
    public String prepareExportMaterials(TableExportCriteria<TableModelRowWithObject<Material>> criteria) throws UserFailureException {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public void registerMaterialType(MaterialType entityType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerMaterialType(sessionToken, entityType);
    }

    @Override
    public void registerExperimentType(ExperimentType entityType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerExperimentType(sessionToken, entityType);
    }

    @Override
    public void registerSampleType(SampleType entityType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerSampleType(sessionToken, entityType);
    }

    @Override
    public void registerDataSetType(DataSetType entityType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerDataSetType(sessionToken, entityType);
    }

    @Override
    public void registerFileType(FileFormatType type) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerFileFormatType(sessionToken, type);
    }

    @Override
    public void updateEntityType(EntityKind entityKind, EntityType entityType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        switch (entityKind) {
            case MATERIAL: {
                this.commonServer.updateMaterialType(sessionToken, entityType);
                break;
            }
            case SAMPLE: {
                this.commonServer.updateSampleType(sessionToken, entityType);
                break;
            }
            case EXPERIMENT: {
                this.commonServer.updateExperimentType(sessionToken, entityType);
                break;
            }
            case DATA_SET: {
                this.commonServer.updateDataSetType(sessionToken, entityType);
            }
        }
    }

    @Override
    public String uploadDataSets(DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria, DataSetUploadParameters uploadParameters) throws UserFailureException {
        List<String> datasetCodes = this.extractDatasetCodes(displayedOrSelectedDatasetCriteria);
        return this.uploadDataSets(datasetCodes, uploadParameters);
    }

    private String uploadDataSets(List<String> dataSetCodes, DataSetUploadParameters uploadParameters) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        DataSetUploadContext uploadContext = new DataSetUploadContext();
        uploadContext.setCifexURL(uploadParameters.getCifexURL());
        uploadContext.setComment(uploadParameters.getComment());
        uploadContext.setFileName(uploadParameters.getFileName());
        uploadContext.setUserID(uploadParameters.getUserID());
        uploadContext.setPassword(uploadParameters.getPassword());
        return this.commonServer.uploadDataSets(sessionToken, dataSetCodes, uploadContext);
    }

    @Override
    public void deleteDataSet(String singleData, String reason, DeletionType deletionType, boolean forceDisallowedTypes) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<String> dataSetCodes = Collections.singletonList(singleData);
        if (forceDisallowedTypes) {
            this.commonServer.deleteDataSetsForced(sessionToken, dataSetCodes, reason, deletionType, this.isTrashEnabled());
        } else {
            this.commonServer.deleteDataSets(sessionToken, dataSetCodes, reason, deletionType, this.isTrashEnabled());
        }
    }

    @Override
    public void deleteDataSets(DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria, String reason, DeletionType deletionType, boolean forceDisallowedTypes) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<String> dataSetCodes = this.extractDatasetCodes(displayedOrSelectedDatasetCriteria);
        if (forceDisallowedTypes) {
            this.commonServer.deleteDataSetsForced(sessionToken, dataSetCodes, reason, deletionType, this.isTrashEnabled());
        } else {
            this.commonServer.deleteDataSets(sessionToken, dataSetCodes, reason, deletionType, this.isTrashEnabled());
        }
    }

    @Override
    public void deleteSamples(List<TechId> sampleIds, String reason, DeletionType deletionType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteSamples(sessionToken, sampleIds, reason, deletionType);
    }

    @Override
    public void deleteSample(TechId sampleId, String reason, DeletionType deletionType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteSamples(sessionToken, Collections.singletonList(sampleId), reason, deletionType);
    }

    @Override
    public void deleteSamples(DisplayedOrSelectedIdHolderCriteria<? extends IIdHolder> criteria, String reason, DeletionType deletionType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<TechId> sampleIds = this.extractTechIds(criteria);
        this.commonServer.deleteSamples(sessionToken, sampleIds, reason, deletionType);
    }

    @Override
    public void deleteExperiment(TechId experimentId, String reason, DeletionType deletionType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteExperiments(sessionToken, Collections.singletonList(experimentId), reason, deletionType);
    }

    @Override
    public void deleteExperiments(DisplayedOrSelectedIdHolderCriteria<TableModelRowWithObject<Experiment>> criteria, String reason, DeletionType deletionType) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<TechId> experimentIds = this.extractTechIds(criteria);
        this.commonServer.deleteExperiments(sessionToken, experimentIds, reason, deletionType);
    }

    @Override
    public void deleteVocabularies(List<TechId> vocabularyIds, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteVocabularies(sessionToken, vocabularyIds, reason);
    }

    @Override
    public void deletePropertyTypes(List<TechId> propertyTypeIds, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deletePropertyTypes(sessionToken, propertyTypeIds, reason);
    }

    @Override
    public void deleteProjects(List<TechId> projectIds, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteProjects(sessionToken, projectIds, reason);
    }

    @Override
    public void deleteMetaprojects(List<TechId> metaprojectIds, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        ArrayList<IMetaprojectId> ids = new ArrayList<IMetaprojectId>();
        for (TechId metaprojectId : metaprojectIds) {
            ids.add(new MetaprojectTechIdId(metaprojectId));
        }
        this.commonServer.deleteMetaprojects(sessionToken, ids, reason);
    }

    @Override
    public void deleteSpaces(List<TechId> groupIds, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteSpaces(sessionToken, groupIds, reason);
    }

    @Override
    public void deleteScripts(List<TechId> scriptIds) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteScripts(sessionToken, scriptIds);
    }

    @Override
    public void deleteAttachments(TechId holderId, AttachmentHolderKind holderKind, List<String> fileNames, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        switch (holderKind) {
            case EXPERIMENT: {
                this.commonServer.deleteExperimentAttachments(sessionToken, holderId, fileNames, reason);
                break;
            }
            case SAMPLE: {
                this.commonServer.deleteSampleAttachments(sessionToken, holderId, fileNames, reason);
                break;
            }
            case PROJECT: {
                this.commonServer.deleteProjectAttachments(sessionToken, holderId, fileNames, reason);
            }
        }
    }

    @Override
    public TypedTableResultSet<AttachmentVersions> listAttachmentVersions(TechId holderId, AttachmentHolderKind holderKind, DefaultResultSetConfig<String, TableModelRowWithObject<AttachmentVersions>> criteria) throws UserFailureException {
        return this.listEntities(new AttachmentVersionsProvider(this.commonServer, this.getSessionToken(), holderId, holderKind), criteria);
    }

    @Override
    public LastModificationState getLastModificationState() {
        return this.commonServer.getLastModificationState(this.getSessionToken());
    }

    @Override
    public final Experiment getExperimentInfo(String experimentIdentifier) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        ExperimentIdentifier identifier = new ExperimentIdentifierFactory(experimentIdentifier).createIdentifier();
        Experiment experiment = this.commonServer.getExperimentInfo(sessionToken, identifier);
        this.transformXML(experiment);
        return experiment;
    }

    @Override
    public Experiment getExperimentInfoByPermId(String experimentPermId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        IEntityInformationHolderWithPermId expInfo = this.commonServer.getEntityInformationHolder(sessionToken, EntityKind.EXPERIMENT, experimentPermId);
        return this.getExperimentInfo(new TechId(expInfo.getId()));
    }

    @Override
    public final Experiment getExperimentInfo(TechId experimentId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        Experiment experiment = this.commonServer.getExperimentInfo(sessionToken, experimentId);
        this.transformXML(experiment);
        return experiment;
    }

    @Override
    public Project getProjectInfo(TechId projectId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        Project project = this.commonServer.getProjectInfo(sessionToken, projectId);
        return project;
    }

    @Override
    public Project getProjectInfo(BasicProjectIdentifier projectIdentifier) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        Project project = this.commonServer.getProjectInfo(sessionToken, new ProjectIdentifier(projectIdentifier));
        return project;
    }

    @Override
    public Project getProjectInfoByPermId(String projectPermId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        IIdHolder holder = this.commonServer.getProjectIdHolder(sessionToken, projectPermId);
        return this.getProjectInfo(new TechId(holder.getId()));
    }

    @Override
    public String generateCode(String prefix, EntityKind entityKind) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.generateCode(sessionToken, prefix, entityKind);
    }

    @Override
    public int updateProject(final ProjectUpdates updates) throws UserFailureException {
        final String sessionToken = this.getSessionToken();
        final AtomicInteger version = new AtomicInteger();
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                ProjectUpdatesDTO updatesDTO = CommonClientService.translate(updates);
                updatesDTO.setAttachments(attachments);
                int versionNumber = CommonClientService.this.commonServer.updateProject(sessionToken, updatesDTO);
                version.set(versionNumber);
            }
        }.process(updates.getAttachmentSessionKey(), this.getHttpSession(), updates.getAttachments());
        return version.get();
    }

    private static ProjectUpdatesDTO translate(ProjectUpdates updates) {
        ProjectUpdatesDTO updatesDTO = new ProjectUpdatesDTO();
        updatesDTO.setDescription(updates.getDescription());
        updatesDTO.setVersion(updates.getVersion());
        updatesDTO.setTechId(updates.getTechId());
        updatesDTO.setSpaceCode(updates.getSpaceCode());
        return updatesDTO;
    }

    @Override
    public void deleteEntityTypes(EntityKind entityKind, List<String> entityTypesCodes) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        switch (entityKind) {
            case DATA_SET: {
                this.commonServer.deleteDataSetTypes(sessionToken, entityTypesCodes);
                break;
            }
            case SAMPLE: {
                this.commonServer.deleteSampleTypes(sessionToken, entityTypesCodes);
                break;
            }
            case EXPERIMENT: {
                this.commonServer.deleteExperimentTypes(sessionToken, entityTypesCodes);
                break;
            }
            case MATERIAL: {
                this.commonServer.deleteMaterialTypes(sessionToken, entityTypesCodes);
            }
        }
    }

    @Override
    public IEntityInformationHolderWithPermId getEntityInformationHolder(EntityKind entityKind, String permId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.getEntityInformationHolder(sessionToken, entityKind, permId);
    }

    @Override
    public IEntityInformationHolderWithPermId getMaterialInformationHolder(MaterialIdentifier identifier) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.getMaterialInformationHolder(sessionToken, identifier);
    }

    @Override
    public Material getMaterialInfo(MaterialIdentifier identifier) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.getMaterialInfo(sessionToken, identifier);
    }

    @Override
    public Material getMaterialInfo(TechId techId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        Material material = this.commonServer.getMaterialInfo(sessionToken, techId);
        this.transformXML(material);
        return material;
    }

    @Override
    public String getTemplate(EntityKind entityKind, String type, boolean autoGenerate, boolean withExperiments, boolean withSpace, BatchOperationKind operationKind) {
        String sessionToken = this.getSessionToken();
        return this.commonServer.getTemplateColumns(sessionToken, entityKind, type, autoGenerate, withExperiments, withSpace, operationKind);
    }

    @Override
    public List<FileFormatType> listFileTypes() {
        String sessionToken = this.getSessionToken();
        List<FileFormatType> types = this.commonServer.listFileFormatTypes(sessionToken);
        return types;
    }

    @Override
    public void deleteFileFormatTypes(List<String> fileFormatTypeCodes) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteFileFormatTypes(sessionToken, fileFormatTypeCodes);
    }

    @Override
    public void updateFileFormatType(AbstractType type) {
        String sessionToken = this.getSessionToken();
        this.commonServer.updateFileFormatType(sessionToken, type);
    }

    @Override
    public void updateAttachment(TechId holderId, AttachmentHolderKind holderKind, Attachment attachment) {
        String sessionToken = this.getSessionToken();
        switch (holderKind) {
            case EXPERIMENT: {
                this.commonServer.updateExperimentAttachments(sessionToken, holderId, attachment);
                break;
            }
            case SAMPLE: {
                this.commonServer.updateSampleAttachments(sessionToken, holderId, attachment);
                break;
            }
            case PROJECT: {
                this.commonServer.updateProjectAttachments(sessionToken, holderId, attachment);
            }
        }
    }

    @Override
    public void addAttachment(final TechId holderId, String sessionKey, final AttachmentHolderKind holderKind, final NewAttachment attachment) {
        final String sessionToken = this.getSessionToken();
        AttachmentRegistrationHelper helper = new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                switch (holderKind) {
                    case EXPERIMENT: {
                        CommonClientService.this.commonServer.addExperimentAttachment(sessionToken, holderId, attachment);
                        break;
                    }
                    case SAMPLE: {
                        CommonClientService.this.commonServer.addSampleAttachments(sessionToken, holderId, attachment);
                        break;
                    }
                    case PROJECT: {
                        CommonClientService.this.commonServer.addProjectAttachments(sessionToken, holderId, attachment);
                    }
                }
            }
        };
        helper.process(sessionKey, this.getHttpSession(), Collections.singletonList(attachment));
    }

    @Override
    public void updateManagedProperty(TechId entityId, EntityKind entityKind, IManagedProperty managedProperty, IManagedUiAction updateAction) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        try {
            switch (entityKind) {
                case EXPERIMENT: {
                    this.commonServer.updateManagedPropertyOnExperiment(sessionToken, entityId, managedProperty, updateAction);
                    break;
                }
                case SAMPLE: {
                    this.commonServer.updateManagedPropertyOnSample(sessionToken, entityId, managedProperty, updateAction);
                    break;
                }
                case DATA_SET: {
                    this.commonServer.updateManagedPropertyOnDataSet(sessionToken, entityId, managedProperty, updateAction);
                    break;
                }
                case MATERIAL: {
                    this.commonServer.updateManagedPropertyOnMaterial(sessionToken, entityId, managedProperty, updateAction);
                }
            }
        }
        catch (ch.systemsx.cisd.common.exceptions.UserFailureException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ValidationException) {
                throw new UserFailureException(cause.getMessage());
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Problem occured when updating managed property. Contact instance admin about a possible bug in script definition. DETAILS: " + e.getMessage(), e);
            }
            throw UserFailureExceptionTranslator.translate(e, MANAGED_PROPERTY_UPDATE_ERROR_MSG);
        }
    }

    @Override
    public List<DatastoreServiceDescription> listDataStoreServices(DataStoreServiceKind dataStoreServiceKind) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.listDataStoreServices(sessionToken, dataStoreServiceKind);
    }

    @Override
    public TableModelReference createReportFromDatasets(DatastoreServiceDescription serviceDescription, DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria) {
        String sessionToken = this.getSessionToken();
        DatastoreServiceDescription desc = DatastoreServiceDescription.reporting(serviceDescription.getKey(), serviceDescription.getLabel(), serviceDescription.getDatasetTypeCodes(), null, serviceDescription.tryReportingPluginType());
        List<String> datasetCodes = this.extractDatasetCodes(displayedOrSelectedDatasetCriteria, desc);
        TableModel tableModel = this.commonServer.createReportFromDatasets(sessionToken, desc.getKey(), datasetCodes);
        String resultSetKey = this.saveReportInCache(tableModel);
        return new TableModelReference(resultSetKey, tableModel.getHeader());
    }

    @Override
    public TableModelReference createReportFromAggregationService(DatastoreServiceDescription serviceDescription, Map<String, Object> parameters) {
        String sessionToken = this.getSessionToken();
        TableModel tableModel = this.commonServer.createReportFromAggregationService(sessionToken, serviceDescription, parameters);
        String resultSetKey = this.saveReportInCache(tableModel);
        return new TableModelReference(resultSetKey, tableModel.getHeader());
    }

    @Override
    public TableModelReference createReportFromTableModel(TableModel tableModel) {
        ReflectingStringUnescaper.unescapeDeep(tableModel);
        String resultSetKey = this.saveReportInCache(tableModel);
        return new TableModelReference(resultSetKey, tableModel.getHeader());
    }

    @Override
    public TypedTableResultSet<ReportRowModel> listReport(IResultSetConfig<String, TableModelRowWithObject<ReportRowModel>> resultSetConfig) {
        IOriginalDataProvider<TableModelRowWithObject<ReportRowModel>> dataProvider = new IOriginalDataProvider<TableModelRowWithObject<ReportRowModel>>(){

            @Override
            public List<TableModelColumnHeader> getHeaders() {
                return null;
            }

            @Override
            public List<TableModelRowWithObject<ReportRowModel>> getOriginalData(int maxSize) throws ch.systemsx.cisd.common.exceptions.UserFailureException {
                throw new IllegalStateException("Data not found in the cache");
            }
        };
        return new TypedTableResultSet<ReportRowModel>(this.listEntities(resultSetConfig, dataProvider));
    }

    @Override
    public String prepareExportReport(TableExportCriteria<TableModelRowWithObject<ReportRowModel>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    private List<String> extractDatasetCodes(DisplayedCriteriaOrSelectedEntityHolder<TableModelRowWithObject<Experiment>> experimentCriteria) {
        List<Experiment> experiments = this.getReferencedExperiments(experimentCriteria);
        if (experiments == null) {
            return new ArrayList<String>();
        }
        DataSetRelatedEntities dataSetRelatedExperiments = new DataSetRelatedEntities(experiments);
        List<AbstractExternalData> relatedDataSets = this.commonServer.listRelatedDataSets(this.getSessionToken(), dataSetRelatedExperiments, false);
        return Code.extractCodes(relatedDataSets);
    }

    private List<Experiment> getReferencedExperiments(DisplayedCriteriaOrSelectedEntityHolder<TableModelRowWithObject<Experiment>> experimentCriteria) {
        List<TableModelRowWithObject<Experiment>> rows;
        if (experimentCriteria.hasSelectedItems()) {
            rows = experimentCriteria.tryGetSelectedItems();
        } else {
            TableExportCriteria<TableModelRowWithObject<Experiment>> displayedItemsCriteria = experimentCriteria.tryGetDisplayedItems();
            assert (displayedItemsCriteria != null) : "displayedItemsCriteria is null";
            rows = this.fetchCachedEntities(displayedItemsCriteria).extractOriginalObjects();
        }
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (TableModelRowWithObject<Experiment> row : rows) {
            experiments.add(row.getObjectOrNull());
        }
        return experiments;
    }

    private List<String> extractDatasetCodes(DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria) {
        return this.extractDatasetCodes(displayedOrSelectedDatasetCriteria, null);
    }

    private List<String> extractDatasetCodes(DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria, DatastoreServiceDescription serviceDescriptionOrNull) {
        if (displayedOrSelectedDatasetCriteria.tryGetSelectedItems() != null) {
            return displayedOrSelectedDatasetCriteria.tryGetSelectedItems();
        }
        TableExportCriteria<TableModelRowWithObject<AbstractExternalData>> displayedItemsCriteria = displayedOrSelectedDatasetCriteria.tryGetDisplayedItems();
        assert (displayedItemsCriteria != null) : "displayedItemsCriteria is null";
        List<TableModelRowWithObject<AbstractExternalData>> datasets = this.fetchCachedEntities(displayedItemsCriteria).extractOriginalObjects();
        if (serviceDescriptionOrNull != null) {
            datasets = CommonClientService.filterDatasets(datasets, serviceDescriptionOrNull);
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (TableModelRowWithObject<AbstractExternalData> row : datasets) {
            codes.add(row.getObjectOrNull().getCode());
        }
        return codes;
    }

    private static List<TableModelRowWithObject<AbstractExternalData>> filterDatasets(List<TableModelRowWithObject<AbstractExternalData>> datasets, DatastoreServiceDescription serviceDescription) {
        String[] datasetTypeCodes = serviceDescription.getDatasetTypeCodes();
        HashSet<String> datasetTypeCodesMap = new HashSet<String>(Arrays.asList(datasetTypeCodes));
        ArrayList<TableModelRowWithObject<AbstractExternalData>> result = new ArrayList<TableModelRowWithObject<AbstractExternalData>>();
        String serviceDatastoreCode = serviceDescription.getDatastoreCode();
        for (TableModelRowWithObject<AbstractExternalData> row : datasets) {
            AbstractExternalData dataset = row.getObjectOrNull();
            String datasetTypeCode = dataset.getDataSetType().getCode();
            if (!datasetTypeCodesMap.contains(datasetTypeCode)) continue;
            String datasetDatastoreCode = dataset.getDataStore().getCode();
            if (serviceDatastoreCode != null && !datasetDatastoreCode.equals(serviceDatastoreCode)) continue;
            result.add(row);
        }
        return result;
    }

    @Override
    public void processDatasets(DatastoreServiceDescription serviceDescription, DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria) {
        String sessionToken = this.getSessionToken();
        DatastoreServiceDescription desc = DatastoreServiceDescription.processing(serviceDescription.getKey(), serviceDescription.getLabel(), serviceDescription.getDatasetTypeCodes(), null);
        List<String> datasetCodes = this.extractDatasetCodes(displayedOrSelectedDatasetCriteria, desc);
        this.commonServer.processDatasets(sessionToken, desc, datasetCodes);
    }

    @Override
    public ArchivingResult archiveDatasets(DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria, boolean removeFromDataStore) {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(displayedOrSelectedDatasetCriteria);
        int result = this.commonServer.archiveDatasets(sessionToken, datasetCodes, removeFromDataStore);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public ArchivingResult unarchiveDatasets(DisplayedOrSelectedDatasetCriteria displayedOrSelectedDatasetCriteria) {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(displayedOrSelectedDatasetCriteria);
        int result = this.commonServer.unarchiveDatasets(sessionToken, datasetCodes);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public void deleteAuthorizationGroups(List<TechId> groupIds, String reason) {
        String sessionToken = this.getSessionToken();
        this.commonServer.deleteAuthorizationGroups(sessionToken, groupIds, reason);
    }

    @Override
    public TypedTableResultSet<AuthorizationGroup> listAuthorizationGroups(DefaultResultSetConfig<String, TableModelRowWithObject<AuthorizationGroup>> resultSetConfig) {
        return this.listEntities(new AuthorizationGroupProvider(this.commonServer, this.getSessionToken()), resultSetConfig);
    }

    @Override
    public String prepareExportAuthorizationGroups(TableExportCriteria<TableModelRowWithObject<AuthorizationGroup>> exportCriteria) {
        return this.prepareExportEntities(exportCriteria);
    }

    @Override
    public void registerAuthorizationGroup(NewAuthorizationGroup newAuthorizationGroup) {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerAuthorizationGroup(sessionToken, newAuthorizationGroup);
    }

    @Override
    public void registerScript(Script script) {
        String sessionToken = this.getSessionToken();
        this.commonServer.registerScript(sessionToken, script);
    }

    @Override
    public List<Person> listPersonsInAuthorizationGroup(TechId group) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.listPersonInAuthorizationGroup(sessionToken, group);
    }

    @Override
    public void updateAuthorizationGroup(AuthorizationGroupUpdates updates) {
        assert (updates != null) : "Unspecified updates.";
        String sessionToken = this.getSessionToken();
        this.commonServer.updateAuthorizationGroup(sessionToken, updates);
    }

    @Override
    public void addPersonsToAuthorizationGroup(TechId authorizationGroupId, List<String> personsCodes) {
        String sessionToken = this.getSessionToken();
        this.commonServer.addPersonsToAuthorizationGroup(sessionToken, authorizationGroupId, personsCodes);
    }

    @Override
    public void removePersonsFromAuthorizationGroup(TechId authorizationGroupId, List<String> personsCodes) {
        String sessionToken = this.getSessionToken();
        this.commonServer.removePersonsFromAuthorizationGroup(sessionToken, authorizationGroupId, personsCodes);
    }

    private <T extends IIdHolder> List<TechId> extractTechIds(DisplayedOrSelectedIdHolderCriteria<T> displayedOrSelectedEntitiesCriteria) {
        if (displayedOrSelectedEntitiesCriteria.tryGetSelectedItems() != null) {
            return displayedOrSelectedEntitiesCriteria.tryGetSelectedItems();
        }
        TableExportCriteria<T> displayedItemsCriteria = displayedOrSelectedEntitiesCriteria.tryGetDisplayedItems();
        assert (displayedItemsCriteria != null) : "displayedItemsCriteria is null";
        List<T> entities = this.fetchCachedEntities(displayedItemsCriteria).extractOriginalObjects();
        ArrayList<TechId> ids = new ArrayList();
        for (IIdHolder entity : entities) {
            TableModelRowWithObject row;
            Object object;
            if (!(entity instanceof TableModelRowWithObject) || !((object = (row = (TableModelRowWithObject)entity).getObjectOrNull()) instanceof IIdHolder)) continue;
            ids.add(TechId.create((IIdHolder)object));
        }
        ids = TechId.createList(entities);
        return ids;
    }

    @Override
    public List<GridCustomFilter> listFilters(String gridId) throws UserFailureException {
        return this.commonServer.listFilters(this.getSessionToken(), gridId);
    }

    @Override
    public TypedTableResultSet<GridCustomFilter> listFilters(String gridId, DefaultResultSetConfig<String, TableModelRowWithObject<GridCustomFilter>> resultSetConfig) throws UserFailureException {
        return this.listEntities(new GridCustomFilterProvider(this.commonServer, this.getSessionToken(), gridId), resultSetConfig);
    }

    @Override
    public String prepareExportFilters(TableExportCriteria<TableModelRowWithObject<GridCustomFilter>> criteria) throws UserFailureException {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public void registerFilter(NewColumnOrFilter filter) throws UserFailureException {
        assert (filter != null) : "Unspecified filter.";
        this.commonServer.registerFilter(this.getSessionToken(), filter);
    }

    @Override
    public void deleteFilters(List<TechId> filterIds) throws UserFailureException {
        this.commonServer.deleteFilters(this.getSessionToken(), filterIds);
    }

    @Override
    public final void updateFilter(IExpressionUpdates updates) throws UserFailureException {
        assert (updates != null) : "Unspecified updates.";
        this.commonServer.updateFilter(this.getSessionToken(), updates);
    }

    @Override
    public List<GridCustomColumn> listGridCustomColumns(String gridId) throws UserFailureException {
        return this.commonServer.listGridCustomColumns(this.getSessionToken(), gridId);
    }

    @Override
    public TypedTableResultSet<GridCustomColumn> listGridCustomColumns(String gridId, DefaultResultSetConfig<String, TableModelRowWithObject<GridCustomColumn>> resultSetConfig) throws UserFailureException {
        return this.listEntities(new CustomGridColumnProvider(this.commonServer, this.getSessionToken(), gridId), resultSetConfig);
    }

    @Override
    public String prepareExportColumns(TableExportCriteria<TableModelRowWithObject<GridCustomColumn>> criteria) throws UserFailureException {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public void registerColumn(NewColumnOrFilter newColumn) throws UserFailureException {
        assert (newColumn != null) : "Unspecified grid custom column.";
        this.commonServer.registerGridCustomColumn(this.getSessionToken(), newColumn);
    }

    @Override
    public void deleteColumns(List<TechId> columnIds) throws UserFailureException {
        this.commonServer.deleteGridCustomColumns(this.getSessionToken(), columnIds);
    }

    @Override
    public void updateColumn(IExpressionUpdates updates) throws UserFailureException {
        assert (updates != null) : "Unspecified grid custom updates.";
        this.commonServer.updateGridCustomColumn(this.getSessionToken(), updates);
    }

    @Override
    public Boolean keepSessionAlive() throws UserFailureException {
        try {
            this.commonServer.keepSessionAlive(this.getSessionToken());
            return true;
        }
        catch (InvalidSessionException invalidSessionException) {
            return false;
        }
    }

    @Override
    public void updateVocabularyTerms(String termsSessionKey, TechId vocabularyId) throws UserFailureException {
        assert (vocabularyId != null) : "Unspecified vocabulary.";
        String sessionToken = this.getSessionToken();
        List<VocabularyTerm> extractedTerms = this.extractVocabularyTermsFromUploadedData(termsSessionKey, BatchOperationKind.UPDATE);
        this.commonServer.updateVocabularyTerms(sessionToken, vocabularyId, extractedTerms);
    }

    @Override
    public void deleteMaterials(DisplayedOrSelectedIdHolderCriteria<TableModelRowWithObject<Material>> criteria, String reason) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<TechId> materialIds = this.extractTechIds(criteria);
        this.commonServer.deleteMaterials(sessionToken, materialIds, reason);
    }

    @Override
    public ArchivingResult lockDatasets(DisplayedOrSelectedDatasetCriteria criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(criteria);
        int result = this.commonServer.lockDatasets(sessionToken, datasetCodes);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public ArchivingResult unlockDatasets(DisplayedOrSelectedDatasetCriteria criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(criteria);
        int result = this.commonServer.unlockDatasets(sessionToken, datasetCodes);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public LinkModel retrieveLinkFromDataSet(DatastoreServiceDescription serviceDescription, String dataSetCode) {
        String sessionToken = this.getSessionToken();
        LinkModel url = this.commonServer.retrieveLinkFromDataSet(sessionToken, serviceDescription, dataSetCode);
        return url;
    }

    @Override
    public Script getScriptInfo(TechId scriptId) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        Script script = this.commonServer.getScriptInfo(sessionToken, scriptId);
        return script;
    }

    @Override
    public String evaluate(DynamicPropertyEvaluationInfo info) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.evaluate(sessionToken, info);
    }

    @Override
    public String evaluate(EntityValidationEvaluationInfo info) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.evaluate(sessionToken, info);
    }

    @Override
    public IEntityInformationHolderWithPermId getEntityInformationHolder(BasicEntityDescription info) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.commonServer.getEntityInformationHolder(sessionToken, info);
    }

    @Override
    public ArchivingResult archiveDatasets(DisplayedCriteriaOrSelectedEntityHolder<TableModelRowWithObject<Experiment>> criteria, boolean removeFromDataStore) {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(criteria);
        int result = this.commonServer.archiveDatasets(sessionToken, datasetCodes, removeFromDataStore);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public ArchivingResult unarchiveDatasets(DisplayedCriteriaOrSelectedEntityHolder<TableModelRowWithObject<Experiment>> criteria) {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(criteria);
        int result = this.commonServer.unarchiveDatasets(sessionToken, datasetCodes);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public ArchivingResult lockDatasets(DisplayedCriteriaOrSelectedEntityHolder<TableModelRowWithObject<Experiment>> criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(criteria);
        int result = this.commonServer.lockDatasets(sessionToken, datasetCodes);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public ArchivingResult unlockDatasets(DisplayedCriteriaOrSelectedEntityHolder<TableModelRowWithObject<Experiment>> criteria) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        List<String> datasetCodes = this.extractDatasetCodes(criteria);
        int result = this.commonServer.unlockDatasets(sessionToken, datasetCodes);
        return new ArchivingResult(datasetCodes.size(), result);
    }

    @Override
    public EntityPropertyUpdatesResult updateProperties(EntityPropertyUpdates updates) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        IResultSetManager<String> resultSetManager = this.getResultSetManager();
        resultSetManager.lockResultSet(updates.getResultSetKey());
        EntityKind entityKind = updates.getEntityKind();
        TechId entityId = updates.getEntityId();
        List<PropertyUpdates> modifiedProperties = updates.getModifiedProperties();
        EntityPropertyUpdatesResult result = new EntityPropertyUpdatesResult();
        try {
            switch (entityKind) {
                case DATA_SET: {
                    this.commonServer.updateDataSetProperties(sessionToken, entityId, modifiedProperties);
                    break;
                }
                case EXPERIMENT: {
                    this.commonServer.updateExperimentProperties(sessionToken, entityId, modifiedProperties);
                    break;
                }
                case MATERIAL: {
                    this.commonServer.updateMaterialProperties(sessionToken, entityId, modifiedProperties);
                    break;
                }
                case SAMPLE: {
                    this.commonServer.updateSampleProperties(sessionToken, entityId, modifiedProperties);
                }
            }
        }
        catch (ch.systemsx.cisd.common.exceptions.UserFailureException e) {
            result.setErrorMessage(UserFailureExceptionTranslator.translate(e).getMessage());
        }
        return result;
    }

    @Override
    public TypedTableResultSet<Deletion> listDeletions(DefaultResultSetConfig<String, TableModelRowWithObject<Deletion>> criteria) throws UserFailureException {
        DeletionsProvider deletionsProvider = new DeletionsProvider(this.commonServer, this.getSessionToken());
        return this.listEntities(deletionsProvider, criteria);
    }

    @Override
    public void revertDeletions(List<TechId> deletionIds) throws UserFailureException {
        try {
            this.commonServer.revertDeletions(this.getSessionToken(), deletionIds);
        }
        catch (ch.systemsx.cisd.common.exceptions.UserFailureException ex) {
            throw new UserFailureException(String.valueOf(ex.getMessage()) + "\n\nTry reverting the dependent deletion first.");
        }
    }

    @Override
    public void deletePermanently(List<TechId> deletionIds, boolean forceDisallowedTypes) throws UserFailureException {
        if (forceDisallowedTypes) {
            this.commonServer.deletePermanentlyForced(this.getSessionToken(), deletionIds);
        } else {
            this.commonServer.deletePermanently(this.getSessionToken(), deletionIds);
        }
    }

    @Override
    public void emptyTrash(boolean forceDisallowedTypes) throws UserFailureException {
        List<Deletion> deletions = this.commonServer.listDeletions(this.getSessionToken(), false);
        this.deletePermanently(TechId.createList(deletions), forceDisallowedTypes);
    }

    @Override
    public String performCustomImport(String sessionKey, String customImportCode) {
        HttpSession httpSession = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = (UploadedFilesBean)httpSession.getAttribute(sessionKey);
            CommonClientService.abortIfMaxSizeExceeded(uploadedFiles);
            String string = this.commonServer.performCustomImport(this.getSessionToken(), customImportCode, CommonClientService.getCustomImportFile(uploadedFiles));
            return string;
        }
        catch (ch.systemsx.cisd.common.exceptions.UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getEndOfChain(e).getMessage();
            throw new UserFailureException(String.valueOf(this.extractStackTraces(message)) + " (More details can be found in the server logs.)");
        }
        finally {
            if (uploadedFiles != null) {
                uploadedFiles.deleteTransferredFiles();
            }
            if (httpSession != null) {
                httpSession.removeAttribute(sessionKey);
            }
        }
    }

    @Override
    public void sendCountActiveUsersEmail() {
        this.commonServer.sendCountActiveUsersEmail(this.getSessionToken());
    }

    private String extractStackTraces(String message) {
        String[] lines = message.split("\n");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.startsWith("\tat ")) {
                if (builder.length() > 0) {
                    builder.append('\n');
                }
                builder.append(line);
            }
            ++n2;
        }
        return builder.toString();
    }

    private static void abortIfMaxSizeExceeded(UploadedFilesBean uploadedFiles) {
        if (uploadedFiles != null) {
            for (IUncheckedMultipartFile multipartFile : uploadedFiles.iterable()) {
                long fileSize = multipartFile.getSize();
                if (fileSize <= 0x40000000L) continue;
                String maxSizeString = FileUtilities.byteCountToDisplaySize(0x40000000L);
                String fileSizeString = FileUtilities.byteCountToDisplaySize(fileSize);
                String errorMessage = String.format("The file %s(%s) is larger than the maximum (%s).", multipartFile.getOriginalFilename(), fileSizeString, maxSizeString);
                throw new ch.systemsx.cisd.common.exceptions.UserFailureException(errorMessage);
            }
        }
    }

    private static CustomImportFile getCustomImportFile(UploadedFilesBean uploadedFiles) {
        if (uploadedFiles != null) {
            if (uploadedFiles.size() != 1) {
                throw new ch.systemsx.cisd.common.exceptions.UserFailureException(String.format("Expecting exactly one file, but %s found.", uploadedFiles.size()));
            }
            Iterator<IUncheckedMultipartFile> iterator = uploadedFiles.iterable().iterator();
            if (iterator.hasNext()) {
                IUncheckedMultipartFile multipartFile = iterator.next();
                String fileName = multipartFile.getOriginalFilename();
                byte[] content = multipartFile.getBytes();
                return new CustomImportFile(fileName, content);
            }
        }
        return null;
    }

    @Override
    public void assignEntitiesToMetaProjects(EntityKind entityKind, List<Long> metaProjectIds, List<Long> entityIds) {
        MetaprojectAssignmentsIds ids = new MetaprojectAssignmentsIds();
        for (Long id : entityIds) {
            this.addId(entityKind, id, ids);
        }
        for (Long metaProjectId : metaProjectIds) {
            this.commonServer.addToMetaproject(this.getSessionToken(), new MetaprojectTechIdId(metaProjectId), ids);
        }
    }

    @Override
    public void removeEntitiesFromMetaProjects(EntityKind entityKind, List<Long> metaProjectIds, List<Long> entityIds) {
        MetaprojectAssignmentsIds ids = new MetaprojectAssignmentsIds();
        for (Long id : entityIds) {
            this.addId(entityKind, id, ids);
        }
        for (Long metaProjectId : metaProjectIds) {
            this.commonServer.removeFromMetaproject(this.getSessionToken(), new MetaprojectTechIdId(metaProjectId), ids);
        }
    }

    private void addId(EntityKind entityKind, Long id, MetaprojectAssignmentsIds assignments) {
        if (EntityKind.MATERIAL.equals(entityKind)) {
            assignments.addMaterial(new MaterialTechIdId(id));
        } else if (EntityKind.DATA_SET.equals(entityKind)) {
            assignments.addDataSet(new DataSetTechIdId(id));
        } else if (EntityKind.SAMPLE.equals(entityKind)) {
            assignments.addSample(new SampleTechIdId(id));
        } else if (EntityKind.EXPERIMENT.equals(entityKind)) {
            assignments.addExperiment(new ExperimentTechIdId(id));
        } else {
            throw new IllegalArgumentException("Unknown entity kind " + entityKind);
        }
    }

    @Override
    public void registerMetaProject(String name) throws UserFailureException {
        Metaproject metaproject = new Metaproject();
        metaproject.setName(name);
        this.commonServer.registerMetaproject(this.getSessionToken(), metaproject);
    }

    @Override
    public List<String> listPredeployedPlugins(ScriptType scriptType) {
        return this.commonServer.listPredeployedPlugins(this.getSessionToken(), scriptType);
    }

    @Override
    public String getDisabledText() {
        return this.commonServer.getDisabledText();
    }

    private class VocabularyTermsExtractor {
        private List<VocabularyTerm> terms;
        private final BatchOperationKind operationKind;

        private VocabularyTermsExtractor(BatchOperationKind operationKind) {
            this.operationKind = operationKind;
        }

        public List<VocabularyTerm> getTerms() {
            return this.terms;
        }

        public VocabularyTermsExtractor prepareTerms(String sessionKey) {
            HttpSession session = null;
            UploadedFilesBean uploadedFiles = null;
            try {
                session = CommonClientService.this.getHttpSession();
                assert (session.getAttribute(sessionKey) != null && session.getAttribute(sessionKey) instanceof UploadedFilesBean) : String.format("No UploadedFilesBean object as session attribute '%s' found.", sessionKey);
                uploadedFiles = (UploadedFilesBean)session.getAttribute(sessionKey);
                BisTabFileLoader<VocabularyTerm> tabFileLoader = this.createTermsLoader();
                this.terms = this.loadTermsFromFiles(uploadedFiles, tabFileLoader);
                VocabularyTermsExtractor vocabularyTermsExtractor = this;
                return vocabularyTermsExtractor;
            }
            finally {
                if (uploadedFiles != null) {
                    uploadedFiles.deleteTransferredFiles();
                }
                if (session != null) {
                    session.removeAttribute(sessionKey);
                }
            }
        }

        private BisTabFileLoader<VocabularyTerm> createTermsLoader() {
            BisTabFileLoader<VocabularyTerm> tabFileLoader = new BisTabFileLoader<VocabularyTerm>(new IParserObjectFactoryFactory<VocabularyTerm>(){

                @Override
                public final IParserObjectFactory<VocabularyTerm> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                    switch (VocabularyTermsExtractor.this.operationKind) {
                        case REGISTRATION: {
                            return new VocabularyTermObjectFactory(propertyMapper);
                        }
                        case UPDATE: {
                            return new UpdatedVocabularyTermObjectFactory(propertyMapper);
                        }
                    }
                    throw new UnsupportedOperationException(VocabularyTermsExtractor.this.operationKind + " is not supported");
                }
            }, false);
            return tabFileLoader;
        }

        private List<VocabularyTerm> loadTermsFromFiles(UploadedFilesBean uploadedFiles, BisTabFileLoader<VocabularyTerm> tabFileLoader) {
            ArrayList<VocabularyTerm> results = new ArrayList<VocabularyTerm>();
            for (IUncheckedMultipartFile multipartFile : uploadedFiles.iterable()) {
                Reader reader = UnicodeUtils.createReader(multipartFile.getInputStream());
                Map<String, String> defaults = Collections.emptyMap();
                List<VocabularyTerm> loadedTerms = tabFileLoader.load(new DelegatedReader(reader, multipartFile.getOriginalFilename()), defaults);
                results.addAll(loadedTerms);
            }
            Long order = 1L;
            for (VocabularyTerm term : results) {
                Long l = order;
                order = l + 1L;
                term.setOrdinal(l);
            }
            return results;
        }

        private class UpdatedVocabularyTermObjectFactory
        extends AbstractParserObjectFactory<VocabularyTerm> {
            private final VocabularyTermBatchUpdateDetails basicBatchUpdateDetails;

            protected UpdatedVocabularyTermObjectFactory(IPropertyMapper propertyMapper) {
                super(VocabularyTerm.class, propertyMapper);
                this.basicBatchUpdateDetails = this.createBasicBatchUpdateDetails();
            }

            private VocabularyTermBatchUpdateDetails createBasicBatchUpdateDetails() {
                boolean updateLabel = this.isColumnAvailable("label");
                boolean updateDescription = this.isColumnAvailable("description");
                return new VocabularyTermBatchUpdateDetails(updateLabel, updateDescription);
            }

            @Override
            public VocabularyTerm createObject(String[] lineTokens) throws ParserException {
                VocabularyTerm term = (VocabularyTerm)super.createObject(lineTokens);
                VocabularyTermBatchUpdateDetails updateDetails = this.createBatchUpdateDetails(term);
                this.cleanUp(term);
                return new UpdatedVocabularyTerm(term, updateDetails);
            }

            private VocabularyTermBatchUpdateDetails createBatchUpdateDetails(VocabularyTerm term) {
                boolean updateLabel = this.basicBatchUpdateDetails.isLabelUpdateRequested() && UpdatedVocabularyTermObjectFactory.isNotEmpty(term.getLabel());
                boolean updateDescription = this.basicBatchUpdateDetails.isDescriptionUpdateRequested() && UpdatedVocabularyTermObjectFactory.isNotEmpty(term.getDescription());
                return new VocabularyTermBatchUpdateDetails(updateLabel, updateDescription);
            }

            private void cleanUp(VocabularyTerm term) {
                if (UpdatedVocabularyTermObjectFactory.isDeletionMark(term.getLabel())) {
                    term.setLabel(null);
                }
                if (UpdatedVocabularyTermObjectFactory.isDeletionMark(term.getDescription())) {
                    term.setDescription(null);
                }
            }
        }

        private class VocabularyTermObjectFactory
        extends AbstractParserObjectFactory<VocabularyTerm> {
            protected VocabularyTermObjectFactory(IPropertyMapper propertyMapper) {
                super(VocabularyTerm.class, propertyMapper);
            }
        }
    }
}

