/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.collection.ExtendedLinkedBlockingQueue;
import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.DefaultFullTextIndexer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.HibernateSearchContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdater;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexMode;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexUpdateOperation;
import java.io.File;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public final class FullTextIndexUpdater
extends HibernateDaoSupport
implements IFullTextIndexUpdater {
    public static final String FULL_TEXT_INDEX_UPDATER_QUEUE_FILENAME = ".index_updater_queue";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FullTextIndexUpdater.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, FullTextIndexUpdater.class);
    private final HibernateSearchContext context;
    private final IFullTextIndexer fullTextIndexer;
    private final IExtendedBlockingQueue<IndexUpdateOperation> updaterQueue;

    public FullTextIndexUpdater(SessionFactory sessionFactory, HibernateSearchContext context) {
        assert (context != null) : "Unspecified hibernate search context.";
        this.setSessionFactory(sessionFactory);
        this.context = context;
        operationLog.debug(String.format("Hibernate search context: %s.", context));
        this.fullTextIndexer = new DefaultFullTextIndexer(context.getBatchSize());
        IndexMode indexMode = context.getIndexMode();
        if (indexMode == IndexMode.NO_INDEX) {
            operationLog.info(String.format("'%s' mode was configured. Updater tasks will not be persisted", new Object[]{indexMode}));
            this.updaterQueue = new ExtendedLinkedBlockingQueue<IndexUpdateOperation>();
            return;
        }
        File indexBase = new File(context.getIndexBase());
        File queueFile = FullTextIndexUpdater.getUpdaterQueueFile(indexBase);
        operationLog.debug(String.format("Updater queue file: %s.", queueFile));
        this.updaterQueue = FullTextIndexUpdater.createUpdaterQueue(indexBase, queueFile);
    }

    public int getQueueSize() {
        return this.updaterQueue.size();
    }

    private static IExtendedBlockingQueue<IndexUpdateOperation> createUpdaterQueue(File indexBase, File queueFile) {
        try {
            return PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
        }
        catch (RuntimeException e) {
            String newFileName = ".index_updater_queue_" + System.currentTimeMillis();
            notificationLog.error(String.format("%s.\n Renaming '%s' to '%s' and using an empty queue file. Restart server with the queue that caused the problem or force reindex of all entities.", e.getMessage(), queueFile, newFileName));
            queueFile.renameTo(new File(indexBase, newFileName));
            return PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
        }
    }

    private static File getUpdaterQueueFile(File indexBase) {
        return new File(indexBase, FULL_TEXT_INDEX_UPDATER_QUEUE_FILENAME);
    }

    @Override
    public void start() {
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Starting updater thread with queue size: " + this.updaterQueue.size());
        }
        Thread thread = new Thread((Runnable)new FullTextIndexUpdaterRunnable(), "Full Text Index Updater");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void clear() {
        this.updaterQueue.clear();
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Cleared updater queue.");
        }
    }

    @Override
    public void scheduleUpdate(IndexUpdateOperation operation) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Scheduling update: " + operation);
        }
        this.updaterQueue.add(operation);
    }

    private class FullTextIndexUpdaterRunnable
    implements Runnable {
        private FullTextIndexUpdaterRunnable() {
        }

        @Override
        public final void run() {
            IndexMode indexMode = FullTextIndexUpdater.this.context.getIndexMode();
            if (indexMode == IndexMode.NO_INDEX) {
                operationLog.info(String.format("Stopping index updater process as  '%s' mode was configured.", new Object[]{indexMode}));
                return;
            }
            try {
                while (true) {
                    block20: {
                        IndexUpdateOperation operation = (IndexUpdateOperation)FullTextIndexUpdater.this.updaterQueue.peekWait();
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info("Update: " + operation);
                        }
                        StopWatch stopWatch = new StopWatch();
                        stopWatch.start();
                        Session session = null;
                        try {
                            try {
                                Class<?> clazz = Class.forName(operation.getClassName());
                                session = FullTextIndexUpdater.this.getSession();
                                switch (operation.getOperationKind()) {
                                    case REINDEX: {
                                        FullTextIndexUpdater.this.fullTextIndexer.doFullTextIndexUpdate(session, clazz, operation.getIds());
                                        break;
                                    }
                                    case REMOVE: {
                                        FullTextIndexUpdater.this.fullTextIndexer.removeFromIndex(session, clazz, operation.getIds());
                                    }
                                }
                                stopWatch.stop();
                            }
                            catch (RuntimeException e) {
                                notificationLog.error("Error: " + operation + ".", e);
                                if (session != null) {
                                    FullTextIndexUpdater.this.releaseSession(session);
                                }
                                if (operationLog.isInfoEnabled()) {
                                    operationLog.info((Object)((Object)operation.getOperationKind()) + " of " + operation.getIds().size() + " " + operation.getClassName() + "s took " + stopWatch);
                                }
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            if (session != null) {
                                FullTextIndexUpdater.this.releaseSession(session);
                            }
                            if (operationLog.isInfoEnabled()) {
                                operationLog.info((Object)((Object)operation.getOperationKind()) + " of " + operation.getIds().size() + " " + operation.getClassName() + "s took " + stopWatch);
                            }
                            throw throwable;
                        }
                        if (session != null) {
                            FullTextIndexUpdater.this.releaseSession(session);
                        }
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info((Object)((Object)operation.getOperationKind()) + " of " + operation.getIds().size() + " " + operation.getClassName() + "s took " + stopWatch);
                        }
                    }
                    FullTextIndexUpdater.this.updaterQueue.take();
                }
            }
            catch (Throwable th) {
                notificationLog.error("A problem has occurred while updating index.", th);
                return;
            }
        }
    }
}

