/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationSchedulerWithQueue;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DynamicPropertyEvaluationMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DynamicPropertyEvaluationMaintenanceTask.class);
    private static final List<Class<? extends IEntityInformationWithPropertiesHolder>> entityClasses = new ArrayList<Class<? extends IEntityInformationWithPropertiesHolder>>();

    static {
        entityClasses.add(DataPE.class);
        entityClasses.add(ExperimentPE.class);
        entityClasses.add(MaterialPE.class);
        entityClasses.add(SamplePE.class);
    }

    @Override
    public void execute() {
        operationLog.info("execution started");
        IDynamicPropertyEvaluationScheduler scheduler = CommonServiceProvider.getDAOFactory().getPersistencyResources().getDynamicPropertyEvaluationScheduler();
        for (Class<? extends IEntityInformationWithPropertiesHolder> entityClass : entityClasses) {
            DynamicPropertyEvaluationOperation operation = DynamicPropertyEvaluationOperation.evaluateAll(entityClass);
            scheduler.scheduleUpdate(operation);
        }
        if (scheduler instanceof IDynamicPropertyEvaluationSchedulerWithQueue) {
            ((IDynamicPropertyEvaluationSchedulerWithQueue)scheduler).synchronizeThreadQueue();
        }
        operationLog.info("task executed");
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        operationLog.info("Task " + pluginName + " initialized.");
    }
}

