/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractASyncAction;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.MaterialHelper;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewDataSetsWithTypePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewExperimentsWithTypePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplesWithTypePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.UpdatedExperimentsWithTypePredicate;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialBatchUpdateResultMessage;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import ch.systemsx.cisd.openbis.plugin.generic.server.DataSetIdentifiersExtractor;
import ch.systemsx.cisd.openbis.plugin.generic.server.EntityExistenceChecker;
import ch.systemsx.cisd.openbis.plugin.generic.server.ExperimentBatchRegistration;
import ch.systemsx.cisd.openbis.plugin.generic.server.ExperimentBatchUpdate;
import ch.systemsx.cisd.openbis.plugin.generic.server.GenericServerLogger;
import ch.systemsx.cisd.openbis.plugin.generic.server.IGenericBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.generic.server.IdentifersExtractor;
import ch.systemsx.cisd.openbis.plugin.generic.server.NormalizedSampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="generic-plugin-server")
public final class GenericServer
extends AbstractServer<IGenericServer>
implements IGenericServer {
    @Resource(name="generic-business-object-factory")
    private IGenericBusinessObjectFactory businessObjectFactory;
    @Resource(name="common-server")
    protected ICommonServer commonServer;
    @Resource(name="generic-plugin-server")
    private IGenericServer genericServer;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public GenericServer() {
    }

    @Private
    GenericServer(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, IGenericBusinessObjectFactory businessObjectFactory, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        super(sessionManager, daoFactory, propertiesBatchManager, sampleTypeSlaveServerPlugin, dataSetTypeSlaveServerPlugin);
        this.businessObjectFactory = businessObjectFactory;
    }

    @Override
    public IGenericServer createLogger(IInvocationLoggerContext context) {
        return new GenericServerLogger(this.getSessionManager(), context);
    }

    public final SampleParentWithDerived getSampleInfo(String sessionToken, SampleIdentifier identifier) {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (identifier != null) : "Unspecified sample identifier.";
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadBySampleIdentifier(identifier);
        sampleBO.enrichWithAttachments();
        sampleBO.enrichWithPropertyTypes();
        SamplePE sample = sampleBO.getSample();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), sample);
        return SampleTranslator.translate(this.getSampleTypeSlaveServerPlugin(sample.getSampleType()).getSampleInfo(session, sample), session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public SampleParentWithDerived getSampleInfo(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId) throws UserFailureException {
        return this.commonServer.getSampleInfo(sessionToken, sampleId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void registerSample(String sessionToken, @AuthorizationGuard(guardClass=NewSamplePredicate.class) NewSample newSample, Collection<NewAttachment> attachments) {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (newSample != null) : "Unspecified new sample.";
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        newSample.setAttachments(new ArrayList<NewAttachment>(attachments));
        sampleBO.define(newSample);
        sampleBO.save();
    }

    public Experiment getExperimentInfo(String sessionToken, ExperimentIdentifier identifier) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(identifier);
        experimentBO.enrichWithProperties();
        experimentBO.enrichWithAttachments();
        ExperimentPE experiment = experimentBO.getExperiment();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), experiment);
        if (experiment == null) {
            throw UserFailureException.fromTemplate("No experiment could be found with given identifier '%s'.", identifier);
        }
        return ExperimentTranslator.translate(experiment, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES, ExperimentTranslator.LoadableFields.ATTACHMENTS);
    }

    public Experiment getExperimentInfo(String sessionToken, TechId experimentId) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        experimentBO.enrichWithProperties();
        experimentBO.enrichWithAttachments();
        ExperimentPE experiment = experimentBO.getExperiment();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), experiment);
        return ExperimentTranslator.translate(experiment, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES, ExperimentTranslator.LoadableFields.ATTACHMENTS);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AbstractExternalData getDataSetInfo(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId datasetId) {
        return this.commonServer.getDataSetInfo(sessionToken, datasetId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AttachmentWithContent getExperimentFileAttachment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, String filename, Integer versionOrNull) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        return AttachmentTranslator.translateWithContent(experimentBO.getExperimentFileAttachment(filename, versionOrNull));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE")
    public void registerOrUpdateSamples(String sessionToken, @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> newSamplesWithType) throws UserFailureException {
        this.registerOrUpdateSamplesAndMaterials(sessionToken, newSamplesWithType, Collections.<NewMaterialsWithTypes>emptyList());
    }

    private void privateRegisterOrUpdateSamples(String sessionToken, @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> newSamplesWithType) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        for (NewSamplesWithTypes samples : newSamplesWithType) {
            if (!samples.isAllowUpdateIfExist()) {
                this.registerSamples(session, samples, session.tryGetPerson());
                continue;
            }
            SampleBatchRegisterOrUpdate sampleBatchOperation = this.createSampleBatchOperation(session, samples);
            BatchOperationExecutor.executeInBatches(sampleBatchOperation);
        }
    }

    private SampleBatchRegisterOrUpdate createSampleBatchOperation(Session session, NewSamplesWithTypes samples) {
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(session);
        return new SampleBatchRegisterOrUpdate(sampleLister, samples.getNewEntities(), (SampleType)samples.getEntityType(), session);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE")
    public void registerSamples(String sessionToken, @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> newSamplesWithType) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        for (NewSamplesWithTypes samples : newSamplesWithType) {
            this.registerSamples(session, samples, session.tryGetPerson());
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE")
    public void updateSamples(String sessionToken, @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> newSamplesWithType) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        for (NewSamplesWithTypes samples : newSamplesWithType) {
            this.updateSamples(session, samples);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_DATASET")
    public void updateDataSets(String sessionToken, @AuthorizationGuard(guardClass=NewDataSetsWithTypePredicate.class) NewDataSetsWithTypes dataSets) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        List<NewDataSet> newDataSets = dataSets.getNewDataSets();
        if (newDataSets.size() == 0) {
            return;
        }
        ServerUtils.prevalidate(newDataSets, "data set");
        DataSetTypePE dataSetType = this.getDAOFactory().getDataSetTypeDAO().tryToFindDataSetTypeByCode(dataSets.getDataSetType().getCode());
        if (dataSetType == null) {
            throw UserFailureException.fromTemplate("Data set type with code '%s' does not exist.", dataSets.getDataSetType());
        }
        this.getPropertiesBatchManager().manageProperties(dataSetType, newDataSets, session.tryGetPerson());
        this.getDataSetTypeSlaveServerPlugin(dataSetType).updateDataSets(session, this.convertDataSets(newDataSets));
    }

    private void updateSamples(Session session, NewSamplesWithTypes updatedSamplesWithType) {
        SampleType sampleType = (SampleType)updatedSamplesWithType.getEntityType();
        List<NewSample> updatedSamples = updatedSamplesWithType.getNewEntities();
        assert (sampleType != null) : "Unspecified sample type.";
        assert (updatedSamples != null) : "Unspecified new samples.";
        if (updatedSamples.size() == 0) {
            return;
        }
        GenericServer.fillHomeSpace(updatedSamples, session.tryGetHomeGroupCode());
        ServerUtils.prevalidate(updatedSamples, "sample");
        String sampleTypeCode = sampleType.getCode();
        SampleTypePE sampleTypePE = this.getDAOFactory().getSampleTypeDAO().tryFindSampleTypeByCode(sampleTypeCode);
        if (sampleTypePE == null) {
            throw UserFailureException.fromTemplate("Sample type with code '%s' does not exist.", sampleTypeCode);
        }
        this.getPropertiesBatchManager().manageProperties(sampleTypePE, updatedSamples, session.tryGetPerson());
        this.getSampleTypeSlaveServerPlugin(sampleTypePE).updateSamples(session, this.convertSamples(updatedSamples));
    }

    private List<SampleBatchUpdatesDTO> convertSamples(List<NewSample> updatedSamples) {
        ArrayList<SampleBatchUpdatesDTO> samples = new ArrayList<SampleBatchUpdatesDTO>();
        for (NewSample updatedSample : updatedSamples) {
            IdentifersExtractor extractor = new IdentifersExtractor(updatedSample);
            List<IEntityProperty> properties = Arrays.asList(updatedSample.getProperties());
            String[] parentsOrNull = updatedSample.getParentsOrNull();
            SampleBatchUpdateDetails batchUpdateDetails = this.createBatchUpdateDetails(updatedSample);
            samples.add(new SampleBatchUpdatesDTO(updatedSample.getDefaultSpaceIdentifier(), extractor.getOldSampleIdentifier(), properties, extractor.getExperimentIdentifierOrNull(), extractor.getNewSampleIdentifier(), extractor.getContainerIdentifierOrNull(), parentsOrNull, batchUpdateDetails));
        }
        return samples;
    }

    private List<DataSetBatchUpdatesDTO> convertDataSets(List<NewDataSet> updatedDataSets) {
        ArrayList<DataSetBatchUpdatesDTO> dataSets = new ArrayList<DataSetBatchUpdatesDTO>();
        for (NewDataSet updatedDataSet : updatedDataSets) {
            DataSetBatchUpdatesDTO dataSet = new DataSetBatchUpdatesDTO();
            DataSetIdentifiersExtractor extractor = new DataSetIdentifiersExtractor(updatedDataSet);
            dataSet.setDatasetCode(updatedDataSet.getCode());
            dataSet.setExperimentIdentifierOrNull(extractor.getExperimentIdentifierOrNull());
            dataSet.setSampleIdentifierOrNull(extractor.getSampleIdentifierOrNull());
            dataSet.setProperties(Arrays.asList(updatedDataSet.getProperties()));
            dataSet.setModifiedContainerDatasetCodeOrNull(updatedDataSet.getContainerIdentifierOrNull());
            dataSet.setModifiedParentDatasetCodesOrNull(updatedDataSet.getParentsIdentifiersOrNull());
            dataSet.setFileFormatTypeCode(updatedDataSet.getFileFormatOrNull());
            dataSet.setDetails(this.createBatchUpdateDetails(updatedDataSet));
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    SampleBatchUpdateDetails createBatchUpdateDetails(NewSample sample) {
        if (sample instanceof UpdatedSample) {
            return ((UpdatedSample)sample).getBatchUpdateDetails();
        }
        IEntityProperty[] properties = sample.getProperties();
        HashSet<String> propertyCodes = new HashSet<String>();
        IEntityProperty[] iEntityPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IEntityProperty p = iEntityPropertyArray[n2];
            propertyCodes.add(p.getPropertyType().getCode());
            ++n2;
        }
        SampleBatchUpdateDetails result = new SampleBatchUpdateDetails(false, false, false, propertyCodes);
        return result;
    }

    DataSetBatchUpdateDetails createBatchUpdateDetails(NewDataSet dataSet) {
        if (dataSet instanceof UpdatedDataSet) {
            return ((UpdatedDataSet)dataSet).getBatchUpdateDetails();
        }
        IEntityProperty[] properties = dataSet.getProperties();
        HashSet<String> propertyCodes = new HashSet<String>();
        IEntityProperty[] iEntityPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IEntityProperty p = iEntityPropertyArray[n2];
            propertyCodes.add(p.getPropertyType().getCode());
            ++n2;
        }
        DataSetBatchUpdateDetails result = new DataSetBatchUpdateDetails();
        result.setPropertiesToUpdate(propertyCodes);
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE")
    public void registerExperiment(String sessionToken, @AuthorizationGuard(guardClass=NewExperimentPredicate.class) NewExperiment newExperiment, Collection<NewAttachment> attachments) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (newExperiment != null) : "Unspecified new experiment.";
        Session session = this.getSession(sessionToken);
        List<NewSamplesWithTypes> newSamples = newExperiment.getNewSamples();
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        newExperiment.setAttachments(new ArrayList<NewAttachment>(attachments));
        experimentBO.define(newExperiment);
        experimentBO.save();
        ExperimentPE experiment = experimentBO.getExperiment();
        String experimentSpace = experiment.getProject().getSpace().getCode();
        if (newExperiment.isRegisterSamples()) {
            for (NewSamplesWithTypes newSamplesWithType : newSamples) {
                List newEntities = newSamplesWithType.getNewEntities();
                for (NewSample newSample : newEntities) {
                    newSample.setDefaultSpaceIdentifier(new SpaceIdentifier(experimentSpace).toString());
                }
            }
            this.registerSamples(sessionToken, newSamples);
        }
        if (newExperiment.getSamples() != null && newExperiment.getSamples().length > 0) {
            List<SampleIdentifier> sampleIdentifiers = null;
            sampleIdentifiers = newSamples == null ? IdentifierHelper.extractSampleIdentifiers(newExperiment.getSamples(), null) : IdentifierHelper.extractSampleIdentifiers(newExperiment);
            for (SampleIdentifier si : sampleIdentifiers) {
                IdentifierHelper.fillAndCheckGroup(si, experimentSpace);
            }
            for (SampleIdentifier si : sampleIdentifiers) {
                ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
                sampleBO.loadBySampleIdentifier(si);
                sampleBO.setExperiment(experiment);
            }
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public void registerMaterials(String sessionToken, List<NewMaterialsWithTypes> newMaterials) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        MaterialHelper materialHelper = this.getMaterialHelper(session);
        for (NewMaterialsWithTypes m : newMaterials) {
            this.registerMaterials(materialHelper, m);
        }
    }

    private void registerMaterials(MaterialHelper materialHelper, NewMaterialsWithTypes materials) {
        materialHelper.registerMaterials(((MaterialType)materials.getEntityType()).getCode(), materials.getNewEntities());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public int updateMaterials(String sessionToken, List<NewMaterialsWithTypes> newMaterials, boolean ignoreUnregisteredMaterials) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        int count = 0;
        for (NewMaterialsWithTypes m : newMaterials) {
            count += this.getMaterialHelper(session).updateMaterials(((MaterialType)m.getEntityType()).getCode(), m.getNewEntities(), ignoreUnregisteredMaterials);
        }
        return count;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public void updateMaterialsAsync(final String sessionToken, final List<NewMaterialsWithTypes> newMaterials, final boolean ignoreUnregisteredMaterials, String userEmail) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        this.checkSession(sessionToken);
        this.executeASync(userEmail, new AbstractASyncAction(){

            @Override
            public String getName() {
                return "Material Batch Update";
            }

            @Override
            protected void doActionOrThrowException(Writer messageWriter) {
                try {
                    int updateCount = GenericServer.this.genericServer.updateMaterials(sessionToken, newMaterials, ignoreUnregisteredMaterials);
                    MaterialBatchUpdateResultMessage message = new MaterialBatchUpdateResultMessage(newMaterials, updateCount, ignoreUnregisteredMaterials);
                    messageWriter.write(message.toString());
                }
                catch (IOException e) {
                    CheckedExceptionTunnel.wrapIfNecessary(e);
                }
            }
        });
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AttachmentWithContent getProjectFileAttachment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId projectId, String fileName, Integer versionOrNull) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.loadDataByTechId(projectId);
        return AttachmentTranslator.translateWithContent(bo.getProjectFileAttachment(fileName, versionOrNull));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AttachmentWithContent getSampleFileAttachment(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId, String fileName, Integer versionOrNull) {
        Session session = this.getSession(sessionToken);
        ISampleBO bo = this.businessObjectFactory.createSampleBO(session);
        bo.loadDataByTechId(sampleId);
        return AttachmentTranslator.translateWithContent(bo.getSampleFileAttachment(fileName, versionOrNull));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> generateCodes(String sessionToken, String prefix, ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind entityKind, int number) {
        this.checkSession(sessionToken);
        return new EntityCodeGenerator(this.getDAOFactory()).generateCodes(prefix, entityKind, number);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE")
    public ExperimentUpdateResult updateExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExperimentUpdatesPredicate.class) ExperimentUpdatesDTO updates) {
        Session session = this.getSession(sessionToken);
        if (updates.isRegisterSamples()) {
            this.registerSamples(sessionToken, updates.getNewSamples());
        }
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.update(updates);
        experimentBO.save();
        ExperimentUpdateResult result = new ExperimentUpdateResult();
        ExperimentPE experiment = experimentBO.getExperiment();
        result.setVersion(experiment.getVersion());
        result.setSamples(this.getDAOFactory().getExperimentDAO().getSampleCodes(experiment));
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public Date updateMaterial(String sessionToken, TechId materialId, List<IEntityProperty> properties, String[] metaprojects, Date version) {
        return this.commonServer.updateMaterial(sessionToken, materialId, properties, metaprojects, version);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public SampleUpdateResult updateSample(String sessionToken, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO updates) {
        return this.commonServer.updateSample(sessionToken, updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_DATASET")
    public DataSetUpdateResult updateDataSet(String sessionToken, @AuthorizationGuard(guardClass=DataSetUpdatesPredicate.class) DataSetUpdatesDTO updates) {
        return this.commonServer.updateDataSet(sessionToken, updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public void registerOrUpdateMaterials(String sessionToken, List<NewMaterialsWithTypes> materials) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        Session session = this.getSession(sessionToken);
        MaterialHelper materialHelper = this.getMaterialHelper(session);
        for (NewMaterialsWithTypes materialsWithTypes : materials) {
            String materialTypeCode = ((MaterialType)materialsWithTypes.getEntityType()).getCode();
            if (materialsWithTypes.isAllowUpdateIfExist()) {
                materialHelper.registerOrUpdateMaterials(materialTypeCode, materialsWithTypes.getNewEntities());
                continue;
            }
            this.registerMaterials(materialHelper, materialsWithTypes);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public void registerOrUpdateMaterialsAsync(final String sessionToken, final List<NewMaterialsWithTypes> materials, String userEmail) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        this.checkSession(sessionToken);
        this.executeASync(userEmail, new AbstractASyncAction(){

            @Override
            public String getName() {
                return "Material Batch Registration";
            }

            @Override
            protected void doActionOrThrowException(Writer messageWriter) {
                GenericServer.this.genericServer.registerOrUpdateMaterials(sessionToken, materials);
            }
        });
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE")
    public void registerExperiments(String sessionToken, @AuthorizationGuard(guardClass=NewExperimentsWithTypePredicate.class) NewExperimentsWithType experiments) throws UserFailureException {
        assert (experiments != null) : "Unspecified experiments.";
        assert (sessionToken != null) : "Unspecified session token.";
        assert (experiments.getExperimentTypeCode() != null) : "Experiments type not specified";
        assert (experiments.getNewExperiments() != null) : "Experiments collection not specified";
        Session session = this.getSession(sessionToken);
        List<NewBasicExperiment> newExperiments = experiments.getNewExperiments();
        if (newExperiments.size() == 0) {
            return;
        }
        ServerUtils.prevalidate(newExperiments, "experiment");
        ExperimentTypePE experimentTypePE = (ExperimentTypePE)this.getDAOFactory().getEntityTypeDAO(EntityKind.EXPERIMENT).tryToFindEntityTypeByCode(experiments.getExperimentTypeCode());
        if (experimentTypePE == null) {
            throw UserFailureException.fromTemplate("Experiment type with code '%s' does not exist.", experimentTypePE);
        }
        this.getPropertiesBatchManager().manageProperties(experimentTypePE, newExperiments, session.tryGetPerson());
        BatchOperationExecutor.executeInBatches(new ExperimentBatchRegistration(this.businessObjectFactory.createExperimentTable(session), newExperiments, experimentTypePE));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE")
    public void updateExperiments(String sessionToken, @AuthorizationGuard(guardClass=UpdatedExperimentsWithTypePredicate.class) UpdatedExperimentsWithType experiments) throws UserFailureException {
        assert (experiments != null) : "Unspecified experiments.";
        assert (sessionToken != null) : "Unspecified session token.";
        assert (experiments.getExperimentType() != null) : "Experiments type not specified";
        assert (experiments.getUpdatedExperiments() != null) : "Experiments collection not specified";
        Session session = this.getSession(sessionToken);
        List<UpdatedBasicExperiment> newExperiments = experiments.getUpdatedExperiments();
        if (newExperiments.size() == 0) {
            return;
        }
        ServerUtils.prevalidate(newExperiments, "experiment");
        ExperimentTypePE experimentTypePE = (ExperimentTypePE)this.getDAOFactory().getEntityTypeDAO(EntityKind.EXPERIMENT).tryToFindEntityTypeByCode(experiments.getExperimentType().getCode());
        if (experimentTypePE == null) {
            throw UserFailureException.fromTemplate("Experiment type with code '%s' does not exist.", experimentTypePE);
        }
        this.getPropertiesBatchManager().manageProperties(experimentTypePE, newExperiments, session.tryGetPerson());
        BatchOperationExecutor.executeInBatches(new ExperimentBatchUpdate(this.businessObjectFactory.createExperimentTable(session), this.convertExperiments(newExperiments), experimentTypePE));
    }

    private List<ExperimentBatchUpdatesDTO> convertExperiments(List<UpdatedBasicExperiment> updatedExperiments) {
        ArrayList<ExperimentBatchUpdatesDTO> experiments = new ArrayList<ExperimentBatchUpdatesDTO>();
        for (NewBasicExperiment newBasicExperiment : updatedExperiments) {
            boolean isProjectUpdateRequested;
            ExperimentIdentifier newExperimentIdentifier;
            assert (newBasicExperiment instanceof UpdatedBasicExperiment);
            UpdatedBasicExperiment updatedExperiment = (UpdatedBasicExperiment)newBasicExperiment;
            ExperimentIdentifier oldExperimentIdentifier = new ExperimentIdentifierFactory(updatedExperiment.getIdentifier().toUpperCase()).createIdentifier();
            List<IEntityProperty> properties = Arrays.asList(updatedExperiment.getProperties());
            String projectIdentifierOrNull = updatedExperiment.getNewProjectIdentifierOrNull();
            String string = projectIdentifierOrNull = projectIdentifierOrNull != null ? projectIdentifierOrNull.trim() : null;
            if (projectIdentifierOrNull != null && projectIdentifierOrNull.length() > 0) {
                ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(projectIdentifierOrNull.toUpperCase()).createIdentifier();
                newExperimentIdentifier = new ExperimentIdentifier(projectIdentifier, oldExperimentIdentifier.getExperimentCode());
                isProjectUpdateRequested = true;
            } else {
                newExperimentIdentifier = oldExperimentIdentifier;
                isProjectUpdateRequested = false;
            }
            experiments.add(new ExperimentBatchUpdatesDTO(oldExperimentIdentifier, properties, newExperimentIdentifier, updatedExperiment.getBatchUpdateDetails(), isProjectUpdateRequested));
        }
        return experiments;
    }

    private MaterialHelper getMaterialHelper(Session session) {
        MaterialHelper materialHelper = new MaterialHelper(session, this.businessObjectFactory, this.getDAOFactory(), this.getPropertiesBatchManager(), this.managedPropertyEvaluatorFactory);
        return materialHelper;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE_MATERIAL")
    public void registerOrUpdateSamplesAndMaterials(String sessionToken, List<NewSamplesWithTypes> newSamplesWithType, List<NewMaterialsWithTypes> newMaterialsWithType) throws UserFailureException {
        EntityExistenceChecker entityExistenceChecker = new EntityExistenceChecker(this.getDAOFactory());
        entityExistenceChecker.checkNewMaterials(newMaterialsWithType);
        entityExistenceChecker.checkNewSamples(newSamplesWithType);
        List<String> errors = entityExistenceChecker.getErrors();
        int size = errors.size();
        if (size > 0) {
            String errorString = "Found " + (size == 1 ? " one error:" : String.valueOf(size) + " errors:");
            for (String error : errors) {
                errorString = String.valueOf(errorString) + "\n" + error;
            }
            throw new UserFailureException(errorString);
        }
        this.registerOrUpdateMaterials(sessionToken, newMaterialsWithType);
        this.privateRegisterOrUpdateSamples(sessionToken, newSamplesWithType);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE_MATERIAL")
    public void registerOrUpdateSamplesAndMaterialsAsync(final String sessionToken, final List<NewSamplesWithTypes> newSamplesWithType, final List<NewMaterialsWithTypes> newMaterialsWithType, String userEmail) throws UserFailureException {
        this.executeASync(userEmail, new AbstractASyncAction(){

            @Override
            public String getName() {
                return "General Batch Import";
            }

            @Override
            protected void doActionOrThrowException(Writer messageWriter) {
                GenericServer.this.genericServer.registerOrUpdateSamplesAndMaterials(sessionToken, newSamplesWithType, newMaterialsWithType);
            }
        });
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE_MATERIAL")
    public void registerOrUpdateSamplesAsync(final String sessionToken, final @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> newSamplesWithType, String userEmail) throws UserFailureException {
        this.executeASync(userEmail, new AbstractASyncAction(){

            @Override
            public String getName() {
                return "General Batch Import";
            }

            @Override
            protected void doActionOrThrowException(Writer messageWriter) {
                GenericServer.this.genericServer.registerOrUpdateSamples(sessionToken, newSamplesWithType);
            }
        });
    }

    private class SampleBatchRegisterOrUpdate
    implements IBatchOperation<NewSample> {
        private final List<NewSample> entities;
        private final SampleType sampleType;
        private final ISampleLister sampleLister;
        private final Session session;

        public SampleBatchRegisterOrUpdate(ISampleLister sampleLister, List<NewSample> entities, SampleType sampleType, Session session) {
            this.sampleLister = sampleLister;
            this.entities = entities;
            this.sampleType = sampleType;
            this.session = session;
        }

        @Override
        public void execute(List<NewSample> newSamples) {
            String homeSpace = this.session.tryGetHomeGroupCode();
            HashSet<String> containerCodes = new HashSet<String>();
            for (NewSample sample : newSamples) {
                NormalizedSampleIdentifier id = new NormalizedSampleIdentifier(sample, homeSpace);
                sample.setIdentifier(id.getSampleIdentifier());
                sample.setCurrentContainerIdentifier(id.getContainerIdentifier());
                if (id.getContainerIdentifier() != null && id.getContainerIdentifier().length() != 0) {
                    containerCodes.add(id.getContainerCode());
                    continue;
                }
                containerCodes.add(id.getCode());
            }
            HashSet<NormalizedSampleIdentifier> existingSampleCodes = new HashSet<NormalizedSampleIdentifier>();
            HashSet<Long> containerIds = new HashSet<Long>();
            for (Sample sample : this.sampleLister.list(new ListOrSearchSampleCriteria(containerCodes.toArray(new String[0]), false))) {
                existingSampleCodes.add(new NormalizedSampleIdentifier(sample));
                containerIds.add(sample.getId());
            }
            for (Sample sample : this.sampleLister.list(new ListOrSearchSampleCriteria(ListOrSearchSampleCriteria.createForContainers(containerIds)))) {
                existingSampleCodes.add(new NormalizedSampleIdentifier(sample));
            }
            ArrayList<NewSample> samplesToRegister = new ArrayList<NewSample>();
            ArrayList<NewSample> samplesToUpdate = new ArrayList<NewSample>();
            for (NewSample sample : newSamples) {
                NormalizedSampleIdentifier id = new NormalizedSampleIdentifier(sample, homeSpace);
                if (existingSampleCodes.contains(id)) {
                    samplesToUpdate.add(sample);
                    continue;
                }
                samplesToRegister.add(sample);
            }
            GenericServer.this.registerSamples(this.session, new NewSamplesWithTypes(this.sampleType, (List<NewSample>)samplesToRegister), this.session.tryGetPerson());
            GenericServer.this.updateSamples(this.session, new NewSamplesWithTypes(this.sampleType, (List<NewSample>)samplesToUpdate));
        }

        @Override
        public List<NewSample> getAllEntities() {
            return this.entities;
        }

        @Override
        public String getEntityName() {
            return "sample";
        }

        @Override
        public String getOperationName() {
            return "update/register preprocessing";
        }
    }
}

