/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.utils;

import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.Constants;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Validator;

public class CifexValidator {
    public static Validator getUserFieldValidator() {
        return new Validator(){

            public String validate(Field<?> field, String value) {
                String[] result = value.split("[,\\s]+");
                if (result.length == 0) {
                    return MessageDictionary.msg(MessageDictionary.VALIDATION_REQUIRED_BLANK_MSG);
                }
                int i = 0;
                while (i < result.length) {
                    if (!$assertionsDisabled && result[i] == null) {
                        throw new AssertionError((Object)"Must not be null.");
                    }
                    String item = result[i].trim();
                    if (item.length() > 0 && !StringUtils.matches("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$", item) && !StringUtils.matches(Constants.USER_CODE_WITH_ID_PREFIX_REGEX, item, "i")) {
                        return MessageDictionary.msg(MessageDictionary.UPLOAD_FILES_RECIPIENT_FIELD_INVALID_MSG);
                    }
                    ++i;
                }
                return null;
            }
        };
    }

    public static Validator getEmailFieldValidator() {
        return new Validator(){

            public String validate(Field<?> field, String value) {
                if (value == null) {
                    return MessageDictionary.msg(MessageDictionary.VALIDATION_REQUIRED_BLANK_MSG);
                }
                String item = value.trim();
                if (item.length() == 0) {
                    return MessageDictionary.msg(MessageDictionary.VALIDATION_REQUIRED_BLANK_MSG);
                }
                if (!StringUtils.matches("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$", item)) {
                    return MessageDictionary.msg(MessageDictionary.VALIDATION_EMAIL_MSG);
                }
                return null;
            }
        };
    }

    public static Validator getUserCodeFieldValidator() {
        return new Validator(){

            public String validate(Field<?> field, String value) {
                if (value == null || value.length() == 0) {
                    return MessageDictionary.msg(MessageDictionary.VALIDATION_REQUIRED_BLANK_MSG);
                }
                if (!StringUtils.matches("^([a-zA-Z0-9_\\.\\-\\@])+$", value)) {
                    return MessageDictionary.msg(MessageDictionary.VALIDATION_WRONG_USERCODE_MSG);
                }
                return null;
            }
        };
    }
}

