/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.HDF5StringReader;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5StringWriter;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

public class HDF5StringWriter
extends HDF5StringReader
implements IHDF5StringWriter {
    private static final int MAX_COMPACT_SIZE = 65524;
    private final HDF5BaseWriter baseWriter;

    HDF5StringWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttrVL(final String objectPath, final String name, final String value) {
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openObject(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, registry);
                HDF5StringWriter.this.baseWriter.setStringAttributeVariableLength(objectId, name, value, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setAttr(String objectPath, String name, String value) {
        this.setStringAttribute(objectPath, name, value, value.length(), true);
    }

    @Override
    public void setAttr(String objectPath, String name, String value, int maxLength) {
        this.setStringAttribute(objectPath, name, value, maxLength, false);
    }

    void setStringAttribute(final String objectPath, final String name, final String value, final int maxLength, final boolean lengthFitsValue) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openObject(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, registry);
                HDF5StringWriter.this.baseWriter.setStringAttribute(objectId, name, value, maxLength, lengthFitsValue, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setArrayAttr(String objectPath, String name, String[] value) {
        this.setStringArrayAttribute(objectPath, name, value, -1, true);
    }

    @Override
    public void setArrayAttr(String objectPath, String name, String[] value, int maxLength) {
        this.setStringArrayAttribute(objectPath, name, value, maxLength, false);
    }

    void setStringArrayAttribute(final String objectPath, final String name, final String[] value, final int maxLength, final boolean lengthFitsValue) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openObject(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, registry);
                HDF5StringWriter.this.baseWriter.setStringArrayAttribute(objectId, name, value, maxLength, lengthFitsValue, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(String objectPath, String name, MDArray<String> value) {
        this.setStringMDArrayAttribute(objectPath, name, value, -1, true);
    }

    @Override
    public void setMDArrayAttr(String objectPath, String name, MDArray<String> value, int maxLength) {
        this.setStringMDArrayAttribute(objectPath, name, value, maxLength, false);
    }

    void setStringMDArrayAttribute(final String objectPath, final String name, final MDArray<String> value, final int maxLength, final boolean lengthFitsValue) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openObject(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, registry);
                HDF5StringWriter.this.baseWriter.setStringArrayAttribute(objectId, name, (MDArray<String>)value, maxLength, lengthFitsValue, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void write(String objectPath, String data, int maxLength) {
        this.writeString(objectPath, data, maxLength, true, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void write(String objectPath, String data) {
        this.writeString(objectPath, data, data.length(), true, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void write(String objectPath, String data, HDF5GenericStorageFeatures features) {
        this.writeString(objectPath, data, data.length(), true, features);
    }

    @Override
    public void write(String objectPath, String data, int maxLength, HDF5GenericStorageFeatures features) {
        this.writeString(objectPath, data, maxLength, false, features);
    }

    void writeString(final String objectPath, final String data, final int maxLength, final boolean lengthFitsValue, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int realMaxLengthInBytes;
                byte[] bytes;
                if (lengthFitsValue) {
                    bytes = StringUtils.toBytes0Term(data, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets);
                    realMaxLengthInBytes = bytes.length == 1 ? 1 : bytes.length - 1;
                } else {
                    bytes = StringUtils.toBytes0Term(data, maxLength, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets);
                    realMaxLengthInBytes = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets.getMaxBytesPerChar() * (maxLength == 0 ? 1 : maxLength);
                }
                boolean exists = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.exists(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath);
                if (exists && !HDF5StringWriter.this.baseWriter.keepDataIfExists(features)) {
                    ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.deleteObject(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath);
                    exists = false;
                }
                int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(realMaxLengthInBytes, registry);
                if (!features.requiresChunking()) {
                    HDF5StringWriter.this.baseWriter.writeScalar(objectPath, stringDataTypeId, stringDataTypeId, bytes, features.allowsCompact() && realMaxLengthInBytes < 65524, HDF5StringWriter.this.baseWriter.keepDataIfExists(features), registry);
                } else {
                    int dataSetId;
                    long[] chunkSizeOrNull = HDF5Utils.tryGetChunkSizeForString(realMaxLengthInBytes, features.requiresChunking());
                    if (exists) {
                        dataSetId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openDataSet(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, registry);
                    } else {
                        HDF5StorageLayout layout = HDF5StringWriter.this.baseWriter.determineLayout(stringDataTypeId, HDF5Utils.SCALAR_DIMENSIONS, chunkSizeOrNull, null);
                        dataSetId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataSet(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, HDF5Utils.SCALAR_DIMENSIONS, chunkSizeOrNull, stringDataTypeId, features, objectPath, layout, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileFormat, registry);
                    }
                    H5D.H5Dwrite(dataSetId, stringDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, bytes);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArray(String objectPath, String[] data, HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.writeStringArray(objectPath, data, HDF5StringWriter.getMaxLength(data), true, features, false);
    }

    @Override
    public void writeArray(String objectPath, String[] data) {
        assert (objectPath != null);
        assert (data != null);
        this.writeStringArray(objectPath, data, HDF5StringWriter.getMaxLength(data), true, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, false);
    }

    @Override
    public void writeArray(String objectPath, String[] data, int maxLength) {
        this.writeStringArray(objectPath, data, maxLength, false, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, false);
    }

    private static int getMaxLength(String[] data) {
        int maxLength = 0;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            maxLength = Math.max(maxLength, s.length());
            ++n2;
        }
        return maxLength;
    }

    @Override
    public void writeArray(String objectPath, String[] data, int maxLength, HDF5GenericStorageFeatures features) throws HDF5JavaException {
        assert (maxLength >= 0);
        this.writeStringArray(objectPath, data, maxLength, false, features, false);
    }

    private void writeStringArray(final String objectPath, final String[] data, final int maxLength, final boolean lengthFitsValue, final HDF5GenericStorageFeatures features, final boolean variableLength) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                if (variableLength) {
                    int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                    int dataSetId = HDF5StringWriter.this.baseWriter.getOrCreateDataSetId(objectPath, stringDataTypeId, new long[]{data.length}, 8, features, registry);
                    HDF5StringWriter.this.baseWriter.writeStringVL(dataSetId, data);
                } else {
                    HDF5BaseWriter hDF5BaseWriter = HDF5StringWriter.this.baseWriter;
                    hDF5BaseWriter.getClass();
                    HDF5BaseWriter.StringArrayBuffer array = hDF5BaseWriter.new HDF5BaseWriter.StringArrayBuffer(maxLength, lengthFitsValue);
                    array.addAll(data);
                    byte[] arrData = array.toArray();
                    int elementSize = array.getMaxLengthInByte();
                    int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(elementSize, registry);
                    int dataSetId = HDF5StringWriter.this.baseWriter.getOrCreateDataSetId(objectPath, stringDataTypeId, new long[]{data.length}, elementSize, features, registry);
                    H5D.H5Dwrite(dataSetId, stringDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, arrData);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(String objectPath, int maxLength, int size) {
        this.createArray(objectPath, maxLength, size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, int maxLength, long size, int blockSize) {
        this.createArray(objectPath, maxLength, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, int maxLength, int size, HDF5GenericStorageFeatures features) {
        assert (maxLength > 0);
        this.createStringArray(objectPath, maxLength, size, features, false);
    }

    private void createStringArray(final String objectPath, final int maxLength, final int size, final HDF5GenericStorageFeatures features, final boolean variableLength) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int stringDataTypeId;
                int elementSize;
                if (variableLength) {
                    elementSize = 8;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                } else {
                    elementSize = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets.getMaxBytesPerChar() * maxLength;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(elementSize, registry);
                }
                if (features.requiresChunking()) {
                    HDF5StringWriter.this.baseWriter.createDataSet(objectPath, stringDataTypeId, features, new long[1], new long[]{size}, elementSize, registry);
                } else {
                    HDF5StringWriter.this.baseWriter.createDataSet(objectPath, stringDataTypeId, features, new long[]{size}, null, elementSize, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(String objectPath, int maxLength, long size, int blockSize, HDF5GenericStorageFeatures features) {
        assert (maxLength > 0);
        this.createStringArray(objectPath, maxLength, size, blockSize, features, false);
    }

    private void createStringArray(final String objectPath, final int maxLength, final long size, final int blockSize, final HDF5GenericStorageFeatures features, final boolean variableLength) {
        assert (objectPath != null);
        assert (blockSize > 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int stringDataTypeId;
                int elementSize;
                if (variableLength) {
                    elementSize = 8;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                } else {
                    elementSize = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets.getMaxBytesPerChar() * maxLength;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(elementSize, registry);
                }
                HDF5StringWriter.this.baseWriter.createDataSet(objectPath, stringDataTypeId, features, new long[]{size}, new long[]{blockSize}, elementSize, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArrayBlock(String objectPath, String[] data, long blockNumber) {
        assert (data != null);
        this.writeArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final String[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.getDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.isVariableLengthString(stringDataTypeId)) {
                    HDF5StringWriter.this.baseWriter.writeStringVL(dataSetId, memorySpaceId, dataSpaceId, data);
                } else {
                    int maxLength = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.getDataTypeSize(stringDataTypeId);
                    HDF5StringWriter.this.writeStringArray(dataSetId, stringDataTypeId, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data, maxLength);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArray(String objectPath, MDArray<String> data) throws HDF5JavaException {
        this.writeStringMDArray(objectPath, data, HDF5StringWriter.getMaxLength((String[])data.getAsFlatArray()), true, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, false);
    }

    @Override
    public void writeMDArray(String objectPath, MDArray<String> data, HDF5GenericStorageFeatures features) throws HDF5JavaException {
        this.writeStringMDArray(objectPath, data, HDF5StringWriter.getMaxLength((String[])data.getAsFlatArray()), true, features, false);
    }

    @Override
    public void writeMDArray(String objectPath, MDArray<String> data, int maxLength) throws HDF5JavaException {
        this.writeMDArray(objectPath, data, maxLength, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeMDArray(String objectPath, MDArray<String> data, int maxLength, HDF5GenericStorageFeatures features) throws HDF5JavaException {
        this.writeStringMDArray(objectPath, data, maxLength, false, features, false);
    }

    private void writeStringMDArray(final String objectPath, final MDArray<String> data, final int maxLength, final boolean lengthFitsValue, final HDF5GenericStorageFeatures features, final boolean variableLength) {
        assert (objectPath != null);
        assert (data != null);
        assert (maxLength >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                if (variableLength) {
                    int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                    int dataSetId = HDF5StringWriter.this.baseWriter.getOrCreateDataSetId(objectPath, stringDataTypeId, data.longDimensions(), 8, features, registry);
                    HDF5StringWriter.this.baseWriter.writeStringVL(dataSetId, (String[])data.getAsFlatArray());
                } else {
                    HDF5BaseWriter hDF5BaseWriter = HDF5StringWriter.this.baseWriter;
                    hDF5BaseWriter.getClass();
                    HDF5BaseWriter.StringArrayBuffer array = hDF5BaseWriter.new HDF5BaseWriter.StringArrayBuffer(maxLength, lengthFitsValue);
                    array.addAll((String[])data.getAsFlatArray());
                    byte[] arrData = array.toArray();
                    int elementSize = array.getMaxLengthInByte();
                    int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(elementSize, registry);
                    int dataSetId = HDF5StringWriter.this.baseWriter.getOrCreateDataSetId(objectPath, stringDataTypeId, data.longDimensions(), elementSize, features, registry);
                    H5D.H5Dwrite(dataSetId, stringDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, arrData);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createMDArray(String objectPath, int maxLength, int[] dimensions) {
        this.createMDArray(objectPath, maxLength, dimensions, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, int maxLength, long[] dimensions, int[] blockSize) {
        this.createMDArray(objectPath, maxLength, dimensions, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, int maxLength, int[] dimensions, HDF5GenericStorageFeatures features) {
        assert (maxLength > 0);
        this.createStringMDArray(objectPath, maxLength, dimensions, features, false);
    }

    private void createStringMDArray(final String objectPath, final int maxLength, final int[] dimensions, final HDF5GenericStorageFeatures features, final boolean variableLength) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int stringDataTypeId;
                if (variableLength) {
                    int elementSize = 8;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                } else {
                    int elementSize = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets.getMaxBytesPerChar() * maxLength;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(elementSize, registry);
                }
                if (features.requiresChunking()) {
                    HDF5StringWriter.this.baseWriter.createDataSet(objectPath, stringDataTypeId, features, new long[1], MDAbstractArray.toLong((int[])dimensions), maxLength, registry);
                } else {
                    HDF5StringWriter.this.baseWriter.createDataSet(objectPath, stringDataTypeId, features, MDAbstractArray.toLong((int[])dimensions), null, maxLength, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createMDArray(String objectPath, int maxLength, long[] dimensions, int[] blockSize, HDF5GenericStorageFeatures features) {
        assert (maxLength > 0);
        this.createStringMDArray(objectPath, maxLength, dimensions, blockSize, features, false);
    }

    private void createStringMDArray(final String objectPath, final int maxLength, final long[] dimensions, final int[] blockSize, final HDF5GenericStorageFeatures features, final boolean variableLength) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int stringDataTypeId;
                int elementSize;
                if (variableLength) {
                    elementSize = 8;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                } else {
                    elementSize = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.encodingForNewDataSets.getMaxBytesPerChar() * maxLength;
                    stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createDataTypeString(elementSize, registry);
                }
                HDF5StringWriter.this.baseWriter.createDataSet(objectPath, stringDataTypeId, features, dimensions, MDAbstractArray.toLong((int[])blockSize), elementSize, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, MDArray<String> data, long[] blockNumber) {
        assert (data != null);
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDArray<String> data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.getDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.isVariableLengthString(stringDataTypeId)) {
                    HDF5StringWriter.this.baseWriter.writeStringVL(dataSetId, memorySpaceId, dataSpaceId, (String[])data.getAsFlatArray());
                } else {
                    int maxLength = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.getDataTypeSize(stringDataTypeId);
                    HDF5StringWriter.this.writeStringArray(dataSetId, stringDataTypeId, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, (String[])data.getAsFlatArray(), maxLength);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeVL(final String objectPath, final String data) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.exists(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath) ? ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.openObject(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, objectPath, registry) : ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.h5.createScalarDataSet(((HDF5StringWriter)HDF5StringWriter.this).baseWriter.fileId, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId, objectPath, true, registry);
                H5D.H5DwriteString(dataSetId, ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new String[]{data});
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArrayVL(String objectPath, String[] data) {
        this.writeArrayVL(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeArrayVL(String objectPath, String[] data, HDF5GenericStorageFeatures features) {
        this.writeStringArray(objectPath, data, -1, false, features, true);
    }

    @Override
    public void createArrayVL(String objectPath, int size) {
        this.createArrayVL(objectPath, size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArrayVL(String objectPath, long size, int blockSize) throws HDF5JavaException {
        this.createArrayVL(objectPath, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createArrayVL(String objectPath, long size, int blockSize, HDF5GenericStorageFeatures features) {
        this.createStringArray(objectPath, -1, size, blockSize, features, true);
    }

    @Override
    public void createArrayVL(String objectPath, int size, HDF5GenericStorageFeatures features) {
        this.createStringArray(objectPath, -1, size, features, true);
    }

    @Override
    public void createMDArrayVL(String objectPath, int[] dimensions, HDF5GenericStorageFeatures features) {
        this.createStringMDArray(objectPath, -1, dimensions, features, true);
    }

    @Override
    public void createMDArrayVL(String objectPath, int[] dimensions) {
        this.createStringMDArray(objectPath, -1, dimensions, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, true);
    }

    @Override
    public void createMDArrayVL(String objectPath, long[] dimensions, int[] blockSize, HDF5GenericStorageFeatures features) {
        this.createStringMDArray(objectPath, -1, dimensions, blockSize, features, true);
    }

    @Override
    public void createMDArrayVL(String objectPath, long[] dimensions, int[] blockSize) {
        this.createStringMDArray(objectPath, -1, dimensions, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION, true);
    }

    @Override
    public void writeMDArrayVL(final String objectPath, final MDArray<String> data, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> writeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int stringDataTypeId = ((HDF5StringWriter)HDF5StringWriter.this).baseWriter.variableLengthStringDataTypeId;
                int dataSetId = HDF5StringWriter.this.baseWriter.getOrCreateDataSetId(objectPath, stringDataTypeId, MDAbstractArray.toLong((int[])data.dimensions()), 8, features, registry);
                HDF5StringWriter.this.baseWriter.writeStringVL(dataSetId, (String[])data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayVL(String objectPath, MDArray<String> data) {
        this.writeMDArrayVL(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    private int writeStringArray(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, String[] obj, int maxLength) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        byte[] buf = StringUtils.toBytes(obj, maxLength, this.baseWriter.encodingForNewDataSets);
        int status = H5D.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf);
        return status;
    }
}

