/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ReadParams;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsReaderLibrary;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.widget.ScrollingImagePanel;

public class BioFormatsImageViewer {
    public static void main(String[] args) {
        String[] myArgs = args;
        if (myArgs.length == 0) {
            FileDialog fileDialog = new FileDialog(null);
            fileDialog.setMode(0);
            fileDialog.setVisible(true);
            String dir = fileDialog.getDirectory();
            myArgs = new String[]{String.valueOf(dir) + "/" + fileDialog.getFile()};
        }
        String[] stringArray = myArgs;
        int n = myArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IImageReader reader = new BioFormatsReaderLibrary().tryGetReaderForFile(fileName);
            System.out.println("=========== File: " + fileName);
            System.out.println("Reader: " + reader);
            File file = new File(fileName);
            ReadParams readParams = new ReadParams();
            readParams.setIntensityRescalingChannel(Integer.valueOf(0));
            BufferedImage image = reader.readImage(file, ImageID.NULL, (IReadParams)readParams);
            BioFormatsImageViewer.showImage(image, fileName);
            ++n2;
        }
    }

    private static void showImage(RenderedImage image, String fileName) {
        Frame frame = new Frame("Image: " + fileName);
        ScrollingImagePanel panel = new ScrollingImagePanel(image, image.getWidth() + 10, image.getHeight() + 10);
        frame.add((Component)panel);
        frame.setLocationByPlatform(true);
        frame.pack();
        frame.setVisible(true);
    }
}

