/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.DeleteFromArchiveException;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryVisitor;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndex;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

class HDF5ArchiveDeleter {
    private final IHDF5Writer hdf5Writer;
    private final IDirectoryIndexProvider indexProvider;
    private final IdCache idCache;

    public HDF5ArchiveDeleter(IHDF5Writer hdf5Writer, IDirectoryIndexProvider indexProvider, IdCache idCache) {
        this.hdf5Writer = hdf5Writer;
        this.indexProvider = indexProvider;
        this.idCache = idCache;
    }

    public HDF5ArchiveDeleter delete(List<String> hdf5ObjectPaths, IArchiveEntryVisitor entryVisitorOrNull) {
        for (String path : hdf5ObjectPaths) {
            String normalizedPath = Utils.normalizePath(path);
            String group = Utils.getParentPath(normalizedPath);
            IDirectoryIndex index = this.indexProvider.get(group, false);
            try {
                String name = Utils.getName(normalizedPath);
                LinkRecord link = index.tryGetLink(name);
                if (link == null) {
                    link = LinkRecord.tryReadFromArchive((IHDF5Reader)this.hdf5Writer, normalizedPath);
                }
                if (link == null) continue;
                this.hdf5Writer.delete(normalizedPath);
                index.remove(name);
                if (entryVisitorOrNull == null) continue;
                ArchiveEntry entry = new ArchiveEntry(group, normalizedPath, link, this.idCache);
                entryVisitorOrNull.visit(entry);
            }
            catch (HDF5Exception ex) {
                this.indexProvider.getErrorStrategy().dealWithError(new DeleteFromArchiveException(path, ex));
            }
        }
        return this;
    }
}

