/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import loci.formats.UpgradeChecker;
import loci.plugins.BF;

public class Updater
implements PlugIn {
    private static final String TRUNK = "Trunk build";
    private static final String DAILY = "Daily build";
    private static final String STABLE = "Stable build (4.4.10)";
    private static final boolean IS_FIJI = IJ.getInstance().getTitle().indexOf("Fiji") >= 0;
    public boolean canceled;
    private String urlPath;

    public void run(String arg) {
        GenericDialog upgradeDialog = new GenericDialog("Update LOCI Plugins");
        String[] options = new String[]{TRUNK, DAILY, STABLE};
        upgradeDialog.addChoice("Release", options, options[0]);
        upgradeDialog.showDialog();
        if (upgradeDialog.wasCanceled()) {
            this.canceled = true;
            return;
        }
        String release = upgradeDialog.getNextChoice();
        if (release.equals(TRUNK)) {
            this.urlPath = "http://ci.openmicroscopy.org/job/BIOFORMATS-trunk/lastSuccessfulBuild/artifact/artifacts/";
        } else if (release.equals(DAILY)) {
            this.urlPath = "http://ci.openmicroscopy.org/job/BIOFORMATS-daily/lastSuccessfulBuild/artifact/artifacts/";
        } else if (release.equals(STABLE)) {
            this.urlPath = "http://cvs.openmicroscopy.org.uk/snapshots/bioformats/4.4.10/";
        }
        if (!IS_FIJI) {
            this.urlPath = this.urlPath + "loci_tools.jar";
        }
        Updater.install(this.urlPath);
    }

    public static void install(String urlPath) {
        String pluginsDirectory;
        String jarPath = pluginsDirectory = IJ.getDirectory((String)"plugins");
        if (!IS_FIJI) {
            jarPath = jarPath + "loci_tools.jar";
        }
        BF.status(false, "Downloading...");
        boolean success = false;
        if (IS_FIJI) {
            jarPath = new File(jarPath).getParent();
            success = true;
            UpgradeChecker upgrader = new UpgradeChecker();
            for (String file2 : UpgradeChecker.INDIVIDUAL_JARS) {
                String url;
                boolean localSuccess;
                BF.status(false, "Download " + file2);
                String foundFile = Updater.find(jarPath, file2);
                if (foundFile == null) {
                    foundFile = jarPath + File.separator + "jars" + File.separator + file2;
                }
                if (localSuccess = upgrader.install(url = urlPath + File.separator + file2, foundFile)) continue;
                success = false;
            }
        } else {
            success = new UpgradeChecker().install(urlPath, jarPath);
        }
        BF.status(false, "");
        if (!success) {
            IJ.showMessage((String)"An error occurred while downloading the LOCI plugins");
        } else {
            IJ.showMessage((String)"The LOCI plugins have been downloaded.\nPlease restart ImageJ to complete the upgrade process.");
        }
    }

    private static String find(String dir, String filename) {
        String[] list;
        File dirFile = new File(dir);
        for (String f : list = dirFile.list()) {
            File nextFile = new File(dirFile, f);
            if (nextFile.isDirectory()) {
                String result = Updater.find(nextFile.getAbsolutePath(), filename);
                if (result == null) continue;
                return result;
            }
            int dot = filename.indexOf(".");
            if (!f.startsWith(filename.substring(0, dot)) || !f.endsWith(filename.substring(dot))) continue;
            return nextFile.getAbsolutePath();
        }
        return null;
    }
}

