/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.validation.AbstractValidator;
import ch.systemsx.cisd.etlserver.validation.IColumnHeaderValidator;
import ch.systemsx.cisd.etlserver.validation.Result;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

class RegExBasedValidator
extends AbstractValidator
implements IColumnHeaderValidator {
    private final Pattern pattern;

    RegExBasedValidator(String regularExpression) {
        this(false, Collections.emptySet(), regularExpression);
    }

    RegExBasedValidator(boolean allowEmptyValues, Set<String> emptyValueSynonyms, String regularExpression) {
        super(allowEmptyValues, emptyValueSynonyms);
        this.pattern = Pattern.compile(regularExpression);
    }

    @Override
    protected void assertValidNonEmptyValue(String value) {
        Result result = this.validateHeader(value);
        if (!result.isValid()) {
            throw new UserFailureException("'" + value + "' is invalid: " + result);
        }
    }

    @Override
    public Result validateHeader(String header) {
        if (this.pattern.matcher(header).matches()) {
            return Result.OK;
        }
        return Result.failure("Does not match the following regular expression: " + this.pattern);
    }
}

